/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.util;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.SimpleMessageDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.FieldDisabledListener;
import org.pentaho.di.ui.core.widget.TableView;

public class ParameterTableHelper {
    private static final int PARAM_COL_1 = 1;
    private static final int PARAM_COL_2 = 2;
    private static final int PARAM_COL_3 = 3;
    private int paramRowNum = -1;
    private int paramColNum = -1;
    private TableView parameterTableView;
    private FieldDisabledListener varDisabledListener;
    private FieldDisabledListener fieldDisabledListener;
    private FieldDisabledListener inputDisabledListener;

    public void setUpDisabledListeners() {
        this.varDisabledListener = rowNr -> {
            this.paramRowNum = rowNr;
            this.paramColNum = 1;
            return false;
        };
        this.fieldDisabledListener = new FieldDisabledListener(){

            @Override
            public boolean isFieldDisabled(String value) {
                return !Utils.isEmpty((CharSequence)value);
            }

            @Override
            public boolean isFieldDisabled(int rowNr) {
                ParameterTableHelper.this.paramRowNum = rowNr;
                ParameterTableHelper.this.paramColNum = 2;
                String field = ((ParameterTableHelper)ParameterTableHelper.this).parameterTableView.table.getItem(rowNr).getText(3);
                return !Utils.isEmpty((CharSequence)field);
            }
        };
        this.inputDisabledListener = new FieldDisabledListener(){

            @Override
            public boolean isFieldDisabled(String value) {
                return !Utils.isEmpty((CharSequence)value);
            }

            @Override
            public boolean isFieldDisabled(int rowNr) {
                ParameterTableHelper.this.paramRowNum = rowNr;
                ParameterTableHelper.this.paramColNum = 3;
                String field = ((ParameterTableHelper)ParameterTableHelper.this).parameterTableView.table.getItem(rowNr).getText(2);
                return !Utils.isEmpty((CharSequence)field);
            }
        };
    }

    public void checkTableOnMod(ModifyEvent modifyEvent) {
        String value = "";
        if (this.paramColNum == 3 && modifyEvent.widget instanceof Text) {
            Text text = (Text)modifyEvent.widget;
            value = text.getText();
            this.parameterTableView.table.getItem(this.paramRowNum).setBackground(2, this.fieldDisabledListener.isFieldDisabled(value) ? GUIResource.getInstance().getColorLightGray() : GUIResource.getInstance().getColorWhite());
        } else if (this.paramColNum == 2) {
            if (modifyEvent.widget instanceof CCombo) {
                CCombo cCombo = (CCombo)modifyEvent.widget;
                value = cCombo.getText();
            } else if (modifyEvent.widget instanceof Text) {
                Text text = (Text)modifyEvent.widget;
                value = text.getText();
            }
            this.parameterTableView.table.getItem(this.paramRowNum).setBackground(3, this.inputDisabledListener.isFieldDisabled(value) ? GUIResource.getInstance().getColorLightGray() : GUIResource.getInstance().getColorWhite());
        }
    }

    public void checkTableOnOpen(TableItem tableItem, int i) {
        if (this.fieldDisabledListener.isFieldDisabled(i)) {
            tableItem.setBackground(2, GUIResource.getInstance().getColorLightGray());
        }
        if (this.inputDisabledListener.isFieldDisabled(i)) {
            tableItem.setBackground(3, GUIResource.getInstance().getColorLightGray());
        }
    }

    public void setParameterTableView(TableView parameterTableView) {
        this.parameterTableView = parameterTableView;
    }

    public FieldDisabledListener getFieldDisabledListener() {
        return this.fieldDisabledListener;
    }

    public FieldDisabledListener getInputDisabledListener() {
        return this.inputDisabledListener;
    }

    public FieldDisabledListener getVarDisabledListener() {
        return this.varDisabledListener;
    }

    public boolean checkParams(Shell shell) {
        if (this.parameterTableView != null) {
            for (int i = 0; i < this.parameterTableView.getItemCount(); ++i) {
                String[] params = this.parameterTableView.getItem(i);
                if (!(!Utils.isEmpty((CharSequence)params[0]) || Utils.isEmpty((CharSequence)params[1]) && Utils.isEmpty((CharSequence)params[2]))) {
                    new SimpleMessageDialog(shell, BaseMessages.getString((String)"Dialog.Parameters.Missing.Parameter.Title"), BaseMessages.getString((String)"Dialog.Parameters.Missing.Parameter.Message"), 1, BaseMessages.getString((String)"System.Button.OK"), 350, 65).open();
                    return true;
                }
                if (Utils.isEmpty((CharSequence)params[0]) || !Utils.isEmpty((CharSequence)params[1]) || !Utils.isEmpty((CharSequence)params[2])) continue;
                new SimpleMessageDialog(shell, BaseMessages.getString((String)"Dialog.Parameters.Missing.Value.Title"), BaseMessages.getString((String)"Dialog.Parameters.Missing.Value.Message"), 1, BaseMessages.getString((String)"System.Button.OK"), 350, 65).open();
                return true;
            }
        }
        return false;
    }
}

