/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.groupby;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.groupby.GroupByMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class GroupByDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = GroupByMeta.class;
    public static final String STRING_SORT_WARNING_PARAMETER = "GroupSortWarning";
    private static final int AGGREGATION_TABLE_TYPE_INDEX = 3;
    private Label wlGroup;
    private TableView wGroup;
    private FormData fdlGroup;
    private FormData fdGroup;
    private Label wlAgg;
    private TableView wAgg;
    private FormData fdlAgg;
    private FormData fdAgg;
    private Label wlAllRows;
    private Button wAllRows;
    private FormData fdlAllRows;
    private FormData fdAllRows;
    private Label wlSortDir;
    private Button wbSortDir;
    private TextVar wSortDir;
    private FormData fdlSortDir;
    private FormData fdbSortDir;
    private FormData fdSortDir;
    private Label wlPrefix;
    private Text wPrefix;
    private FormData fdlPrefix;
    private FormData fdPrefix;
    private Label wlAddLineNr;
    private Button wAddLineNr;
    private FormData fdlAddLineNr;
    private FormData fdAddLineNr;
    private Label wlLineNrField;
    private Text wLineNrField;
    private FormData fdlLineNrField;
    private FormData fdLineNrField;
    private Label wlAlwaysAddResult;
    private Button wAlwaysAddResult;
    private FormData fdlAlwaysAddResult;
    private FormData fdAlwaysAddResult;
    private Button wGet;
    private Button wGetAgg;
    private FormData fdGet;
    private FormData fdGetAgg;
    private Listener lsGet;
    private Listener lsGetAgg;
    private GroupByMeta input;
    private boolean backupAllRows;
    private ColumnInfo[] ciKey;
    private ColumnInfo[] ciReturn;
    private Map<String, Integer> inputFields;

    public GroupByDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (GroupByMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GroupByDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        this.backupAllRows = this.input.passAllRows();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlAllRows = new Label((Composite)this.shell, 131072);
        this.wlAllRows.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.AllRows.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAllRows);
        this.fdlAllRows = new FormData();
        this.fdlAllRows.left = new FormAttachment(0, 0);
        this.fdlAllRows.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdlAllRows.right = new FormAttachment(middle, -margin);
        this.wlAllRows.setLayoutData((Object)this.fdlAllRows);
        this.wAllRows = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wAllRows);
        this.fdAllRows = new FormData();
        this.fdAllRows.left = new FormAttachment(middle, 0);
        this.fdAllRows.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdAllRows.right = new FormAttachment(100, 0);
        this.wAllRows.setLayoutData((Object)this.fdAllRows);
        this.wAllRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupByDialog.this.input.setPassAllRows(!GroupByDialog.this.input.passAllRows());
                GroupByDialog.this.input.setChanged();
                GroupByDialog.this.setFlags();
            }
        });
        this.wlSortDir = new Label((Composite)this.shell, 131072);
        this.wlSortDir.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.TempDir.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSortDir);
        this.fdlSortDir = new FormData();
        this.fdlSortDir.left = new FormAttachment(0, 0);
        this.fdlSortDir.right = new FormAttachment(middle, -margin);
        this.fdlSortDir.top = new FormAttachment((Control)this.wAllRows, margin);
        this.wlSortDir.setLayoutData((Object)this.fdlSortDir);
        this.wbSortDir = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbSortDir);
        this.wbSortDir.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.Browse.Button", (String[])new String[0]));
        this.fdbSortDir = new FormData();
        this.fdbSortDir.right = new FormAttachment(100, 0);
        this.fdbSortDir.top = new FormAttachment((Control)this.wAllRows, margin);
        this.wbSortDir.setLayoutData((Object)this.fdbSortDir);
        this.wSortDir = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSortDir);
        this.wSortDir.addModifyListener(lsMod);
        this.fdSortDir = new FormData();
        this.fdSortDir.left = new FormAttachment(middle, 0);
        this.fdSortDir.top = new FormAttachment((Control)this.wAllRows, margin);
        this.fdSortDir.right = new FormAttachment((Control)this.wbSortDir, -margin);
        this.wSortDir.setLayoutData(this.fdSortDir);
        this.wbSortDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DirectoryDialog dd = new DirectoryDialog(GroupByDialog.this.shell, 0);
                dd.setFilterPath(GroupByDialog.this.wSortDir.getText());
                String dir = dd.open();
                if (dir != null) {
                    GroupByDialog.this.wSortDir.setText(dir);
                }
            }
        });
        this.wSortDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GroupByDialog.this.wSortDir.setToolTipText(GroupByDialog.this.transMeta.environmentSubstitute(GroupByDialog.this.wSortDir.getText()));
            }
        });
        this.wlPrefix = new Label((Composite)this.shell, 131072);
        this.wlPrefix.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.FilePrefix.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPrefix);
        this.fdlPrefix = new FormData();
        this.fdlPrefix.left = new FormAttachment(0, 0);
        this.fdlPrefix.right = new FormAttachment(middle, -margin);
        this.fdlPrefix.top = new FormAttachment((Control)this.wbSortDir, margin * 2);
        this.wlPrefix.setLayoutData((Object)this.fdlPrefix);
        this.wPrefix = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPrefix);
        this.wPrefix.addModifyListener(lsMod);
        this.fdPrefix = new FormData();
        this.fdPrefix.left = new FormAttachment(middle, 0);
        this.fdPrefix.top = new FormAttachment((Control)this.wbSortDir, margin * 2);
        this.fdPrefix.right = new FormAttachment(100, 0);
        this.wPrefix.setLayoutData((Object)this.fdPrefix);
        this.wlAddLineNr = new Label((Composite)this.shell, 131072);
        this.wlAddLineNr.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.AddLineNr.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddLineNr);
        this.fdlAddLineNr = new FormData();
        this.fdlAddLineNr.left = new FormAttachment(0, 0);
        this.fdlAddLineNr.top = new FormAttachment((Control)this.wPrefix, margin);
        this.fdlAddLineNr.right = new FormAttachment(middle, -margin);
        this.wlAddLineNr.setLayoutData((Object)this.fdlAddLineNr);
        this.wAddLineNr = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wAddLineNr);
        this.fdAddLineNr = new FormData();
        this.fdAddLineNr.left = new FormAttachment(middle, 0);
        this.fdAddLineNr.top = new FormAttachment((Control)this.wPrefix, margin);
        this.fdAddLineNr.right = new FormAttachment(100, 0);
        this.wAddLineNr.setLayoutData((Object)this.fdAddLineNr);
        this.wAddLineNr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupByDialog.this.input.setAddingLineNrInGroup(!GroupByDialog.this.input.isAddingLineNrInGroup());
                GroupByDialog.this.input.setChanged();
                GroupByDialog.this.setFlags();
            }
        });
        this.wlLineNrField = new Label((Composite)this.shell, 131072);
        this.wlLineNrField.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.LineNrField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLineNrField);
        this.fdlLineNrField = new FormData();
        this.fdlLineNrField.left = new FormAttachment(0, 0);
        this.fdlLineNrField.right = new FormAttachment(middle, -margin);
        this.fdlLineNrField.top = new FormAttachment((Control)this.wAddLineNr, margin);
        this.wlLineNrField.setLayoutData((Object)this.fdlLineNrField);
        this.wLineNrField = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wLineNrField);
        this.wLineNrField.addModifyListener(lsMod);
        this.fdLineNrField = new FormData();
        this.fdLineNrField.left = new FormAttachment(middle, 0);
        this.fdLineNrField.top = new FormAttachment((Control)this.wAddLineNr, margin);
        this.fdLineNrField.right = new FormAttachment(100, 0);
        this.wLineNrField.setLayoutData((Object)this.fdLineNrField);
        this.wlAlwaysAddResult = new Label((Composite)this.shell, 131072);
        this.wlAlwaysAddResult.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.AlwaysAddResult.Label", (String[])new String[0]));
        this.wlAlwaysAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"GroupByDialog.AlwaysAddResult.ToolTip", (String[])new String[0]));
        this.props.setLook((Control)this.wlAlwaysAddResult);
        this.fdlAlwaysAddResult = new FormData();
        this.fdlAlwaysAddResult.left = new FormAttachment(0, 0);
        this.fdlAlwaysAddResult.top = new FormAttachment((Control)this.wLineNrField, margin);
        this.fdlAlwaysAddResult.right = new FormAttachment(middle, -margin);
        this.wlAlwaysAddResult.setLayoutData((Object)this.fdlAlwaysAddResult);
        this.wAlwaysAddResult = new Button((Composite)this.shell, 32);
        this.wAlwaysAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"GroupByDialog.AlwaysAddResult.ToolTip", (String[])new String[0]));
        this.props.setLook((Control)this.wAlwaysAddResult);
        this.fdAlwaysAddResult = new FormData();
        this.fdAlwaysAddResult.left = new FormAttachment(middle, 0);
        this.fdAlwaysAddResult.top = new FormAttachment((Control)this.wLineNrField, margin);
        this.fdAlwaysAddResult.right = new FormAttachment(100, 0);
        this.wAlwaysAddResult.setLayoutData((Object)this.fdAlwaysAddResult);
        this.wlGroup = new Label((Composite)this.shell, 0);
        this.wlGroup.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.Group.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlGroup);
        this.fdlGroup = new FormData();
        this.fdlGroup.left = new FormAttachment(0, 0);
        this.fdlGroup.top = new FormAttachment((Control)this.wAlwaysAddResult, margin);
        this.wlGroup.setLayoutData((Object)this.fdlGroup);
        int nrKeyCols = 1;
        int nrKeyRows = this.input.getGroupField() != null ? this.input.getGroupField().length : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GroupByDialog.ColumnInfo.GroupField", (String[])new String[0]), 2, new String[]{""}, false);
        this.wGroup = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.top = new FormAttachment((Control)this.wlGroup, margin);
        this.fdGet.right = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)this.fdGet);
        this.fdGroup = new FormData();
        this.fdGroup.left = new FormAttachment(0, 0);
        this.fdGroup.top = new FormAttachment((Control)this.wlGroup, margin);
        this.fdGroup.right = new FormAttachment((Control)this.wGet, -margin);
        this.fdGroup.bottom = new FormAttachment(45, 0);
        this.wGroup.setLayoutData(this.fdGroup);
        this.wlAgg = new Label((Composite)this.shell, 0);
        this.wlAgg.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.Aggregates.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAgg);
        this.fdlAgg = new FormData();
        this.fdlAgg.left = new FormAttachment(0, 0);
        this.fdlAgg.top = new FormAttachment((Control)this.wGroup, margin);
        this.wlAgg.setLayoutData((Object)this.fdlAgg);
        int UpInsCols = 4;
        int UpInsRows = this.input.getAggregateField() != null ? this.input.getAggregateField().length : 1;
        this.ciReturn = new ColumnInfo[UpInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GroupByDialog.ColumnInfo.Name", (String[])new String[0]), 1, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GroupByDialog.ColumnInfo.Subject", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GroupByDialog.ColumnInfo.Type", (String[])new String[0]), 2, GroupByMeta.typeGroupLongDesc);
        this.ciReturn[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GroupByDialog.ColumnInfo.Value", (String[])new String[0]), 1, false);
        this.ciReturn[3].setToolTip(BaseMessages.getString(PKG, (String)"GroupByDialog.ColumnInfo.Value.Tooltip", (String[])new String[0]));
        this.ciReturn[3].setUsingVariables(true);
        this.wAgg = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciReturn, UpInsRows, lsMod, this.props);
        this.wAgg.addModifyListener(modifyEvent -> {
            this.updateAllRowsCheckbox(this.wAgg, this.wAllRows, false);
            this.setFlags();
            this.input.setChanged();
        });
        this.wGetAgg = new Button((Composite)this.shell, 8);
        this.wGetAgg.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.GetLookupFields.Button", (String[])new String[0]));
        this.fdGetAgg = new FormData();
        this.fdGetAgg.top = new FormAttachment((Control)this.wlAgg, margin);
        this.fdGetAgg.right = new FormAttachment(100, 0);
        this.wGetAgg.setLayoutData((Object)this.fdGetAgg);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = GroupByDialog.this.transMeta.findStep(GroupByDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = GroupByDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            GroupByDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        GroupByDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        GroupByDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.fdAgg = new FormData();
        this.fdAgg.left = new FormAttachment(0, 0);
        this.fdAgg.top = new FormAttachment((Control)this.wlAgg, margin);
        this.fdAgg.right = new FormAttachment((Control)this.wGetAgg, -margin);
        this.fdAgg.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.wAgg.setLayoutData(this.fdAgg);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                GroupByDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                GroupByDialog.this.get();
            }
        };
        this.lsGetAgg = new Listener(){

            public void handleEvent(Event e) {
                GroupByDialog.this.getAgg();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                GroupByDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wGetAgg.addListener(13, this.lsGetAgg);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                GroupByDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                GroupByDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.backupChanged);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKey[0].setComboValues(fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    public void setFlags() {
        this.wlSortDir.setEnabled(this.wAllRows.getSelection());
        this.wbSortDir.setEnabled(this.wAllRows.getSelection());
        this.wSortDir.setEnabled(this.wAllRows.getSelection());
        this.wlPrefix.setEnabled(this.wAllRows.getSelection());
        this.wPrefix.setEnabled(this.wAllRows.getSelection());
        this.wlAddLineNr.setEnabled(this.wAllRows.getSelection());
        this.wAddLineNr.setEnabled(this.wAllRows.getSelection());
        this.wlLineNrField.setEnabled(this.wAllRows.getSelection() && this.wAddLineNr.getSelection());
        this.wLineNrField.setEnabled(this.wAllRows.getSelection() && this.wAddLineNr.getSelection());
    }

    public void getData() {
        TableItem item;
        int i;
        this.logDebug(BaseMessages.getString(PKG, (String)"GroupByDialog.Log.GettingKeyInfo", (String[])new String[0]));
        this.wAllRows.setSelection(this.input.passAllRows());
        if (this.input.getPrefix() != null) {
            this.wPrefix.setText(this.input.getPrefix());
        }
        if (this.input.getDirectory() != null) {
            this.wSortDir.setText(this.input.getDirectory());
        }
        this.wAddLineNr.setSelection(this.input.isAddingLineNrInGroup());
        if (this.input.getLineNrInGroupField() != null) {
            this.wLineNrField.setText(this.input.getLineNrInGroupField());
        }
        this.wAlwaysAddResult.setSelection(this.input.isAlwaysGivingBackOneRow());
        if (this.input.getGroupField() != null) {
            for (i = 0; i < this.input.getGroupField().length; ++i) {
                item = this.wGroup.table.getItem(i);
                if (this.input.getGroupField()[i] == null) continue;
                item.setText(1, this.input.getGroupField()[i]);
            }
        }
        if (this.input.getAggregateField() != null) {
            for (i = 0; i < this.input.getAggregateField().length; ++i) {
                item = this.wAgg.table.getItem(i);
                if (this.input.getAggregateField()[i] != null) {
                    item.setText(1, this.input.getAggregateField()[i]);
                }
                if (this.input.getSubjectField()[i] != null) {
                    item.setText(2, this.input.getSubjectField()[i]);
                }
                item.setText(3, GroupByMeta.getTypeDescLong((int)this.input.getAggregateType()[i]));
                if (this.input.getValueField()[i] == null) continue;
                item.setText(4, this.input.getValueField()[i]);
            }
        }
        this.wGroup.setRowNums();
        this.wGroup.optWidth(true);
        this.wAgg.setRowNums();
        this.wAgg.optWidth(true);
        this.setFlags();
        this.updateAllRowsCheckbox(this.wAgg, this.wAllRows, !this.input.passAllRows());
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(false);
        this.input.setPassAllRows(this.backupAllRows);
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        int sizegroup = this.wGroup.nrNonEmpty();
        int nrfields = this.wAgg.nrNonEmpty();
        this.input.setPrefix(this.wPrefix.getText());
        this.input.setDirectory(this.wSortDir.getText());
        this.input.setLineNrInGroupField(this.wLineNrField.getText());
        this.input.setAlwaysGivingBackOneRow(this.wAlwaysAddResult.getSelection());
        this.input.setPassAllRows(this.wAllRows.getSelection());
        this.input.allocate(sizegroup, nrfields);
        for (i = 0; i < sizegroup; ++i) {
            item = this.wGroup.getNonEmpty(i);
            this.input.getGroupField()[i] = item.getText(1);
        }
        for (i = 0; i < nrfields; ++i) {
            item = this.wAgg.getNonEmpty(i);
            this.input.getAggregateField()[i] = item.getText(1);
            this.input.getSubjectField()[i] = item.getText(2);
            this.input.getAggregateType()[i] = GroupByMeta.getType((String)item.getText(3));
            this.input.getValueField()[i] = item.getText(4);
        }
        this.stepname = this.wStepname.getText();
        if (sizegroup > 0 && "Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"GroupByDialog.GroupByWarningDialog.DialogTitle", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"GroupByDialog.GroupByWarningDialog.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 4, new String[]{BaseMessages.getString(PKG, (String)"GroupByDialog.GroupByWarningDialog.Option1", (String[])new String[0])}, 0, BaseMessages.getString(PKG, (String)"GroupByDialog.GroupByWarningDialog.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y")));
            MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            md.open();
            this.props.setCustomParameter(STRING_SORT_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
            this.props.saveProps();
        }
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wGroup, 1, new int[]{1}, new int[0], -1, -1, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GroupByDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getAgg() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wAgg, 1, new int[]{1, 2}, new int[0], -1, -1, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GroupByDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    void updateAllRowsCheckbox(TableView aggregationTable, Button allRowsButton, boolean forceUpdate) {
        boolean isCumulativeSelected = IntStream.range(0, aggregationTable.nrNonEmpty()).map(row -> GroupByMeta.getType((String)aggregationTable.getNonEmpty(row).getText(3))).anyMatch(pred -> pred == 13 || pred == 14);
        allRowsButton.setEnabled(!isCumulativeSelected);
        if (isCumulativeSelected) {
            allRowsButton.setSelection(true);
            if (forceUpdate) {
                this.backupChanged = true;
            }
        }
    }
}

