/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.tree.provider;

import java.util.List;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.tree.TreeNode;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.tree.TreeFolderProvider;

public class SlavesFolderProvider
extends TreeFolderProvider {
    private static Class<?> PKG = Spoon.class;
    public static final String STRING_SLAVES = BaseMessages.getString(PKG, (String)"Spoon.STRING_SLAVES", (String[])new String[0]);
    private GUIResource guiResource;

    public SlavesFolderProvider(GUIResource guiResource) {
        this.guiResource = guiResource;
    }

    public SlavesFolderProvider() {
        this(GUIResource.getInstance());
    }

    @Override
    public void refresh(AbstractMeta meta, TreeNode treeNode, String filter) {
        List servers = meta.getSlaveServers();
        servers.sort((s1, s2) -> String.CASE_INSENSITIVE_ORDER.compare(s1.getName(), s2.getName()));
        for (SlaveServer slaveServer : servers) {
            if (!this.filterMatch(slaveServer.getName(), filter)) continue;
            TreeNode childTreeNode = this.createTreeNode(treeNode, slaveServer.getName(), this.guiResource.getImageSlaveTree());
            if (!slaveServer.isShared()) continue;
            childTreeNode.setFont(this.guiResource.getFontBold());
        }
    }

    @Override
    public String getTitle() {
        return STRING_SLAVES;
    }

    @Override
    public Class getType() {
        return SlaveServer.class;
    }
}

