/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.tree;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.tree.TreeNode;
import org.pentaho.di.ui.spoon.tree.RootNode;
import org.pentaho.di.ui.spoon.tree.TreeFolderProvider;

public class TreeManager {
    private Tree tree;
    private List<RootNode> rootNodes = new ArrayList<RootNode>();
    private BiMap<TreeNode, TreeItem> treeNodeItemMap = HashBiMap.create();
    private String filter;
    private GUIResource guiResource;

    public TreeManager(Tree tree, GUIResource guiResource) {
        this.guiResource = guiResource;
        this.tree = tree;
        tree.addListener(17, e -> this.setExpanded((TreeItem)e.item, true));
        tree.addListener(18, e -> this.setExpanded((TreeItem)e.item, false));
    }

    public TreeManager(Tree tree) {
        this(tree, GUIResource.getInstance());
    }

    public void addRoot(String label, List<TreeFolderProvider> providers) {
        RootNode treeNode = new RootNode(label, this.guiResource.getImageFolder(), true);
        treeNode.setLabel(label);
        treeNode.setImage(GUIResource.getInstance().getImageFolder());
        treeNode.setExpanded(true);
        treeNode.addProviders(providers);
        this.rootNodes.add(treeNode);
        providers.forEach(p -> p.setTreeManager(this));
    }

    public void addTreeProvider(String root, TreeFolderProvider treeFolderProvider) {
        treeFolderProvider.setTreeManager(this);
        this.getRootTreeNodeByName(root).addProvider(treeFolderProvider);
    }

    public boolean hasNode(AbstractMeta abstractMeta) {
        return this.getTreeNode(abstractMeta) != null;
    }

    public void clear() {
        if (this.tree != null) {
            this.tree.removeAll();
        }
        this.treeNodeItemMap.clear();
        this.hideAll();
    }

    public void render() {
        this.rootNodes.forEach(t -> this.render((TreeNode)t, (Object)this.tree));
        this.setExpanded();
    }

    public void create(AbstractMeta abstractMeta, String name, boolean expanded) {
        RootNode rootNode = this.getRootTreeNodeByName(name);
        if (rootNode != null) {
            Image image = abstractMeta instanceof TransMeta ? this.guiResource.getImageTransTree() : this.guiResource.getImageJobTree();
            this.getRootTreeNodeByName(name).create(abstractMeta, image, expanded);
        }
    }

    public void checkUpdate(AbstractMeta abstractMeta, String name) {
        RootNode rootNode = this.getRootTreeNodeByName(name);
        if (rootNode != null) {
            rootNode.checkUpdate(abstractMeta, this.filter);
        }
    }

    public void showRoot(String name, boolean show) {
        this.getRootTreeNodeByName(name).setHidden(!show);
    }

    public void hideAll() {
        this.rootNodes.forEach(treeNode -> treeNode.getChildren().forEach(childTreeNode -> childTreeNode.setHidden(true)));
    }

    public void show(AbstractMeta abstractMeta) {
        TreeNode treeNode = this.getTreeNode(abstractMeta);
        if (treeNode != null) {
            treeNode.setHidden(false);
        }
    }

    public void hide(AbstractMeta abstractMeta) {
        TreeNode treeNode = this.getTreeNode(abstractMeta);
        if (treeNode != null) {
            treeNode.setHidden(true);
        }
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void reset(AbstractMeta abstractMeta) {
        this.rootNodes.forEach(rootNode -> rootNode.clearUpdates(abstractMeta));
    }

    public void update(String name) {
        this.rootNodes.forEach(rootNode -> rootNode.update(name));
    }

    public boolean shouldUpdate(AbstractMeta abstractMeta, String name) {
        for (RootNode rootNode : this.rootNodes) {
            if (!rootNode.hasNode(abstractMeta) || !rootNode.shouldUpdate(abstractMeta, name)) continue;
            return true;
        }
        return false;
    }

    private void setExpanded() {
        this.rootNodes.forEach(this::setExpanded);
    }

    private void setExpanded(TreeItem treeItem, boolean expanded) {
        TreeNode treeNode = (TreeNode)this.treeNodeItemMap.inverse().get((Object)treeItem);
        if (treeNode != null) {
            treeNode.setExpanded(expanded);
        }
    }

    private void setExpanded(TreeNode treeNode) {
        TreeItem treeItem = (TreeItem)this.treeNodeItemMap.get((Object)treeNode);
        if (treeItem != null) {
            treeItem.setExpanded(treeNode.isExpanded());
            for (TreeNode childTreeNode : treeNode.getChildren()) {
                this.setExpanded(childTreeNode);
            }
        }
    }

    private <T> void render(TreeNode treeNode, T tree) {
        if (treeNode.isHidden()) {
            return;
        }
        TreeItem childTreeItem = this.createTreeItem(treeNode, tree);
        if (treeNode.hasChildren()) {
            for (TreeNode childTreeNode : treeNode.getChildren()) {
                this.render(childTreeNode, childTreeItem);
            }
        }
    }

    private TreeItem createTreeItem(TreeNode treeNode, Object tree) {
        TreeItem childTreeItem = this.createTreeItem(tree, treeNode.getIndex());
        if (Const.isRunningOnWebspoonMode() && treeNode.hasChildren()) {
            try {
                Class<?> webSpoonUtils = Class.forName("org.pentaho.di.webspoon.WebSpoonUtils");
                Method setTestId = webSpoonUtils.getDeclaredMethod("setTestId", Widget.class, String.class);
                setTestId.invoke(null, childTreeItem, "view_" + treeNode.getLabel());
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.populateTreeItem(childTreeItem, treeNode);
        return childTreeItem;
    }

    private <T> TreeItem createTreeItem(T tree, int index) {
        if (tree instanceof Tree) {
            return index != -1 ? new TreeItem((Tree)tree, 0, index) : new TreeItem((Tree)tree, 0);
        }
        return index != -1 ? new TreeItem((TreeItem)tree, 0, index) : new TreeItem((TreeItem)tree, 0);
    }

    private void populateTreeItem(TreeItem childTreeItem, TreeNode treeNode) {
        childTreeItem.setText(treeNode.getLabel() != null ? treeNode.getLabel() : "");
        childTreeItem.setImage(treeNode.getImage());
        childTreeItem.setData(treeNode.getData());
        childTreeItem.setForeground(treeNode.getForeground());
        childTreeItem.setBackground(treeNode.getBackground());
        childTreeItem.setFont(treeNode.getFont());
        treeNode.getData().forEach((arg_0, arg_1) -> ((TreeItem)childTreeItem).setData(arg_0, arg_1));
        this.treeNodeItemMap.put((Object)treeNode, (Object)childTreeItem);
    }

    private RootNode getRootTreeNodeByName(String name) {
        return this.rootNodes.stream().filter(treeNode -> treeNode.getLabel().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public String getNameByType(Class clazz) {
        for (RootNode rootNode : this.rootNodes) {
            String name = rootNode.getNameByType(clazz);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    public void remove(AbstractMeta abstractMeta) {
        this.rootNodes.forEach(rootNode -> rootNode.remove(abstractMeta));
    }

    public TreeNode getTreeNode(AbstractMeta abstractMeta) {
        for (RootNode rootNode : this.rootNodes) {
            TreeNode treeNode = rootNode.getTreeNode(abstractMeta);
            if (treeNode == null) continue;
            return treeNode;
        }
        return null;
    }
}

