/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.tree;

import org.eclipse.swt.graphics.Image;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.tree.TreeNode;
import org.pentaho.di.ui.spoon.tree.TreeManager;

public abstract class TreeFolderProvider {
    protected TreeManager treeManager;

    public abstract void refresh(AbstractMeta var1, TreeNode var2, String var3);

    public Class getType() {
        return Object.class;
    }

    public void checkUpdate(AbstractMeta meta, TreeNode treeNode, String filter) {
        if (this.treeManager.shouldUpdate(meta, this.getTitle())) {
            treeNode.removeAll();
            this.refresh(meta, treeNode, filter);
        }
    }

    public abstract String getTitle();

    protected boolean filterMatch(String string, String filter) {
        return Utils.isEmpty((CharSequence)string) || Utils.isEmpty((CharSequence)filter) || string.toUpperCase().contains(filter.toUpperCase());
    }

    public void create(AbstractMeta meta, TreeNode parent) {
        this.refresh(meta, this.createTreeNode(parent, this.getTitle(), this.getTreeImage()), null);
    }

    protected Image getTreeImage() {
        return GUIResource.getInstance().getImageFolder();
    }

    public TreeNode createTreeNode(TreeNode parent, String text, Image image) {
        TreeNode childTreeNode = new TreeNode();
        childTreeNode.setLabel(text);
        childTreeNode.setImage(image);
        parent.addChild(childTreeNode);
        return childTreeNode;
    }

    public void setTreeManager(TreeManager treeManager) {
        this.treeManager = treeManager;
    }
}

