/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.TreeMemory;
import org.pentaho.di.ui.core.widget.TreeUtil;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.stores.delegate.DelegatingMetaStore;

public class MetaStoreExplorerDialog {
    private static Class<?> PKG = MetaStoreExplorerDialog.class;
    private static final String META_STORE_EXPLORER_DIALOG_TREE = "MetaStore explorer dialog tree";
    private static LogChannelInterface log = LogChannel.GENERAL;
    private IMetaStore metaStore;
    private List<IMetaStore> metaStoreList;
    private Shell parent;
    private Shell shell;
    private Tree tree;
    private PropsUI props;
    private Button closeButton;

    public MetaStoreExplorerDialog(Shell parent, IMetaStore metaStore) {
        this.metaStore = metaStore;
        this.parent = parent;
        this.metaStoreList = new ArrayList<IMetaStore>();
        if (metaStore instanceof DelegatingMetaStore) {
            DelegatingMetaStore delegatingMetaStore = (DelegatingMetaStore)metaStore;
            log.logBasic("Exploring delegating meta store containing " + delegatingMetaStore.getMetaStoreList().size());
            for (IMetaStore delMetaStore : delegatingMetaStore.getMetaStoreList()) {
                try {
                    log.logBasic(" --> delegated meta store " + delMetaStore.getName());
                }
                catch (Exception e) {
                    log.logError(" --> Error acessing delegated meta store", (Throwable)e);
                }
            }
            this.metaStoreList.addAll(((DelegatingMetaStore)metaStore).getMetaStoreList());
        } else {
            this.metaStoreList.add(metaStore);
        }
        this.props = PropsUI.getInstance();
    }

    public void open() {
        Display display = this.parent.getDisplay();
        this.shell = new Shell(this.parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MetaStoreExplorerDialog.Dialog.Title", (String[])new String[0]));
        int margin = 4;
        this.closeButton = new Button((Composite)this.shell, 8);
        this.closeButton.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.closeButton}, margin, null);
        this.closeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MetaStoreExplorerDialog.this.close();
            }
        });
        this.tree = new Tree((Composite)this.shell, 2820);
        this.props.setLook((Control)this.tree);
        this.tree.setHeaderVisible(true);
        FormData treeFormData = new FormData();
        treeFormData.left = new FormAttachment(0, 0);
        treeFormData.top = new FormAttachment(0, 0);
        treeFormData.right = new FormAttachment(100, 0);
        treeFormData.bottom = new FormAttachment((Control)this.closeButton, -margin * 2);
        this.tree.setLayoutData((Object)treeFormData);
        TreeColumn keyColumn = new TreeColumn(this.tree, 16384);
        keyColumn.setText("Metastore, Namespace, Element type, element name");
        keyColumn.setWidth(300);
        TreeColumn valueColumn = new TreeColumn(this.tree, 16384);
        valueColumn.setText("Description or value");
        valueColumn.setWidth(300);
        TreeColumn idColumn = new TreeColumn(this.tree, 16384);
        idColumn.setText("id");
        idColumn.setWidth(300);
        this.tree.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                if (MetaStoreExplorerDialog.this.tree.getSelectionCount() < 1) {
                    return;
                }
                TreeItem treeItem = MetaStoreExplorerDialog.this.tree.getSelection()[0];
                if (treeItem != null) {
                    String[] labels = ConstUI.getTreeStrings(treeItem);
                    int depth = ConstUI.getTreeLevel(treeItem);
                    if (depth == 3) {
                        final String metaStoreName = labels[0];
                        final String namespace = labels[1];
                        final String elementTypeName = labels[2];
                        final String elementName = labels[3];
                        Menu menu = new Menu((Control)MetaStoreExplorerDialog.this.tree);
                        MenuItem removeItem = new MenuItem(menu, 8);
                        removeItem.setText("Remove element");
                        removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent arg0) {
                                MetaStoreExplorerDialog.this.removeElement(metaStoreName, namespace, elementTypeName, elementName);
                            }
                        });
                        MetaStoreExplorerDialog.this.tree.setMenu(menu);
                        menu.setVisible(true);
                    }
                }
            }
        });
        TreeMemory.addTreeListener(this.tree, META_STORE_EXPLORER_DIALOG_TREE);
        try {
            this.refreshTree();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Unexpected error displaying metastore information", e);
        }
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MetaStoreExplorerDialog.this.close();
            }
        });
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void removeElement(String metaStoreName, String namespace, String elementTypeName, String elementName) {
        try {
            IMetaStore metaStore = this.findMetaStore(metaStoreName);
            if (metaStore == null) {
                throw new MetaStoreException("Unable to find metastore '" + metaStoreName + "'");
            }
            IMetaStoreElementType elementType = metaStore.getElementTypeByName(namespace, elementTypeName);
            if (elementType == null) {
                throw new MetaStoreException("Unable to find element type '" + elementTypeName + "' from metastore '" + metaStoreName + "' in namespace '" + namespace + "'");
            }
            IMetaStoreElement element = metaStore.getElementByName(namespace, elementType, elementName);
            if (element == null) {
                throw new MetaStoreException("Unable to find element '" + elementName + "' of type '" + elementTypeName + "' from metastore '" + metaStoreName + "' in namespace '" + namespace + "'");
            }
            metaStore.deleteElement(namespace, elementType, element.getId());
            this.refreshTree();
        }
        catch (MetaStoreException e) {
            new ErrorDialog(this.shell, "Error removing element", "There was an error removing the element '" + elementName + "' of type '" + elementTypeName + "' from metastore '" + metaStoreName + "' in namespace '" + namespace + "'", (Exception)((Object)e));
        }
    }

    private IMetaStore findMetaStore(String metaStoreName) throws MetaStoreException {
        for (IMetaStore metaStore : this.metaStoreList) {
            if (metaStore.getName() == null || !metaStore.getName().equals(metaStoreName)) continue;
            return metaStore;
        }
        return null;
    }

    private void close() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void refreshTree() throws MetaStoreException {
        this.tree.removeAll();
        for (int m = 0; m < this.metaStoreList.size(); ++m) {
            IMetaStore metaStore = this.metaStoreList.get(m);
            TreeItem metaStoreItem = new TreeItem(this.tree, 0);
            metaStoreItem.setText(0, Const.NVL((String)metaStore.getName(), (String)("metastore-" + (m + 1))));
            metaStoreItem.setText(1, Const.NVL((String)metaStore.getDescription(), (String)""));
            List namespaces = metaStore.getNamespaces();
            for (String namespace : namespaces) {
                TreeItem namespaceItem = new TreeItem(metaStoreItem, 0);
                namespaceItem.setText(0, Const.NVL((String)namespace, (String)""));
                List elementTypes = metaStore.getElementTypes(namespace);
                for (IMetaStoreElementType elementType : elementTypes) {
                    TreeItem elementTypeItem = new TreeItem(namespaceItem, 0);
                    elementTypeItem.setText(0, Const.NVL((String)elementType.getName(), (String)""));
                    elementTypeItem.setText(1, Const.NVL((String)elementType.getDescription(), (String)""));
                    List elements = metaStore.getElements(namespace, elementType);
                    for (final IMetaStoreElement element : elements) {
                        TreeItem elementItem = new TreeItem(elementTypeItem, 0);
                        elementItem.setText(0, Const.NVL((String)element.getName(), (String)""));
                        elementItem.setText(2, Const.NVL((String)element.getId(), (String)""));
                        elementItem.addListener(13, new Listener(){

                            public void handleEvent(Event event) {
                                log.logBasic("Selected : " + element.getName());
                            }
                        });
                        this.addAttributesToTree(elementItem, (IMetaStoreAttribute)element);
                    }
                }
            }
        }
        TreeUtil.setOptimalWidthOnColumns(this.tree);
        TreeMemory.setExpandedFromMemory(this.tree, META_STORE_EXPLORER_DIALOG_TREE);
    }

    private void addAttributesToTree(TreeItem parentItem, IMetaStoreAttribute parentAttribute) {
        for (IMetaStoreAttribute childAttribute : parentAttribute.getChildren()) {
            TreeItem treeItem = new TreeItem(parentItem, 0);
            treeItem.setText(0, Const.NVL((String)childAttribute.getId(), (String)""));
            treeItem.setText(1, childAttribute.getValue() == null ? "" : childAttribute.getValue().toString());
            this.addAttributesToTree(treeItem, childAttribute);
        }
    }

    public IMetaStore getMetaStore() {
        return this.metaStore;
    }

    public void setMetaStore(IMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    public List<IMetaStore> getMetaStoreList() {
        return this.metaStoreList;
    }

    public void setMetaStoreList(List<IMetaStore> metaStoreList) {
        this.metaStoreList = metaStoreList;
    }
}

