/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.ProgressMonitorAdapter;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.dialog.ErrorDialog;

public class GetJobSQLProgressDialog {
    private static Class<?> PKG = GetJobSQLProgressDialog.class;
    private Shell shell;
    private JobMeta jobMeta;
    private List<SQLStatement> stats;
    private Repository repository;

    public GetJobSQLProgressDialog(Shell shell, JobMeta jobMeta, Repository repository) {
        this.shell = shell;
        this.jobMeta = jobMeta;
        this.repository = repository;
    }

    public List<SQLStatement> open() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    GetJobSQLProgressDialog.this.stats = GetJobSQLProgressDialog.this.jobMeta.getSQLStatements(GetJobSQLProgressDialog.this.repository, (ProgressMonitorListener)new ProgressMonitorAdapter(monitor));
                }
                catch (KettleException e) {
                    throw new InvocationTargetException(e, BaseMessages.getString((Class)PKG, (String)"GetJobSQLProgressDialog.RuntimeError.UnableToGenerateSQL.Exception", (String[])new String[]{e.getMessage()}));
                }
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(false, false, op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetJobSQLProgressDialog.Dialog.UnableToGenerateSQL.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetJobSQLProgressDialog.Dialog.UnableToGenerateSQL.Message", (String[])new String[0]), e);
            this.stats = null;
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetJobSQLProgressDialog.Dialog.UnableToGenerateSQL.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetJobSQLProgressDialog.Dialog.UnableToGenerateSQL.Message", (String[])new String[0]), e);
            this.stats = null;
        }
        return this.stats;
    }
}

