/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.controllers;

import com.google.common.annotations.VisibleForTesting;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryExtended;
import org.pentaho.di.ui.repository.repositoryexplorer.ContextChangeVetoer;
import org.pentaho.di.ui.repository.repositoryexplorer.ContextChangeVetoerCollection;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorer;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.FileOverwriteDialogController;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.IBrowseController;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.MainController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectCreationException;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectRegistry;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryContent;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryDirectory;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObject;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObjects;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulPromptBox;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.dnd.DropEvent;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.swt.SwtBindingFactory;
import org.pentaho.ui.xul.swt.custom.DialogConstant;
import org.pentaho.ui.xul.swt.tags.SwtDialog;
import org.pentaho.ui.xul.util.XulDialogCallback;

public class BrowseController
extends AbstractXulEventHandler
implements IUISupportController,
IBrowseController {
    private static Class<?> PKG = RepositoryExplorer.class;
    protected UIRepositoryDirectory repoDir;
    protected XulTree folderTree;
    protected XulTree fileTable;
    protected UIRepositoryDirectory repositoryDirectory;
    protected ContextChangeVetoerCollection contextChangeVetoers;
    protected BindingFactory bf;
    protected Binding directoryBinding;
    protected Binding selectedItemsBinding;
    protected List<UIRepositoryDirectory> selectedFolderItems;
    protected List<UIRepositoryObject> selectedFileItems;
    protected List<UIRepositoryDirectory> repositoryDirectories;
    protected Repository repository;
    List<UIRepositoryObject> repositoryObjects;
    List<UIRepositoryObject> repositoryItems;
    protected MainController mainController;
    protected XulMessageBox messageBox;
    protected XulConfirmBox confirmBox;
    private Shell shell;
    private static final int DIALOG_WIDTH = 365;
    private static final int DIALOG_HEIGHT = 195;
    private static final int DIALOG_COLOR = 1;
    protected static final String HOME_PATH = "/home";
    protected static final String PUBLIC_PATH = "/public";
    protected Map<ObjectId, UIRepositoryDirectory> dirMap;
    private PropertyChangeListener fileChildrenListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            try {
                BrowseController.this.firePropertyChange("selectedRepoDirChildren", null, (Object)BrowseController.this.getSelectedRepoDirChildren());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    private String newName = null;

    private void fireRepositoryDirectoryChange() {
        this.firePropertyChange("repositoryDirectory", null, (Object)this.repositoryDirectory);
    }

    private void fireFoldersAndItemsChange(List<UIRepositoryDirectory> previousValue, UIRepositoryObjects previousRepoObjects) {
        this.firePropertyChange("repositoryDirectories", previousValue, this.getRepositoryDirectories());
        this.firePropertyChange("selectedRepoDirChildren", (Object)previousRepoObjects, (Object)this.getSelectedRepoDirChildren());
    }

    @Override
    public void init(Repository repository) throws ControllerInitializationException {
        try {
            this.repository = repository;
            this.mainController = (MainController)this.getXulDomContainer().getEventHandler("mainController");
            try {
                RepositoryDirectoryInterface root = repository instanceof RepositoryExtended ? ((RepositoryExtended)repository).loadRepositoryDirectoryTree(false) : repository.loadRepositoryDirectoryTree();
                this.repositoryDirectory = UIObjectRegistry.getInstance().constructUIRepositoryDirectory(root, null, repository);
            }
            catch (UIObjectCreationException uoe) {
                this.repositoryDirectory = new UIRepositoryDirectory(repository.loadRepositoryDirectoryTree(), null, repository);
            }
            this.repositoryDirectory.populateChildren();
            this.dirMap = new HashMap<ObjectId, UIRepositoryDirectory>();
            this.populateDirMap(this.repositoryDirectory);
            this.bf = new SwtBindingFactory();
            this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
            this.messageBox = (XulMessageBox)this.document.createElement("messagebox");
            this.createBindings();
        }
        catch (Exception e) {
            throw new ControllerInitializationException(e);
        }
    }

    protected void createBindings() {
        this.shell = ((SwtDialog)this.document.getElementById("repository-explorer-dialog")).getShell();
        this.folderTree = (XulTree)this.document.getElementById("folder-tree");
        this.fileTable = (XulTree)this.document.getElementById("file-table");
        if (!this.repositoryDirectory.isVisible()) {
            this.folderTree.setHiddenrootnode(true);
        } else {
            this.folderTree.setHiddenrootnode(false);
        }
        BindingConvertor checkIfMultipleItemsAreSelected = new BindingConvertor<List<?>, Boolean>(){

            public Boolean sourceToTarget(List<?> value) {
                return value != null && value.size() == 1 && value.get(0) != null;
            }

            public List<?> targetToSource(Boolean value) {
                return null;
            }
        };
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.fileTable, "selectedItems", "file-context-rename", "!disabled", new BindingConvertor[]{checkIfMultipleItemsAreSelected});
        this.bf.createBinding((Object)this.fileTable, "selectedItems", (Object)this, "selectedFileItems", new BindingConvertor[0]);
        PropertyChangeListener childrenListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BrowseController.this.fireRepositoryDirectoryChange();
            }
        };
        this.repositoryDirectory.addPropertyChangeListener("children", childrenListener);
        this.directoryBinding = this.createDirectoryBinding();
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.folderTree, "selectedItems", (Object)this, "selectedFolderItems", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.selectedItemsBinding = this.bf.createBinding((Object)this, "selectedRepoDirChildren", (Object)this.fileTable, "elements", new BindingConvertor[0]);
        this.doCreateBindings();
        try {
            this.directoryBinding.fireSourceChanged();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            String[] homePath;
            RepositoryDirectoryInterface homeDir = this.repository.getUserHomeDirectory();
            int currentDir = 0;
            String[] stringArray = homePath = homeDir == null ? null : homeDir.getPathArray();
            if (homePath != null) {
                UIRepositoryDirectory tempRoot = this.repositoryDirectory;
                if (homePath.length > 0 && tempRoot.getName().equalsIgnoreCase(homePath[currentDir])) {
                    if (homePath.length == 1) {
                        this.setSelectedFolderItems(Arrays.asList(tempRoot));
                    }
                    ++currentDir;
                }
                while (currentDir < homePath.length) {
                    Iterator<UIRepositoryObject> iterator = tempRoot.iterator();
                    while (iterator.hasNext()) {
                        UIRepositoryObject uiObj = iterator.next();
                        if (!(uiObj instanceof UIRepositoryDirectory) || !uiObj.getName().equalsIgnoreCase(homePath[currentDir])) continue;
                        ((UIRepositoryDirectory)uiObj).populateChildren();
                        this.directoryBinding.fireSourceChanged();
                        tempRoot = (UIRepositoryDirectory)uiObj;
                        break;
                    }
                    ++currentDir;
                }
                if (homePath.length == currentDir) {
                    this.setSelectedFolderItems(Arrays.asList(tempRoot));
                    this.folderTree.setSelectedItems(this.selectedFolderItems);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doCreateBindings() {
    }

    protected Binding createDirectoryBinding() {
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        return this.bf.createBinding((Object)this, "repositoryDirectory", (Object)this.folderTree, "elements", new BindingConvertor[0]);
    }

    @Override
    public String getName() {
        return "browseController";
    }

    public UIRepositoryDirectory getRepositoryDirectory() {
        return this.repositoryDirectory;
    }

    protected void populateDirMap(UIRepositoryDirectory repDir) {
        if (repDir.getObjectId() != null) {
            this.dirMap.put(repDir.getObjectId(), repDir);
            Iterator<UIRepositoryObject> iterator = repDir.iterator();
            while (iterator.hasNext()) {
                UIRepositoryObject obj = iterator.next();
                if (!(obj instanceof UIRepositoryDirectory)) continue;
                this.populateDirMap((UIRepositoryDirectory)obj);
            }
        }
    }

    public void expandAllFolders() {
        this.folderTree.expandAll();
    }

    public void collapseAllFolders() {
        this.folderTree.collapseAll();
    }

    public void openContent() {
        Collection content = this.fileTable.getSelectedItems();
        this.openContent(content.toArray());
    }

    public void openContent(Object[] items) {
        if (items != null && items.length > 0) {
            for (Object o : items) {
                if (o instanceof UIRepositoryDirectory) {
                    ((UIRepositoryDirectory)((Object)o)).toggleExpanded();
                    ArrayList<Object> selectedFolder = new ArrayList<Object>();
                    selectedFolder.add(o);
                    this.folderTree.setSelectedItems(selectedFolder);
                    continue;
                }
                if (this.mainController == null || this.mainController.getCallback() == null || !(o instanceof UIRepositoryContent)) continue;
                try {
                    this.mainController.getCallback().open((UIRepositoryContent)((Object)o), null);
                }
                catch (Exception e) {
                    this.mainController.handleLostRepository(e);
                }
            }
        }
    }

    public void renameContent() throws Exception {
        block3: {
            try {
                Collection content = this.fileTable.getSelectedItems();
                UIRepositoryObject contentToRename = (UIRepositoryObject)((Object)content.iterator().next());
                this.renameRepositoryObject(contentToRename);
                if (contentToRename instanceof UIRepositoryDirectory) {
                    this.directoryBinding.fireSourceChanged();
                }
                this.selectedItemsBinding.fireSourceChanged();
            }
            catch (Throwable th) {
                if (this.mainController != null && this.mainController.handleLostRepository(th)) break block3;
                this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                this.messageBox.setMessage(BaseMessages.getString(PKG, (String)th.getLocalizedMessage(), (String[])new String[0]));
                this.messageBox.open();
            }
        }
    }

    protected void confirm(String title, String message, Callable<Void> onAccept) throws XulException {
        String yes = BaseMessages.getString(PKG, (String)"Dialog.YesDelete", (String[])new String[0]);
        String no = BaseMessages.getString(PKG, (String)"Dialog.No", (String[])new String[0]);
        try {
            this.confirmDialog(onAccept, BaseMessages.getString(PKG, (String)title, (String[])new String[0]), BaseMessages.getString(PKG, (String)message, (String[])new String[0]), yes, no);
        }
        catch (Exception e) {
            throw new XulException((Throwable)e);
        }
    }

    protected void confirm(String title, String message) throws XulException {
        String ok = BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]);
        try {
            this.confirmDialog(title, message, ok);
        }
        catch (Exception e) {
            throw new XulException((Throwable)e);
        }
    }

    protected void confirmDialog(String title, String msg, String ok) throws Exception {
        MessageDialog confirmDialog = new MessageDialog(this.getShell(), title, null, msg, 0, new String[]{ok}, 0){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setBackground(shell.getDisplay().getSystemColor(1));
                shell.setBackgroundMode(2);
            }
        };
        confirmDialog.open();
    }

    protected void confirmDialog(Callable<Void> callback, String title, String msg, String yes, String no) throws Exception {
        block3: {
            MessageDialog confirmDialog = new MessageDialog(this.getShell(), title, null, msg, 0, new String[]{yes, no}, 0){

                protected Point getInitialSize() {
                    return new Point(365, 195);
                }

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setBackground(shell.getDisplay().getSystemColor(1));
                    shell.setBackgroundMode(2);
                }
            };
            int result = confirmDialog.open();
            if (result == 0) {
                try {
                    callback.call();
                }
                catch (Exception e) {
                    if (this.mainController != null && this.mainController.handleLostRepository(e)) break block3;
                    this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                    this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                    this.messageBox.setMessage(BaseMessages.getString(PKG, (String)e.getLocalizedMessage(), (String[])new String[0]));
                    this.messageBox.open();
                }
            }
        }
    }

    public void deleteContent() throws Exception {
        for (Object object : this.fileTable.getSelectedItems()) {
            if (!(object instanceof UIRepositoryObject)) continue;
            final UIRepositoryObject repoObject = (UIRepositoryObject)((Object)object);
            Callable<Void> deleteCallable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (repoObject instanceof UIRepositoryDirectory) {
                        ((UIRepositoryDirectory)repoObject).cleanup();
                    }
                    BrowseController.this.deleteContent(repoObject);
                    return null;
                }
            };
            if (repoObject instanceof UIRepositoryDirectory) {
                this.confirm("BrowseController.DeleteNonEmptyFolderWarningTitle", "BrowseController.DeleteFolderWarningMessage", deleteCallable);
                continue;
            }
            this.confirm("BrowseController.DeleteFileWarningTitle", "BrowseController.DeleteFileWarningMessage", deleteCallable);
        }
    }

    protected void deleteContent(UIRepositoryObject repoObject) throws Exception {
        repoObject.delete();
        if (repoObject instanceof UIRepositoryDirectory) {
            this.directoryBinding.fireSourceChanged();
            if (this.repoDir != null) {
                this.repoDir.refresh();
            }
        }
        this.selectedItemsBinding.fireSourceChanged();
    }

    public void createFolder() throws Exception {
        block8: {
            try {
                Collection directories = this.folderTree.getSelectedItems();
                if (directories == null || directories.size() == 0) {
                    return;
                }
                UIRepositoryDirectory selectedFolder = (UIRepositoryDirectory)((Object)directories.iterator().next());
                XulPromptBox prompt = this.promptForName(null);
                prompt.addDialogCallback((XulDialogCallback)new XulDialogCallback<String>(){

                    public void onClose(XulComponent component, XulDialogCallback.Status status, String value) {
                        if (status == XulDialogCallback.Status.ACCEPT) {
                            BrowseController.this.newName = value;
                        } else {
                            BrowseController.this.newName = null;
                        }
                    }

                    public void onError(XulComponent component, Throwable err) {
                        throw new RuntimeException(err);
                    }
                });
                prompt.open();
                if (this.newName != null) {
                    if (selectedFolder == null) {
                        selectedFolder = this.repositoryDirectory;
                    }
                    if (this.newName.equals(".") || this.newName.equals("..")) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"BrowserController.InvalidFolderName", (String[])new String[0]));
                    }
                    boolean folderExistsInUI = selectedFolder.contains(this.newName);
                    if (folderExistsInUI) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"BrowserController.DirAlreadyExistsInUI", (String[])new String[]{this.newName}));
                    }
                    String newNameInRepo = selectedFolder.checkDirNameExistsInRepo(this.newName);
                    if (newNameInRepo != null) {
                        this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Warning", (String[])new String[0]));
                        this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                        this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"BrowserController.DirAlreadyExistsInRepository", (String[])new String[]{newNameInRepo}));
                        this.messageBox.open();
                        this.newName = newNameInRepo;
                    }
                    UIRepositoryDirectory newDir = selectedFolder.createFolder(this.newName);
                    this.dirMap.put(newDir.getObjectId(), newDir);
                    this.directoryBinding.fireSourceChanged();
                    this.selectedItemsBinding.fireSourceChanged();
                    this.folderTree.setSelectedItems(Collections.singletonList(selectedFolder));
                }
                this.newName = null;
            }
            catch (Exception e) {
                if (this.mainController != null && this.mainController.handleLostRepository(e)) break block8;
                this.confirm(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getLocalizedMessage());
            }
        }
    }

    public void exportFolder() throws Exception {
        for (Object object : this.folderTree.getSelectedItems()) {
            if (!(object instanceof UIRepositoryDirectory)) continue;
            this.repoDir = (UIRepositoryDirectory)((Object)object);
            if (!Spoon.getInstance().exportRepositoryDirectory(this.repoDir.getDirectory())) continue;
            return;
        }
    }

    public void deleteFolder() throws Exception {
        UIRepositoryDirectory newSelectedItem = null;
        for (Object object : this.folderTree.getSelectedItems()) {
            if (object instanceof UIRepositoryDirectory) {
                this.repoDir = (UIRepositoryDirectory)((Object)object);
                newSelectedItem = this.repoDir.getParent();
                this.confirm("BrowseController.DeleteNonEmptyFolderWarningTitle", "BrowseController.DeleteFolderWarningMessage", () -> {
                    this.deleteFolder(this.repoDir);
                    return null;
                });
                break;
            }
            this.deleteFolder(this.repoDir);
        }
        if (newSelectedItem != null) {
            this.folderTree.setSelectedItems(Arrays.asList(newSelectedItem));
        }
    }

    protected void deleteFolder(UIRepositoryDirectory repoDir) throws Exception {
        repoDir.delete();
        this.directoryBinding.fireSourceChanged();
        this.selectedItemsBinding.fireSourceChanged();
        repoDir.refresh();
    }

    public void renameFolder() throws Exception {
        block2: {
            try {
                Collection directory = this.folderTree.getSelectedItems();
                UIRepositoryDirectory toRename = (UIRepositoryDirectory)((Object)directory.iterator().next());
                this.renameRepositoryObject(toRename);
                this.directoryBinding.fireSourceChanged();
                this.selectedItemsBinding.fireSourceChanged();
            }
            catch (Throwable th) {
                if (this.mainController != null && this.mainController.handleLostRepository(th)) break block2;
                this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                this.messageBox.setMessage(BaseMessages.getString(PKG, (String)th.getLocalizedMessage(), (String[])new String[0]));
                this.messageBox.open();
            }
        }
    }

    protected void renameRepositoryObject(final UIRepositoryObject object) throws XulException {
        XulPromptBox prompt = this.promptForName(object);
        prompt.addDialogCallback((XulDialogCallback)new XulDialogCallback<String>(){

            public void onClose(XulComponent component, XulDialogCallback.Status status, String value) {
                block3: {
                    if (status == XulDialogCallback.Status.ACCEPT) {
                        try {
                            object.setName(value);
                        }
                        catch (Exception e) {
                            if (BrowseController.this.mainController != null && BrowseController.this.mainController.handleLostRepository(e)) break block3;
                            throw new RuntimeException(e);
                        }
                    }
                }
            }

            public void onError(XulComponent component, Throwable err) {
                throw new RuntimeException(err);
            }
        });
        prompt.open();
    }

    protected XulPromptBox promptForName(UIRepositoryObject object) throws XulException {
        XulPromptBox prompt = (XulPromptBox)this.document.createElement("promptbox");
        String currentName = object == null ? BaseMessages.getString(PKG, (String)"BrowserController.NewFolder", (String[])new String[0]) : object.getName();
        prompt.setTitle(BaseMessages.getString(PKG, (String)"BrowserController.Name", (String[])new String[0]).concat(currentName));
        prompt.setButtons((Object[])new DialogConstant[]{DialogConstant.OK, DialogConstant.CANCEL});
        prompt.setMessage(BaseMessages.getString(PKG, (String)"BrowserController.NameLabel", (String[])new String[0]).concat(currentName));
        prompt.setValue(currentName);
        return prompt;
    }

    public void onDragFromGlobalTree(DropEvent event) {
        for (UIRepositoryDirectory uiRepositoryDirectory : this.getSelectedFolderItems()) {
            String path = uiRepositoryDirectory.getDirectory().getPath();
            if (!path.equals(HOME_PATH) && !path.equals(PUBLIC_PATH)) continue;
            event.setAccepted(false);
            return;
        }
        event.setAccepted(true);
    }

    public void onDragFromLocalTable(DropEvent event) {
        event.setAccepted(true);
    }

    public void onDrop(DropEvent event) {
        boolean result;
        block17: {
            result = false;
            try {
                ArrayList dirList = new ArrayList();
                ArrayList<UIRepositoryObject> moveList = new ArrayList<UIRepositoryObject>();
                UIRepositoryDirectory targetDirectory = null;
                if (event.getDropParent() != null && event.getDropParent() instanceof UIRepositoryDirectory) {
                    targetDirectory = (UIRepositoryDirectory)((Object)event.getDropParent());
                    if (event.getDataTransfer().getData().size() > 0) {
                        for (Iterator o : event.getDataTransfer().getData()) {
                            if (!(o instanceof UIRepositoryObject)) continue;
                            moveList.add((UIRepositoryObject)((Object)o));
                            if (o instanceof UIRepositoryDirectory) {
                                dirList.add(o);
                            }
                            result = true;
                        }
                    }
                }
                if (result) {
                    ArrayList<UIRepositoryObject> collisionObjects = new ArrayList<UIRepositoryObject>();
                    for (UIRepositoryObject newChild : moveList) {
                        Iterator iterator = targetDirectory.getRepositoryObjects().iterator();
                        while (iterator.hasNext()) {
                            UIRepositoryObject currChild = (UIRepositoryObject)((Object)iterator.next());
                            if (currChild instanceof UIRepositoryDirectory && newChild instanceof UIRepositoryDirectory && currChild.getName().equalsIgnoreCase(newChild.getName())) {
                                this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                                this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                                this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"BrowseController.UnableToMove.DirectoryAlreadyExists", (String[])new String[]{currChild.getPath()}));
                                this.messageBox.open();
                                result = false;
                                break;
                            }
                            if (currChild instanceof UIRepositoryDirectory || !currChild.getType().equalsIgnoreCase(newChild.getType()) || !currChild.getName().equalsIgnoreCase(newChild.getName())) continue;
                            collisionObjects.add(currChild);
                        }
                        if (result) continue;
                        break;
                    }
                    if (result && collisionObjects.size() > 0) {
                        FileOverwriteDialogController fileOverwriteDialog = FileOverwriteDialogController.getInstance(this.getXulDomContainer().getOuterContext() instanceof Shell ? (Shell)this.getXulDomContainer().getOuterContext() : null, collisionObjects);
                        fileOverwriteDialog.show();
                        if (fileOverwriteDialog.isOverwriteFiles()) {
                            for (UIRepositoryObject o : collisionObjects) {
                                o.delete();
                            }
                        } else {
                            result = false;
                        }
                    }
                    if (result) {
                        this.moveFiles(moveList, targetDirectory);
                        event.getDataTransfer().setData(dirList);
                    }
                }
            }
            catch (Exception e) {
                if (this.mainController != null && this.mainController.handleLostRepository(e)) break block17;
                result = false;
                event.setAccepted(false);
                this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"BrowseController.UnableToMove", (String[])new String[]{e.getLocalizedMessage()}));
                this.messageBox.open();
            }
        }
        event.setAccepted(result);
        try {
            this.directoryBinding.fireSourceChanged();
            this.selectedItemsBinding.fireSourceChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void moveFiles(List<UIRepositoryObject> objects, UIRepositoryDirectory targetDirectory) throws Exception {
        for (UIRepositoryObject o : objects) {
            o.move(targetDirectory);
        }
    }

    public void onDoubleClick(Object[] selectedItems) {
        this.openContent(selectedItems);
    }

    public void onToggle(Object[] toggled, boolean expanded) {
        UIRepositoryDirectory rd;
        if (expanded && !(rd = (UIRepositoryDirectory)((Object)toggled[0])).isPopulated()) {
            rd.populateChildren();
            try {
                this.directoryBinding.fireSourceChanged();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public List<UIRepositoryDirectory> getSelectedFolderItems() {
        return this.selectedFolderItems;
    }

    public void setSelectedFolderItems(List<UIRepositoryDirectory> selectedFolderItems) {
        for (UIRepositoryDirectory rd : selectedFolderItems) {
            if (rd.isPopulated()) continue;
            rd.populateChildren();
            try {
                this.directoryBinding.fireSourceChanged();
            }
            catch (Exception exception) {}
        }
        if (!this.compareFolderList(selectedFolderItems, this.selectedFolderItems)) {
            List<ContextChangeVetoer.TYPE> pollResults = this.pollContextChangeVetoResults();
            if (!this.contains(ContextChangeVetoer.TYPE.CANCEL, pollResults)) {
                this.selectedFolderItems = selectedFolderItems;
                this.setRepositoryDirectories(selectedFolderItems);
            } else if (this.contains(ContextChangeVetoer.TYPE.CANCEL, pollResults)) {
                this.folderTree.setSelectedItems(this.selectedFolderItems);
                this.fileTable.setSelectedItems(this.selectedFileItems);
            }
        } else {
            this.setRepositoryDirectories(selectedFolderItems);
        }
    }

    public List<UIRepositoryObject> getSelectedFileItems() {
        return this.selectedFileItems;
    }

    public void setSelectedFileItems(List<UIRepositoryObject> selectedFileItems) {
        if (!this.compareFileList(selectedFileItems, this.selectedFileItems)) {
            List<ContextChangeVetoer.TYPE> pollResults = this.pollContextChangeVetoResults();
            if (!this.contains(ContextChangeVetoer.TYPE.CANCEL, pollResults)) {
                this.selectedFileItems = selectedFileItems;
                this.setRepositoryObjects(selectedFileItems);
                this.setRepositoryItems(selectedFileItems);
            } else if (this.contains(ContextChangeVetoer.TYPE.CANCEL, pollResults)) {
                this.fileTable.setSelectedItems(this.selectedFileItems);
            }
        } else {
            this.setRepositoryItems(selectedFileItems);
        }
        if (selectedFileItems.isEmpty()) {
            this.folderTree.setSelectedItems(this.selectedFolderItems);
        }
    }

    public Binding getSelectedItemsBinding() {
        return this.selectedItemsBinding;
    }

    public void setSelectedItemsBinding(Binding selectedItemsBinding) {
        this.selectedItemsBinding = selectedItemsBinding;
    }

    public void setRepositoryObjects(List<UIRepositoryObject> selectedFileItems) {
        this.repositoryObjects = selectedFileItems;
        this.firePropertyChange("repositoryObjects", null, selectedFileItems);
    }

    public List<UIRepositoryObject> getRepositoryObjects() {
        return this.repositoryObjects;
    }

    public void setRepositoryItems(List<UIRepositoryObject> selectedItems) {
        this.repositoryItems = selectedItems;
        this.firePropertyChange("repositoryItems", null, this.repositoryItems);
    }

    public List<UIRepositoryObject> getRepositoryItems() {
        return this.repositoryItems;
    }

    public List<UIRepositoryDirectory> getRepositoryDirectories() {
        if (this.repositoryDirectories != null && this.repositoryDirectories.size() == 0) {
            return null;
        }
        return this.repositoryDirectories;
    }

    public void setRepositoryDirectories(List<UIRepositoryDirectory> selectedFolderItems) {
        UIRepositoryObjects previousRepoObjects;
        ArrayList<UIRepositoryDirectory> previousVal;
        block5: {
            previousVal = null;
            previousRepoObjects = null;
            try {
                if (this.repositoryDirectories != null && this.repositoryDirectories.size() > 0) {
                    previousVal = new ArrayList<UIRepositoryDirectory>();
                    previousVal.addAll(this.repositoryDirectories);
                    previousRepoObjects = this.getSelectedRepoDirChildren();
                }
                if (this.repositoryDirectories != null && this.repositoryDirectories.size() > 0) {
                    this.repositoryDirectories.get(0).getRepositoryObjects().removePropertyChangeListener(this.fileChildrenListener);
                }
                this.repositoryDirectories = selectedFolderItems;
                if (this.repositoryDirectories != null && this.repositoryDirectories.size() > 0) {
                    this.repositoryDirectories.get(0).getRepositoryObjects().addPropertyChangeListener("children", this.fileChildrenListener);
                }
            }
            catch (KettleException e) {
                if (this.mainController != null && this.mainController.handleLostRepository(e)) break block5;
                throw new RuntimeException(e);
            }
        }
        this.fireFoldersAndItemsChange(previousVal, previousRepoObjects);
    }

    public UIRepositoryObjects getSelectedRepoDirChildren() {
        UIRepositoryObjects repoObjects;
        block3: {
            repoObjects = null;
            if (this.selectedFolderItems != null && this.selectedFolderItems.size() > 0) {
                try {
                    repoObjects = this.repositoryDirectories.get(0).getRepositoryObjects();
                }
                catch (KettleException e) {
                    if (this.mainController != null && this.mainController.handleLostRepository(e)) break block3;
                    throw new RuntimeException(e);
                }
            }
        }
        return repoObjects;
    }

    @Override
    public void addContextChangeVetoer(ContextChangeVetoer listener) {
        if (this.contextChangeVetoers == null) {
            this.contextChangeVetoers = new ContextChangeVetoerCollection();
        }
        this.contextChangeVetoers.add(listener);
    }

    @Override
    public void removeContextChangeVetoer(ContextChangeVetoer listener) {
        if (this.contextChangeVetoers != null) {
            this.contextChangeVetoers.remove(listener);
        }
    }

    protected Shell getShell() {
        return this.shell;
    }

    private boolean contains(ContextChangeVetoer.TYPE type, List<ContextChangeVetoer.TYPE> typeList) {
        for (ContextChangeVetoer.TYPE t : typeList) {
            if (!t.equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    List<ContextChangeVetoer.TYPE> pollContextChangeVetoResults() {
        if (this.contextChangeVetoers != null) {
            return this.contextChangeVetoers.fireContextChange();
        }
        ArrayList<ContextChangeVetoer.TYPE> returnValue = new ArrayList<ContextChangeVetoer.TYPE>();
        returnValue.add(ContextChangeVetoer.TYPE.NO_OP);
        return returnValue;
    }

    boolean compareFolderList(List<UIRepositoryDirectory> rd1, List<UIRepositoryDirectory> rd2) {
        if (rd1 != null && rd2 != null) {
            if (rd1.size() != rd2.size()) {
                return false;
            }
            for (int i = 0; i < rd1.size(); ++i) {
                if (rd1.get(i) == null || rd2.get(i) == null || rd1.get(i).getName().equals(rd2.get(i).getName())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    boolean compareFileList(List<UIRepositoryObject> ro1, List<UIRepositoryObject> ro2) {
        if (ro1 != null && ro2 != null) {
            if (ro1.size() != ro2.size()) {
                return false;
            }
            for (int i = 0; i < ro1.size(); ++i) {
                if (ro1.get(i) == null || ro2.get(i) == null || ro1.get(i).getName().equals(ro2.get(i).getName())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @VisibleForTesting
    void setDirMap(Map<ObjectId, UIRepositoryDirectory> dirMap) {
        this.dirMap = dirMap;
    }

    @VisibleForTesting
    void setFolderTree(XulTree folderTree) {
        this.folderTree = folderTree;
    }

    @VisibleForTesting
    void setRepositoryDirectory(UIRepositoryDirectory repositoryDirectory) {
        this.repositoryDirectory = repositoryDirectory;
    }

    @VisibleForTesting
    void setDirectoryBinding(Binding directoryBinding) {
        this.directoryBinding = directoryBinding;
    }
}

