/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entry;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Supplier;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.database.wizard.CreateDatabaseWizard;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.tree.provider.DBConnectionFolderProvider;
import org.pentaho.di.ui.util.DialogUtils;
import org.pentaho.metastore.api.IMetaStore;

public class JobEntryDialog
extends Dialog {
    private static final Class<?> PKG = StepInterface.class;
    public static final LoggingObjectInterface loggingObject = new SimpleLoggingObject("Job entry dialog", LoggingObjectType.JOBENTRYDIALOG, null);
    protected JobEntryInterface jobEntryInt;
    protected Repository rep;
    protected IMetaStore metaStore;
    protected JobMeta jobMeta;
    protected Shell shell;
    protected PropsUI props;
    protected Shell parent;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    protected DatabaseDialog databaseDialog;

    public JobEntryDialog(Shell parent, JobEntryInterface jobEntry, Repository rep, JobMeta jobMeta) {
        super(parent, 0);
        this.props = PropsUI.getInstance();
        this.jobEntryInt = jobEntry;
        this.rep = rep;
        this.jobMeta = jobMeta;
        this.shell = parent;
    }

    private DatabaseDialog getDatabaseDialog() {
        if (this.databaseDialog != null) {
            return this.databaseDialog;
        }
        this.databaseDialog = new DatabaseDialog(this.shell);
        return this.databaseDialog;
    }

    public CCombo addConnectionLine(Composite parent, Control previous, int middle, int margin) {
        return this.addConnectionLine(parent, previous, middle, margin, new Label(parent, 131072), new Button(parent, 8), new Button(parent, 8), new Button(parent, 8));
    }

    public CCombo addConnectionLine(Composite parent, Control previous, int middle, int margin, Label wlConnection, Button wbwConnection, Button wbnConnection, Button wbeConnection) {
        final CCombo wConnection = new CCombo(parent, 2056);
        this.props.setLook((Control)wConnection);
        this.addDatabases(wConnection);
        wlConnection.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.Connection.Label", (String[])new String[0]));
        this.props.setLook((Control)wlConnection);
        FormData fdlConnection = new FormData();
        fdlConnection.left = new FormAttachment(0, 0);
        fdlConnection.right = new FormAttachment(middle, -margin);
        fdlConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        wlConnection.setLayoutData((Object)fdlConnection);
        wbwConnection.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.WizardConnectionButton.Label", (String[])new String[0]));
        wbwConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateDatabaseWizard cdw = new CreateDatabaseWizard();
                DatabaseMeta newDBInfo = cdw.createAndRunDatabaseWizard(JobEntryDialog.this.shell, JobEntryDialog.this.props, JobEntryDialog.this.jobMeta.getDatabases());
                if (newDBInfo != null) {
                    JobEntryDialog.this.jobMeta.addDatabase(newDBInfo);
                    JobEntryDialog.this.reinitConnectionDropDown(wConnection, newDBInfo.getName());
                }
            }
        });
        FormData fdbwConnection = new FormData();
        fdbwConnection.right = new FormAttachment(100, 0);
        fdbwConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        wbwConnection.setLayoutData((Object)fdbwConnection);
        wbnConnection.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.NewConnectionButton.Label", (String[])new String[0]));
        wbnConnection.addSelectionListener((SelectionListener)new AddConnectionListener(wConnection));
        FormData fdbConnection = new FormData();
        fdbConnection.right = new FormAttachment((Control)wbwConnection, -margin);
        fdbConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        wbnConnection.setLayoutData((Object)fdbConnection);
        wbeConnection.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.EditConnectionButton.Label", (String[])new String[0]));
        wbeConnection.addSelectionListener((SelectionListener)new EditConnectionListener(wConnection));
        FormData fdeConnection = new FormData();
        fdeConnection.right = new FormAttachment((Control)wbnConnection, -margin);
        fdeConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        wbeConnection.setLayoutData((Object)fdeConnection);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(middle, 0);
        fdConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment((Control)wbeConnection, -margin);
        wConnection.setLayoutData((Object)fdConnection);
        return wConnection;
    }

    @VisibleForTesting
    String showDbDialogUnlessCancelledOrValid(DatabaseMeta changing, DatabaseMeta origin) {
        changing.shareVariablesWith((VariableSpace)this.jobMeta);
        DatabaseDialog cid = this.getDatabaseDialog();
        cid.setDatabaseMeta(changing);
        cid.setModalDialog(true);
        String name = null;
        boolean repeat = true;
        while (repeat) {
            name = cid.open();
            if (name == null) {
                repeat = false;
                continue;
            }
            DatabaseMeta same = this.jobMeta.findDatabase(name = name.trim());
            if (same == null || same == origin) {
                repeat = false;
                continue;
            }
            this.showDbExistsDialog(changing);
        }
        return name;
    }

    @VisibleForTesting
    void showDbExistsDialog(DatabaseMeta changing) {
        DatabaseDialog.showDatabaseExistsDialog(this.shell, changing);
    }

    private void reinitConnectionDropDown(CCombo dropDown, String selected) {
        dropDown.removeAll();
        this.addDatabases(dropDown);
        this.selectDatabase(dropDown, selected);
    }

    public void addDatabases(CCombo wConnection) {
        for (int i = 0; i < this.jobMeta.nrDatabases(); ++i) {
            DatabaseMeta ci = this.jobMeta.getDatabase(i);
            wConnection.add(ci.getName());
        }
    }

    public void selectDatabase(CCombo wConnection, String name) {
        int idx = wConnection.indexOf(name);
        if (idx >= 0) {
            wConnection.select(idx);
        }
    }

    public IMetaStore getMetaStore() {
        return this.metaStore;
    }

    public void setMetaStore(IMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    protected String getPathOf(RepositoryElementMetaInterface object) {
        return DialogUtils.getPathOf(object);
    }

    @VisibleForTesting
    class EditConnectionListener
    extends SelectionAdapter {
        private final CCombo wConnection;

        public EditConnectionListener(CCombo wConnection) {
            this.wConnection = wConnection;
        }

        public void widgetSelected(SelectionEvent e) {
            DatabaseMeta clone;
            String connectionName;
            DatabaseMeta databaseMeta = JobEntryDialog.this.jobMeta.findDatabase(this.wConnection.getText());
            if (databaseMeta != null && (connectionName = JobEntryDialog.this.showDbDialogUnlessCancelledOrValid(clone = (DatabaseMeta)databaseMeta.clone(), databaseMeta)) != null) {
                JobEntryDialog.this.jobMeta.removeDatabase(JobEntryDialog.this.jobMeta.indexOfDatabase(databaseMeta));
                JobEntryDialog.this.jobMeta.addDatabase(clone);
                JobEntryDialog.this.reinitConnectionDropDown(this.wConnection, connectionName);
            }
        }
    }

    @VisibleForTesting
    class AddConnectionListener
    extends SelectionAdapter {
        private final CCombo wConnection;

        public AddConnectionListener(CCombo wConnection) {
            this.wConnection = wConnection;
        }

        public void widgetSelected(SelectionEvent e) {
            DatabaseMeta databaseMeta = new DatabaseMeta();
            String connectionName = JobEntryDialog.this.showDbDialogUnlessCancelledOrValid(databaseMeta, null);
            if (connectionName != null) {
                JobEntryDialog.this.jobMeta.addDatabase(databaseMeta);
                JobEntryDialog.this.reinitConnectionDropDown(this.wConnection, databaseMeta.getName());
                ((Spoon)JobEntryDialog.this.spoonSupplier.get()).refreshTree(DBConnectionFolderProvider.STRING_CONNECTIONS);
            }
        }
    }
}

