/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.GetCaretPositionInterface;
import org.pentaho.di.ui.core.widget.InsertTextInterface;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.util.ImageUtil;

public class PasswordVisibleTextVar
extends Composite {
    VariableSpace space;
    PropsUI props = PropsUI.getInstance();
    private Button wVisibleButton;
    private static final Class<?> PKG = PasswordVisibleTextVar.class;
    public static final String NON_VISIBILE_IMAGE = "ui/images/show-inactive.png";
    public static final String VISIBLE_IMAGE = "ui/images/hide-inactive.png";
    private Composite parentComposite;
    private TextVar wTextVar;
    private int flags;
    private String toolTipText;
    private GetCaretPositionInterface getCaretPositionInterface;
    private InsertTextInterface insertTextInterface;
    private ModifyListener modifyListener;
    private boolean isTextVisible = false;

    public PasswordVisibleTextVar(VariableSpace space, Composite composite, int flags) {
        this(space, composite, flags, null, null, null);
    }

    public PasswordVisibleTextVar(VariableSpace space, Composite composite, int flags, String toolTipText) {
        this(space, composite, flags, toolTipText, null, null);
    }

    public PasswordVisibleTextVar(VariableSpace space, Composite composite, int flags, GetCaretPositionInterface getCaretPositionInterface, InsertTextInterface insertTextInterface) {
        this(space, composite, flags, null, getCaretPositionInterface, insertTextInterface);
    }

    public PasswordVisibleTextVar(VariableSpace space, Composite composite, int flags, String toolTipText, GetCaretPositionInterface getCaretPositionInterface, InsertTextInterface insertTextInterface) {
        super(composite, 0);
        this.space = space;
        this.parentComposite = composite;
        this.flags = flags;
        this.toolTipText = toolTipText;
        this.getCaretPositionInterface = getCaretPositionInterface;
        this.insertTextInterface = insertTextInterface;
        this.initialize(flags, toolTipText, getCaretPositionInterface, insertTextInterface);
    }

    protected void initialize(int flags, String toolTipText, GetCaretPositionInterface getCaretPositionInterface, InsertTextInterface insertTextInterface) {
        this.props.setLook((Control)this);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        formLayout.marginTop = 0;
        formLayout.marginBottom = 0;
        this.setLayout((Layout)formLayout);
        this.wVisibleButton = new Button((Composite)this, 8);
        this.props.setLook((Control)this.wVisibleButton);
        FormData fdButton = new FormData();
        fdButton.top = new FormAttachment(0, 0);
        fdButton.right = new FormAttachment(100, 0);
        this.wVisibleButton.setLayoutData((Object)fdButton);
        this.setTextVisible(false);
        this.wVisibleButton.addListener(13, event -> this.toggleVisible());
    }

    private void setTextVisible(boolean visible) {
        int flagsInEffect = visible ? this.flags : this.flags | 0x400000;
        TextVar newTextVar = new TextVar(this.space, this, flagsInEffect, this.toolTipText, this.getCaretPositionInterface, this.insertTextInterface);
        String value = null;
        if (this.wTextVar != null) {
            value = this.wTextVar.getText();
            newTextVar.setText(value);
            newTextVar.setLayoutData(this.wTextVar.getLayoutData());
            this.wTextVar.dispose();
        } else {
            FormData fdTextVar = new FormData();
            fdTextVar.top = new FormAttachment(0, 0);
            fdTextVar.left = new FormAttachment(0, 0);
            fdTextVar.right = new FormAttachment((Control)this.wVisibleButton, 0);
            newTextVar.setLayoutData(fdTextVar);
        }
        this.wTextVar = newTextVar;
        this.props.setLook((Control)this.wTextVar);
        this.wVisibleButton.setImage(ImageUtil.getImageAsResource(this.parentComposite.getDisplay(), visible ? VISIBLE_IMAGE : NON_VISIBILE_IMAGE));
        this.wVisibleButton.setToolTipText(BaseMessages.getString(PKG, (String)"PasswordVisibleTextVar.tooltip", (String[])new String[0]));
        if (this.modifyListener != null) {
            this.addModifyListener(this.modifyListener);
        }
        this.isTextVisible = visible;
        this.layout();
    }

    private void toggleVisible() {
        this.setTextVisible(!this.isTextVisible);
    }

    public TextVar getTextVarWidget() {
        return this.wTextVar;
    }

    public String getText() {
        return this.wTextVar.getText();
    }

    public Button getButton() {
        return this.wVisibleButton;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
        this.wTextVar.addModifyListener(modifyListener);
    }

    public void setText(String text) {
        this.wTextVar.setText(text);
    }

    protected ModifyListener getModifyListenerTooltipText(final Text textField) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                textField.setToolTipText(PasswordVisibleTextVar.this.toolTipText);
            }
        };
    }
}

