/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.ui.core.widget.SelectionLabel;

public class MultipleSelectionCombo
extends Composite {
    private Composite topRow = null;
    private Text displayText = null;
    private Button add = null;
    private Button arrow = null;
    private String[] displayItems;
    private int[] comboSelection = new int[0];
    private Shell floatShell = null;
    private List list = null;
    private String[] selectedItemLabels = new String[0];
    private Composite bottomRow;
    private MouseAdapter exitAction;
    private static final int MARGIN_OFFSET = 2;

    public Composite getTopRowComposite() {
        return this.topRow;
    }

    public Text getDisplayText() {
        return this.displayText;
    }

    public Button getAddButton() {
        return this.add;
    }

    public Button getArrowButton() {
        return this.arrow;
    }

    public String[] getSelectedItemLabels() {
        return this.selectedItemLabels;
    }

    public void setSelectedItemLabels(String[] selectedItemLabels) {
        this.selectedItemLabels = selectedItemLabels;
    }

    public Composite getBottomRow() {
        return this.bottomRow;
    }

    public MouseAdapter getExitAction() {
        return this.exitAction;
    }

    public MultipleSelectionCombo(Composite parent, int style) {
        super(parent, style);
        this.displayItems = new String[0];
        this.init();
    }

    protected void init() {
        GridLayout masterGridLayout = new GridLayout(1, true);
        masterGridLayout.marginBottom = 0;
        masterGridLayout.marginTop = 0;
        masterGridLayout.verticalSpacing = 0;
        this.setLayout((Layout)masterGridLayout);
        this.topRow = new Composite((Composite)this, 0);
        this.topRow.setLayout((Layout)new GridLayout(4, false));
        this.displayText = new Text(this.topRow, 2048);
        GridData gridData = new GridData(768);
        gridData.minimumWidth = 200;
        this.displayText.setLayoutData((Object)gridData);
        this.arrow = new Button(this.topRow, 1028);
        this.arrow.setBackground(Display.getCurrent().getSystemColor(9));
        this.arrow.setSize(25, 25);
        this.arrow.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                super.mouseDown(event);
                if (MultipleSelectionCombo.this.floatShell == null || MultipleSelectionCombo.this.floatShell.isDisposed()) {
                    MultipleSelectionCombo.this.closeOtherFloatShells();
                    MultipleSelectionCombo.this.initFloatShell();
                } else {
                    MultipleSelectionCombo.this.closeShellAndUpdate();
                }
            }
        });
        this.add = new Button(this.topRow, 8);
        this.add.setText("ADD");
        this.bottomRow = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        this.bottomRow.setLayout((Layout)gridLayout);
        GridData rowGridData = new GridData(0);
        rowGridData.widthHint = 297;
        rowGridData.minimumWidth = 297;
        this.bottomRow.setLayoutData((Object)rowGridData);
        this.exitAction = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                super.mouseUp(e);
                String labelText = ((SelectionLabel)((Label)e.widget).getParent()).getLabelText();
                if (!labelText.startsWith("$")) {
                    MultipleSelectionCombo.this.addRemovedTagBackToListUI(labelText);
                }
                MultipleSelectionCombo.access$502(MultipleSelectionCombo.this, MultipleSelectionCombo.this.removeItemFromSelectedList(labelText));
                SelectionLabel removedItem = (SelectionLabel)((Label)e.widget).getParent();
                Composite selectionArea = removedItem.getParent();
                int decreasedHeight = MultipleSelectionCombo.this.calculateTotalHeight(removedItem);
                removedItem.dispose();
                selectionArea.layout(true, true);
                int numRemainingItems = selectionArea.getChildren().length;
                if (numRemainingItems % 2 == 0) {
                    MultipleSelectionCombo.this.updateTagsUI(decreasedHeight);
                }
            }
        };
        this.add.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                super.mouseUp(e);
                if (MultipleSelectionCombo.this.floatShell != null && MultipleSelectionCombo.this.comboSelection != null && MultipleSelectionCombo.this.comboSelection.length > 0) {
                    HashSet<String> selectedItems = new HashSet<String>(MultipleSelectionCombo.this.comboSelection.length);
                    SelectionLabel ref = null;
                    for (int i = 0; i < MultipleSelectionCombo.this.comboSelection.length; ++i) {
                        ref = new SelectionLabel(MultipleSelectionCombo.this.bottomRow, 2048, MultipleSelectionCombo.this.displayItems[MultipleSelectionCombo.this.comboSelection[i]], MultipleSelectionCombo.this.exitAction);
                        selectedItems.add(MultipleSelectionCombo.this.displayItems[MultipleSelectionCombo.this.comboSelection[i]]);
                    }
                    MultipleSelectionCombo.access$902(MultipleSelectionCombo.this, (String[])Arrays.stream(MultipleSelectionCombo.this.displayItems).filter(item -> !selectedItems.contains(item)).toArray(String[]::new));
                    MultipleSelectionCombo.access$502(MultipleSelectionCombo.this, MultipleSelectionCombo.this.addToSelectedTags(selectedItems));
                    if (ref != null) {
                        MultipleSelectionCombo.this.updateTagsUI(MultipleSelectionCombo.this.calculateTotalHeight(ref));
                    }
                    MultipleSelectionCombo.access$702(MultipleSelectionCombo.this, new int[0]);
                    MultipleSelectionCombo.this.floatShell.dispose();
                }
            }
        });
    }

    private void closeOtherFloatShells() {
        Composite parent = this.getParent();
        while (!(parent instanceof Shell)) {
            Arrays.stream(parent.getChildren()).filter(c -> c instanceof MultipleSelectionCombo).forEach(c -> ((MultipleSelectionCombo)((Object)c)).triggerDropdownClose());
            parent = parent.getParent();
        }
    }

    private void addRemovedTagBackToListUI(String labelText) {
        String[] tempItems = new String[this.displayItems.length + 1];
        AtomicInteger idx = new AtomicInteger();
        Arrays.stream(this.displayItems).forEach(str -> {
            tempItems[idx.getAndIncrement()] = str;
        });
        tempItems[tempItems.length - 1] = labelText;
        this.displayItems = tempItems;
        Arrays.sort(this.displayItems);
    }

    private String[] removeItemFromSelectedList(String labelText) {
        String[] tempSelectedItems = new String[this.selectedItemLabels.length - 1];
        int tempIdx = 0;
        for (int i = 0; i < this.selectedItemLabels.length; ++i) {
            if (this.selectedItemLabels[i].equals(labelText)) continue;
            tempSelectedItems[tempIdx++] = this.selectedItemLabels[i];
        }
        return tempSelectedItems;
    }

    protected int calculateTotalHeight(SelectionLabel label) {
        GridLayout layout = (GridLayout)label.getLayout();
        return layout.marginHeight + label.getHeight();
    }

    protected void updateTagsUI(int height) {
        int numRows = this.selectedItemLabels.length / 2 + this.selectedItemLabels.length % 2;
        GridData newData = (GridData)this.bottomRow.getLayoutData();
        newData.minimumHeight = numRows * (height + 2);
        newData.heightHint = numRows * (height + 2);
        this.bottomRow.setLayoutData((Object)newData);
        this.triggerShellResize();
    }

    private String[] addToSelectedTags(Set<String> selectedItems) {
        if (this.selectedItemLabels.length == 0) {
            this.selectedItemLabels = new String[selectedItems.size()];
            return selectedItems.toArray(this.selectedItemLabels);
        }
        String[] tempLabels = new String[this.selectedItemLabels.length + selectedItems.size()];
        int tempIdx = 0;
        for (int i = 0; i < this.selectedItemLabels.length; ++i) {
            tempLabels[tempIdx++] = this.selectedItemLabels[i];
        }
        String[] selectedAry = new String[selectedItems.size()];
        selectedItems.toArray(selectedAry);
        for (int i = 0; i < selectedAry.length; ++i) {
            tempLabels[tempIdx++] = selectedAry[i];
        }
        return tempLabels;
    }

    private void triggerShellResize() {
        Composite scrollFinder = this.findScrollingParent();
        if (scrollFinder != null) {
            scrollFinder.layout(true, true);
            Point p = scrollFinder.getSize();
            Point size = scrollFinder.computeSize(p.x, p.y, true);
            scrollFinder.setSize(size);
        }
    }

    private Composite findScrollingParent() {
        Composite finder;
        for (finder = this.getParent(); finder != null && !(finder instanceof ScrolledComposite); finder = finder.getParent()) {
        }
        return finder;
    }

    private void initFloatShell() {
        Point p = this.displayText.getParent().toDisplay(this.displayText.getLocation());
        Point size = this.displayText.getSize();
        Rectangle shellRect = new Rectangle(p.x, p.y + size.y, size.x, 0);
        this.floatShell = new Shell(this.getShell(), 8);
        GridLayout gl = new GridLayout();
        gl.marginBottom = 2;
        gl.marginTop = 2;
        gl.marginRight = 0;
        gl.marginLeft = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.floatShell.setLayout((Layout)gl);
        this.list = new List((Composite)this.floatShell, 2818);
        for (String value : this.displayItems) {
            this.list.add(value);
        }
        GridData gd = new GridData(1808);
        this.list.setLayoutData((Object)gd);
        this.floatShell.setSize(shellRect.width, 100);
        this.floatShell.setLocation(shellRect.x, shellRect.y);
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                super.mouseUp(event);
                MultipleSelectionCombo.access$702(MultipleSelectionCombo.this, MultipleSelectionCombo.this.list.getSelectionIndices());
            }
        });
        Listener listener = event -> this.floatShell.dispose();
        Composite scroll = this.findScrollingParent();
        if (scroll != null) {
            scroll.getVerticalBar().addListener(13, listener);
        }
        this.getShell().addListener(11, listener);
        this.getShell().addListener(10, listener);
        this.floatShell.open();
    }

    private void closeShellAndUpdate() {
        if (this.floatShell != null && !this.floatShell.isDisposed()) {
            this.comboSelection = this.list.getSelectionIndices();
            this.floatShell.dispose();
        }
    }

    private void bindDataToUI() {
        HashSet<String> selectedSet = new HashSet<String>(this.selectedItemLabels.length);
        for (String label : this.selectedItemLabels) {
            new SelectionLabel(this.bottomRow, 2048, label, this.exitAction);
            selectedSet.add(label);
        }
        this.displayItems = (String[])Arrays.stream(this.displayItems).filter(item -> !selectedSet.contains(item)).toArray(String[]::new);
        this.triggerShellResize();
    }

    public void setItems(String[] items) {
        Arrays.sort(items);
        this.displayItems = (String[])Arrays.stream(items).toArray(String[]::new);
    }

    public String getSelectedItems() {
        return String.join((CharSequence)",", this.selectedItemLabels);
    }

    public void setSelectedItems(String selectedItems) {
        if (!StringUtil.isEmpty((String)selectedItems)) {
            this.selectedItemLabels = selectedItems.split(",");
            this.bindDataToUI();
        }
    }

    public void triggerDropdownClose() {
        if (this.floatShell != null && !this.floatShell.isDisposed()) {
            this.floatShell.dispose();
        }
    }

    @Deprecated
    public String getText() {
        return this.getSelectedItems();
    }

    @Deprecated
    public void setText(String selectedItems) {
        this.setSelectedItems(selectedItems);
    }

    static /* synthetic */ String[] access$502(MultipleSelectionCombo x0, String[] x1) {
        x0.selectedItemLabels = x1;
        return x1;
    }

    static /* synthetic */ String[] access$902(MultipleSelectionCombo x0, String[] x1) {
        x0.displayItems = x1;
        return x1;
    }

    static /* synthetic */ int[] access$702(MultipleSelectionCombo x0, int[] x1) {
        x0.comboSelection = x1;
        return x1;
    }
}

