/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.ExecutionConfiguration;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ArgumentsDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.util.HelpUtils;

public abstract class ConfigurationDialog
extends Dialog {
    protected AbstractMeta abstractMeta;
    protected ExecutionConfiguration configuration;
    protected TableView wVariables;
    protected boolean retval;
    protected Shell shell;
    protected PropsUI props;
    protected Button wGatherMetrics;
    protected Label wlLogLevel;
    protected Group gDetails;
    protected CCombo wLogLevel;
    protected Button wSafeMode;
    protected Button wClearLog;
    protected int margin = 4;
    protected Composite composite;
    protected Composite cContainer;
    protected Composite cRunConfiguration;
    protected CCombo wRunConfiguration;
    private TableView wParams;
    private Display display;
    private Shell parent;
    private Button wOK;
    private Button wCancel;
    protected FormData fdDetails;
    private FormData fd_tabFolder;
    private CTabFolder tabFolder;
    private Button alwaysShowOption;

    public ConfigurationDialog(Shell parent, ExecutionConfiguration configuration, AbstractMeta meta) {
        super(parent);
        String[] paramNames;
        this.parent = parent;
        this.configuration = configuration;
        this.abstractMeta = meta;
        Map params = configuration.getParams();
        params.clear();
        for (String name : paramNames = meta.listParameters()) {
            params.put(name, "");
        }
        this.props = PropsUI.getInstance();
    }

    protected void getInfoVariables() {
        HashMap<String, String> map = new HashMap<String, String>();
        int nrNonEmptyVariables = this.wVariables.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyVariables; ++i) {
            TableItem tableItem = this.wVariables.getNonEmpty(i);
            String varName = tableItem.getText(1);
            String varValue = tableItem.getText(2);
            if (Utils.isEmpty((CharSequence)varName)) continue;
            map.put(varName, varValue);
        }
        this.configuration.setVariables(map);
    }

    protected void getInfoParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        int nrNonEmptyVariables = this.wParams.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyVariables; ++i) {
            TableItem tableItem = this.wParams.getNonEmpty(i);
            String paramName = tableItem.getText(1);
            String defaultValue = tableItem.getText(2);
            String paramValue = tableItem.getText(3);
            if (Utils.isEmpty((CharSequence)paramValue)) {
                paramValue = Const.NVL((String)defaultValue, (String)"");
            }
            map.put(paramName, paramValue);
        }
        this.configuration.setParams(map);
    }

    protected void ok() {
        this.abstractMeta.setAlwaysShowRunOptions(this.alwaysShowOption.getSelection());
        this.abstractMeta.setShowDialog(this.alwaysShowOption.getSelection());
        if (Const.isOSX()) {
            this.wVariables.applyOSXChanges();
            this.wParams.applyOSXChanges();
        }
        this.getInfo();
        this.retval = true;
        this.dispose();
    }

    private void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    protected void cancel() {
        this.dispose();
    }

    public abstract void getInfo();

    protected void getParamsData() {
        this.wParams.clearAll(false);
        ArrayList paramNames = new ArrayList(this.configuration.getParams().keySet());
        Collections.sort(paramNames);
        for (int i = 0; i < paramNames.size(); ++i) {
            String description;
            String defaultValue;
            String paramName = (String)paramNames.get(i);
            String paramValue = (String)this.configuration.getParams().get(paramName);
            try {
                defaultValue = this.abstractMeta.getParameterDefault(paramName);
            }
            catch (UnknownParamException e) {
                defaultValue = "";
            }
            try {
                description = this.abstractMeta.getParameterDescription(paramName);
            }
            catch (UnknownParamException e) {
                description = "";
            }
            TableItem tableItem = new TableItem(this.wParams.table, 0);
            tableItem.setText(1, paramName);
            tableItem.setText(2, Const.NVL((String)defaultValue, (String)""));
            tableItem.setText(3, Const.NVL((String)paramValue, (String)""));
            tableItem.setText(4, Const.NVL((String)description, (String)""));
        }
        this.wParams.removeEmptyRows();
        this.wParams.setRowNums();
        this.wParams.optWidth(true);
    }

    public void setConfiguration(ExecutionConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void mainLayout(Class<?> PKG, String prefix, Image img) {
        this.display = this.parent.getDisplay();
        this.shell = new Shell(this.parent, 68848);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(img);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(BaseMessages.getString(PKG, (String)(prefix + ".Shell.Title"), (String[])new String[0]));
        this.cContainer = new Composite((Composite)this.shell, 0);
        this.cContainer.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).top(0, 0).bottom(100, 0).result());
        FormLayout cLayout = new FormLayout();
        cLayout.marginWidth = 5;
        cLayout.marginHeight = 5;
        this.cContainer.setLayout((Layout)cLayout);
        this.props.setLook((Control)this.cContainer);
    }

    protected void optionsSectionLayout(Class<?> PKG, String prefix) {
        this.gDetails = new Group(this.cContainer, 16);
        this.gDetails.setText(BaseMessages.getString(PKG, (String)(prefix + ".DetailsGroup.Label"), (String[])new String[0]));
        this.props.setLook((Control)this.gDetails);
        this.gDetails.setLayout((Layout)new FormLayout());
        this.fdDetails = new FormData();
        this.fdDetails.top = new FormAttachment((Control)this.cRunConfiguration, 5);
        this.fdDetails.right = new FormAttachment(100, -5);
        this.fdDetails.left = new FormAttachment(0, 5);
        this.gDetails.setBackground(this.shell.getBackground());
        this.gDetails.setLayoutData((Object)this.fdDetails);
        this.optionsSectionControls();
    }

    protected void parametersSectionLayout(Class<?> PKG, String prefix) {
        this.tabFolder = new CTabFolder(this.cContainer, 2048);
        this.props.setLook((Control)this.tabFolder, 5);
        this.fd_tabFolder = new FormData();
        this.fd_tabFolder.right = new FormAttachment(100, -5);
        this.fd_tabFolder.left = new FormAttachment(0, 5);
        this.fd_tabFolder.top = new FormAttachment((Control)this.gDetails, 5);
        this.fd_tabFolder.bottom = new FormAttachment((Control)this.gDetails, 370);
        this.tabFolder.setLayoutData((Object)this.fd_tabFolder);
        CTabItem tbtmParameters = new CTabItem(this.tabFolder, 0);
        tbtmParameters.setText(BaseMessages.getString(PKG, (String)(prefix + ".Params.Label"), (String[])new String[0]));
        ScrolledComposite paramScrollContainer = new ScrolledComposite((Composite)this.tabFolder, 768);
        paramScrollContainer.setLayout((Layout)new FormLayout());
        paramScrollContainer.setExpandHorizontal(true);
        paramScrollContainer.setExpandVertical(true);
        paramScrollContainer.setMinSize(200, 200);
        Composite parametersComposite = new Composite((Composite)paramScrollContainer, 0);
        this.props.setLook((Control)parametersComposite);
        parametersComposite.setLayout((Layout)new FormLayout());
        parametersComposite.setParent((Composite)paramScrollContainer);
        paramScrollContainer.setContent((Control)parametersComposite);
        tbtmParameters.setControl((Control)paramScrollContainer);
        ColumnInfo[] cParams = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)(prefix + ".ParamsColumn.Argument"), (String[])new String[0]), 1, false, true, 126), new ColumnInfo(BaseMessages.getString(PKG, (String)(prefix + ".ParamsColumn.Default"), (String[])new String[0]), 1, false, true, 138), new ColumnInfo(BaseMessages.getString(PKG, (String)(prefix + ".ParamsColumn.Value"), (String[])new String[0]), 1, false, false, 142), new ColumnInfo(BaseMessages.getString(PKG, (String)(prefix + ".ParamsColumn.Description"), (String[])new String[0]), 1, false, true, 181)};
        String[] namedParams = this.abstractMeta.listParameters();
        int nrParams = namedParams.length;
        this.wParams = new TableView((VariableSpace)this.abstractMeta, parametersComposite, 68354, cParams, nrParams, false, null, this.props, false);
        FormData fdParams = new FormData();
        fdParams.top = new FormAttachment(0, 5);
        fdParams.right = new FormAttachment(100, -5);
        fdParams.bottom = new FormAttachment(100, -55);
        fdParams.left = new FormAttachment(0, 5);
        this.wParams.setLayoutData(fdParams);
        this.tabFolder.setSelection(0);
        Composite argsButtonComposite = new Composite(parametersComposite, 0);
        GridLayout argsButtonLayout = new GridLayout();
        argsButtonLayout.numColumns = 1;
        argsButtonComposite.setLayout((Layout)argsButtonLayout);
        Button argsButton = new Button(argsButtonComposite, 0);
        FormData fd_argsButton = new FormData();
        fd_argsButton.right = new FormAttachment(100, -5);
        fd_argsButton.top = new FormAttachment((Control)this.wParams, 5);
        fd_argsButton.bottom = new FormAttachment(100, -5);
        argsButtonComposite.setLayoutData((Object)fd_argsButton);
        argsButtonComposite.setBackground(this.shell.getBackground());
        argsButton.setLayoutData((Object)argsButtonComposite);
        GridData gridData = new GridData(128);
        argsButton.setText(BaseMessages.getString(PKG, (String)(prefix + ".Arguments.Label"), (String[])new String[0]));
        argsButton.setLayoutData((Object)gridData);
        argsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new ArgumentsDialog(ConfigurationDialog.this.shell, ConfigurationDialog.this.configuration, ConfigurationDialog.this.abstractMeta);
            }
        });
        CTabItem tbtmVariables = new CTabItem(this.tabFolder, 0);
        tbtmVariables.setText(BaseMessages.getString(PKG, (String)(prefix + ".Variables.Label"), (String[])new String[0]));
        Composite variablesComposite = new Composite((Composite)this.tabFolder, 0);
        this.props.setLook((Control)variablesComposite);
        variablesComposite.setLayout((Layout)new FormLayout());
        tbtmVariables.setControl((Control)variablesComposite);
        ColumnInfo[] cVariables = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)(prefix + ".VariablesColumn.Argument"), (String[])new String[0]), 1, false, false, 287), new ColumnInfo(BaseMessages.getString(PKG, (String)(prefix + ".VariablesColumn.Value"), (String[])new String[0]), 1, false, false, 300)};
        int nrVariables = this.configuration.getVariables() != null ? this.configuration.getVariables().size() : 0;
        this.wVariables = new TableView((VariableSpace)this.abstractMeta, variablesComposite, 68354, cVariables, nrVariables, false, null, this.props, false);
        FormData fdVariables = new FormData();
        fdVariables.top = new FormAttachment(0, 5);
        fdVariables.right = new FormAttachment(100, -5);
        fdVariables.bottom = new FormAttachment(100, -5);
        fdVariables.left = new FormAttachment(0, 5);
        this.wVariables.setLayoutData(fdVariables);
    }

    protected void buttonsSectionLayout(Class<?> PKG, String prefix, final String docTitle, final String docUrl, final String docHeader) {
        Composite bContainer = new Composite(this.cContainer, 0);
        this.props.setLook((Control)bContainer);
        bContainer.setLayoutData((Object)new FormDataBuilder().left(0, 0).right(100, 0).bottom(100, 0).result());
        bContainer.setLayout((Layout)new FormLayout());
        this.fd_tabFolder.bottom = new FormAttachment((Control)bContainer, -5);
        this.alwaysShowOption = new Button(bContainer, 32);
        this.props.setLook((Control)this.alwaysShowOption);
        this.alwaysShowOption.setSelection(this.abstractMeta.isAlwaysShowRunOptions());
        this.alwaysShowOption.setToolTipText(BaseMessages.getString(PKG, (String)(prefix + ".alwaysShowOption"), (String[])new String[0]));
        FormData fd_alwaysShowOption = new FormData();
        fd_alwaysShowOption.left = new FormAttachment(0, 5);
        fd_alwaysShowOption.top = new FormAttachment(0, 5);
        this.alwaysShowOption.setLayoutData((Object)fd_alwaysShowOption);
        this.alwaysShowOption.setText(BaseMessages.getString(PKG, (String)(prefix + ".AlwaysOption.Value"), (String[])new String[0]));
        this.wCancel = new Button(bContainer, 8);
        FormData fd_wCancel = new FormData();
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationDialog.this.cancel();
            }
        });
        this.wOK = new Button(bContainer, 8);
        FormData fd_wOK = new FormData();
        fd_wOK.top = new FormAttachment((Control)this.wCancel, 0, 128);
        fd_wOK.right = new FormAttachment((Control)this.wCancel, -5);
        this.wOK.setLayoutData((Object)fd_wOK);
        this.wOK.setText(BaseMessages.getString(PKG, (String)(prefix + ".Button.Launch"), (String[])new String[0]));
        this.wOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationDialog.this.ok();
            }
        });
        Button btnHelp = new Button(bContainer, 0);
        btnHelp.setImage(GUIResource.getInstance().getImageHelpWeb());
        btnHelp.setText(BaseMessages.getString(PKG, (String)"System.Button.Help", (String[])new String[0]));
        btnHelp.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.Help", (String[])new String[0]));
        FormData fd_btnHelp = new FormData();
        fd_btnHelp.left = new FormAttachment(0, 5);
        btnHelp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                HelpUtils.openHelpDialog(ConfigurationDialog.this.parent.getShell(), docTitle, docUrl, docHeader);
            }
        });
        Label separator = new Label(bContainer, 258);
        fd_wCancel.top = Const.isLinux() ? new FormAttachment((Control)separator, 10) : new FormAttachment((Control)separator, 15);
        fd_btnHelp.top = Const.isLinux() ? new FormAttachment((Control)separator, 10) : new FormAttachment((Control)separator, 15);
        fd_wCancel.right = new FormAttachment(100, -5);
        this.wCancel.setLayoutData((Object)fd_wCancel);
        btnHelp.setLayoutData((Object)fd_btnHelp);
        FormData fd_separator = new FormData();
        fd_separator.right = new FormAttachment(100, -5);
        fd_separator.left = new FormAttachment(0, 5);
        fd_separator.top = new FormAttachment((Control)this.alwaysShowOption, 5);
        separator.setLayoutData((Object)fd_separator);
    }

    protected void openDialog() {
        this.shell.pack();
        this.wOK.setFocus();
        Rectangle shellBounds = this.getParent().getBounds();
        this.shell.setSize(this.shell.getSize().x, (int)((double)shellBounds.height * 0.6));
        Point dialogSize = this.shell.getSize();
        this.shell.setLocation(shellBounds.x + (shellBounds.width - dialogSize.x) / 2, shellBounds.y + (shellBounds.height - dialogSize.y) / 2);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    protected void runConfigurationSectionLayout(Class<?> PKG, String prefix) {
        this.cRunConfiguration = new Composite(this.cContainer, 0);
        this.cRunConfiguration.setLayout((Layout)new FormLayout());
        this.props.setLook((Control)this.cRunConfiguration);
        FormData fdLocal = new FormData();
        fdLocal.top = new FormAttachment(0, 5);
        fdLocal.right = new FormAttachment(100, -5);
        fdLocal.left = new FormAttachment(0, 5);
        this.cRunConfiguration.setBackground(this.shell.getBackground());
        this.cRunConfiguration.setLayoutData((Object)fdLocal);
        Label wlRunConfiguration = new Label(this.cRunConfiguration, 16384);
        this.props.setLook((Control)wlRunConfiguration);
        wlRunConfiguration.setText("Run configuration:");
        FormData fdlRunConfiguration = new FormData();
        fdlRunConfiguration.top = new FormAttachment(0);
        fdlRunConfiguration.left = new FormAttachment(0);
        wlRunConfiguration.setLayoutData((Object)fdlRunConfiguration);
        this.wRunConfiguration = new CCombo(this.cRunConfiguration, 2048);
        this.props.setLook((Control)this.wRunConfiguration);
        FormData fdRunConfiguration = new FormData();
        fdRunConfiguration.width = 200;
        fdRunConfiguration.top = new FormAttachment((Control)wlRunConfiguration, 5);
        fdRunConfiguration.left = new FormAttachment(0);
        this.wRunConfiguration.setLayoutData((Object)fdRunConfiguration);
    }

    protected abstract void optionsSectionControls();
}

