/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.wizard;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.GenericDatabaseMeta;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.wizard.CreateDatabaseWizard;
import org.pentaho.di.ui.core.database.wizard.CreateDatabaseWizardPageJDBC;

public class CreateDatabaseWizardPage1
extends WizardPage {
    private static Class<?> PKG = CreateDatabaseWizard.class;
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private Label wlDBType;
    private org.eclipse.swt.widgets.List wDBType;
    private FormData fdlDBType;
    private FormData fdDBType;
    private Label wlAccType;
    private org.eclipse.swt.widgets.List wAccType;
    private FormData fdlAccType;
    private FormData fdAccType;
    private PropsUI props;
    private DatabaseMeta databaseMeta;
    private List<DatabaseMeta> databases;
    private Map<String, String> wDBIDtoNameMap = new HashMap<String, String>();

    public CreateDatabaseWizardPage1(String arg, PropsUI props, DatabaseMeta databaseMeta, List<DatabaseMeta> databases) {
        super(arg);
        this.props = props;
        this.databaseMeta = databaseMeta;
        this.databases = databases;
        this.setTitle(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPage1.DialogTitle", (String[])new String[0]));
        this.setDescription(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPage1.DialogMessage", (String[])new String[0]));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        int margin = 4;
        int middle = this.props.getMiddlePct();
        Composite composite = new Composite(parent, 0);
        this.props.setLook((Control)composite);
        FormLayout compLayout = new FormLayout();
        compLayout.marginHeight = 5;
        compLayout.marginWidth = 5;
        composite.setLayout((Layout)compLayout);
        this.wlName = new Label(composite, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPage1.DBName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.top = new FormAttachment(0, 0);
        this.fdlName.right = new FormAttachment(middle, 0);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text(composite, 2052);
        this.props.setLook((Control)this.wName);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateDatabaseWizardPage1.this.setPageComplete(false);
            }
        });
        this.wlDBType = new Label(composite, 131072);
        this.wlDBType.setText(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPage1.DBType.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDBType);
        this.fdlDBType = new FormData();
        this.fdlDBType.left = new FormAttachment(0, 0);
        this.fdlDBType.top = new FormAttachment((Control)this.wName, margin);
        this.fdlDBType.right = new FormAttachment(middle, 0);
        this.wlDBType.setLayoutData((Object)this.fdlDBType);
        this.wDBType = new org.eclipse.swt.widgets.List(composite, 2820);
        this.props.setLook((Control)this.wDBType);
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(DatabasePluginType.class);
        Collections.sort(plugins, new Comparator<PluginInterface>(){

            @Override
            public int compare(PluginInterface o1, PluginInterface o2) {
                return o1.getName().toUpperCase().compareTo(o2.getName().toUpperCase());
            }
        });
        for (PluginInterface plugin : plugins) {
            try {
                this.wDBType.add(plugin.getName());
                this.wDBIDtoNameMap.put(plugin.getIds()[0], plugin.getName());
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating class for: " + plugin, e);
            }
        }
        int idx = this.wDBType.indexOf(this.wDBIDtoNameMap.get(this.databaseMeta.getPluginId()));
        if (idx >= 0) {
            this.wDBType.select(idx);
        } else {
            this.wDBType.select(0);
        }
        this.fdDBType = new FormData();
        this.fdDBType.top = new FormAttachment((Control)this.wName, margin);
        this.fdDBType.left = new FormAttachment(middle, margin);
        this.fdDBType.bottom = new FormAttachment(80, 0);
        this.fdDBType.right = new FormAttachment(100, 0);
        this.wDBType.setLayoutData((Object)this.fdDBType);
        this.wDBType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateDatabaseWizardPage1.this.setAccessTypes();
                CreateDatabaseWizardPage1.this.setPageComplete(false);
            }
        });
        this.wlAccType = new Label(composite, 131072);
        this.wlAccType.setText(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPage1.DBAccessType.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAccType);
        this.fdlAccType = new FormData();
        this.fdlAccType.left = new FormAttachment(0, 0);
        this.fdlAccType.top = new FormAttachment((Control)this.wDBType, margin);
        this.fdlAccType.right = new FormAttachment(middle, 0);
        this.wlAccType.setLayoutData((Object)this.fdlAccType);
        this.wAccType = new org.eclipse.swt.widgets.List(composite, 2820);
        this.props.setLook((Control)this.wAccType);
        this.fdAccType = new FormData();
        this.fdAccType.top = new FormAttachment((Control)this.wDBType, margin);
        this.fdAccType.left = new FormAttachment(middle, margin);
        this.fdAccType.bottom = new FormAttachment(100, 0);
        this.fdAccType.right = new FormAttachment(100, 0);
        this.wAccType.setLayoutData((Object)this.fdAccType);
        this.wAccType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateDatabaseWizardPage1.this.setPageComplete(false);
            }
        });
        this.setAccessTypes();
        this.setControl((Control)composite);
    }

    public void setAccessTypes() {
        if (this.wDBType.getSelectionCount() < 1) {
            return;
        }
        int[] acc = DatabaseMeta.getAccessTypeList((String)this.wDBType.getSelection()[0]);
        this.wAccType.removeAll();
        for (int i = 0; i < acc.length; ++i) {
            this.wAccType.add(DatabaseMeta.getAccessTypeDescLong((int)acc[i]));
        }
        if (this.wAccType.getSelectionIndex() < 0) {
            this.wAccType.select(0);
        }
    }

    public boolean canFlipToNextPage() {
        String acType;
        String name = this.wName.getText() != null ? (this.wName.getText().length() > 0 ? this.wName.getText() : null) : null;
        String dbType = this.wDBType.getSelection().length == 1 ? this.wDBType.getSelection()[0] : null;
        String string = acType = this.wAccType.getSelection().length == 1 ? this.wAccType.getSelection()[0] : null;
        if (name == null || dbType == null || acType == null) {
            this.setErrorMessage(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPage1.ErrorMessage.InvalidInput", (String[])new String[0]));
            return false;
        }
        if (name != null && DatabaseMeta.findDatabase(this.databases, (String)name) != null) {
            this.setErrorMessage(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPage1.ErrorMessage.DBNameExists", (String[])new String[]{name.trim()}));
            return false;
        }
        this.getDatabaseInfo();
        this.setErrorMessage(null);
        this.setMessage(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPage1.Message.Next", (String[])new String[0]));
        return true;
    }

    public DatabaseMeta getDatabaseInfo() {
        String[] accTypeSel;
        String[] dbTypeSel;
        if (this.wName.getText() != null && this.wName.getText().length() > 0) {
            this.databaseMeta.setName(this.wName.getText());
            this.databaseMeta.setDisplayName(this.wName.getText());
        }
        if ((dbTypeSel = this.wDBType.getSelection()) != null && dbTypeSel.length == 1) {
            this.databaseMeta.setDatabaseType(dbTypeSel[0]);
        }
        if ((accTypeSel = this.wAccType.getSelection()) != null && accTypeSel.length == 1) {
            this.databaseMeta.setAccessType(DatabaseMeta.getAccessType((String)accTypeSel[0]));
        }
        this.databaseMeta.setDBPort(String.valueOf(this.databaseMeta.getDefaultDatabasePort()));
        return this.databaseMeta;
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage;
        IWizard wiz = this.getWizard();
        switch (this.databaseMeta.getAccessType()) {
            case 2: {
                nextPage = wiz.getPage("oci");
                break;
            }
            case 1: {
                nextPage = wiz.getPage("odbc");
                break;
            }
            case 3: {
                nextPage = wiz.getPage(this.databaseMeta.getPluginId());
                break;
            }
            default: {
                if (this.databaseMeta.getDatabaseInterface() instanceof GenericDatabaseMeta) {
                    nextPage = wiz.getPage("generic");
                    break;
                }
                nextPage = wiz.getPage("jdbc");
                if (nextPage == null) break;
                ((CreateDatabaseWizardPageJDBC)nextPage).setData();
            }
        }
        return nextPage;
    }

    public boolean canPerformFinish() {
        return false;
    }
}

