/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.vfs.connections.ui.dialog;

import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.CheckBoxVar;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.PasswordTextVar;
import org.pentaho.di.ui.core.widget.PasswordVisibleTextVar;
import org.pentaho.di.ui.core.widget.TextVar;

public class VFSDetailsCompositeHelper {
    private PropsUI props;
    private int margin;
    private int maxLabelWidth = 0;
    private final Class<?> pkg;

    public VFSDetailsCompositeHelper() throws IllegalAccessException {
        throw new IllegalAccessException("Must use the messageClass, props constructor");
    }

    public VFSDetailsCompositeHelper(Class<?> messageClass, PropsUI props) {
        this.props = props;
        this.margin = 4;
        this.pkg = messageClass;
    }

    public PropsUI getProps() {
        return this.props;
    }

    public int getMaxLabelWidth() {
        return this.maxLabelWidth;
    }

    public int getMargin() {
        return this.margin;
    }

    public Label createLabel(Composite composite, int flags, String key, Control topWidget) {
        Label label = new Label(composite, flags);
        this.getProps().setLook((Control)label);
        label.setText(BaseMessages.getString(this.pkg, (String)key, (String[])new String[0]));
        this.maxLabelWidth = Math.max(this.maxLabelWidth, label.computeSize((int)-1, (int)-1).x);
        label.setLayoutData((Object)this.getFormDataLabel(topWidget));
        return label;
    }

    public Text createText(Composite composite, int flags, Control topWidget, int width) {
        Text text = new Text(composite, flags);
        this.getProps().setLook((Control)text);
        text.setLayoutData((Object)this.getFormDataField(topWidget, width));
        return text;
    }

    public TextVar createTextVar(VariableSpace variableSpace, Composite composite, int flags, Control topWidget, int width) {
        TextVar textVar = new TextVar(variableSpace, composite, flags);
        this.getProps().setLook((Control)textVar);
        textVar.setLayoutData(this.getFormDataField(topWidget, width));
        return textVar;
    }

    public CCombo createCCombo(Composite composite, int flags, Control topWidget, int width) {
        CCombo cCombo = new CCombo(composite, flags);
        this.getProps().setLook((Control)cCombo);
        cCombo.setLayoutData((Object)this.getFormDataField(topWidget, width));
        return cCombo;
    }

    public ComboVar createComboVar(VariableSpace variableSpace, Composite composite, int flags, Control topWidget, int width) {
        ComboVar comboVar = new ComboVar(variableSpace, composite, flags);
        this.getProps().setLook((Control)comboVar);
        comboVar.setLayoutData(this.getFormDataField(topWidget, width));
        return comboVar;
    }

    public PasswordTextVar createPasswordTextVar(VariableSpace variableSpace, Composite composite, int flags, Control topWidget, int width) {
        PasswordTextVar passwordTextVar = new PasswordTextVar(variableSpace, composite, flags);
        this.getProps().setLook((Control)passwordTextVar);
        passwordTextVar.setLayoutData(this.getFormDataField(topWidget, width));
        return passwordTextVar;
    }

    public PasswordVisibleTextVar createPasswordVisibleTextVar(VariableSpace variableSpace, Composite composite, int flags, Control topWidget, int width) {
        PasswordVisibleTextVar PasswordVisibleTextVar2 = new PasswordVisibleTextVar(variableSpace, composite, flags);
        this.getProps().setLook((Control)PasswordVisibleTextVar2);
        PasswordVisibleTextVar2.setLayoutData(this.getFormDataField(topWidget, width));
        return PasswordVisibleTextVar2;
    }

    public CheckBoxVar createCheckboxVar(VariableSpace variableSpace, Composite composite, Control topWidget) {
        CheckBoxVar checkBoxVar = new CheckBoxVar(variableSpace, composite, 32);
        this.getProps().setLook((Control)checkBoxVar);
        checkBoxVar.setLayoutData(this.getFormDataField(topWidget));
        return checkBoxVar;
    }

    public Label createTitleLabel(Composite composite, String key, Set<Control> skipControls) {
        Label wlTitle = new Label(composite, 0x1000000);
        FontData[] fD = wlTitle.getFont().getFontData();
        fD[0].setHeight(14);
        wlTitle.setFont(new Font((Device)wlTitle.getDisplay(), fD[0]));
        this.props.setLook((Control)wlTitle);
        wlTitle.setText(BaseMessages.getString(this.pkg, (String)key, (String[])new String[0]));
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        wlTitle.setLayoutData((Object)formData);
        skipControls.add((Control)wlTitle);
        return wlTitle;
    }

    public FormData getFormDataLabel(Control topWidget) {
        FormData formData = new FormData();
        formData.top = topWidget == null ? new FormAttachment(0, this.margin * 2) : new FormAttachment(topWidget, this.margin * 2);
        formData.left = new FormAttachment(0, 0);
        return formData;
    }

    public FormData getFormDataField(Control topWidget) {
        return this.getFormDataField(topWidget, 0);
    }

    public FormData getFormDataField(Control topWidget, int width) {
        FormData formData = new FormData();
        formData.top = topWidget == null ? new FormAttachment(0, this.margin * 2) : new FormAttachment(topWidget, this.margin * 2);
        if (width == 0) {
            formData.right = new FormAttachment(100, -this.margin - 9);
        }
        formData.left = new FormAttachment(0, 0);
        return formData;
    }

    public static void setupCompositeResizeListener(Composite wComposite) {
        wComposite.getParent().addListener(11, arg0 -> VFSDetailsCompositeHelper.updateScrollableRegion(wComposite));
    }

    public static void updateScrollableRegion(Composite wComposite) {
        Rectangle r = wComposite.getParent().getClientArea();
        if (r.width != 0) {
            wComposite.setSize(r.width, -1);
        }
    }
}

