/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import java.util.LinkedHashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;
import org.pentaho.reporting.engine.classic.core.states.process.SubReportProcessType;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class InlineSubreportProcessor {
    private static InstanceID DUMMY_SUBREPORT_MARKER = new InstanceID();
    private static InlineSubreportMarker[] EMPTY_MARKERS = new InlineSubreportMarker[0];

    private InlineSubreportProcessor() {
    }

    private static InlineSubreportMarker[] collectMarkers(ProcessState state, RootLevelBand rootLevelBand) throws ReportProcessingException {
        Map<InstanceID, InlineSubreportMarker> markers = InlineSubreportProcessor.collectSubReportMarkers(state, rootLevelBand);
        if (markers == null || markers.size() == 0) {
            return EMPTY_MARKERS;
        }
        return markers.values().toArray(new InlineSubreportMarker[markers.size()]);
    }

    public static ProcessState processInline(ProcessState state, RootLevelBand rootLevelBand) throws ReportProcessingException {
        InlineSubreportMarker[] markers = InlineSubreportProcessor.collectMarkers(state, rootLevelBand);
        if (markers.length == 0) {
            return state;
        }
        state.getLayoutProcess().getOutputFunction().clearInlineSubreports(SubReportProcessType.INLINE);
        int index = InlineSubreportProcessor.findNextIndex(markers, SubReportProcessType.INLINE, 0);
        if (index == -1) {
            return state;
        }
        try {
            state = state.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
        ReportStateKey processKey = state.getProcessKey();
        ProcessState process = new ProcessState();
        process.initializeForSubreport(markers, index, state);
        while (!processKey.equals(process.getProcessKey())) {
            if (processKey.equals((process = process.advance()).getProcessKey())) {
                throw new IllegalStateException("You cannot switch contexts when not being commited!");
            }
            process = process.commit();
        }
        return process;
    }

    public static boolean hasSubReports(ProcessState state, RootLevelBand rootLevelBand) throws ReportProcessingException {
        Map<InstanceID, InlineSubreportMarker> markers = InlineSubreportProcessor.collectSubReportMarkers(state, rootLevelBand);
        return markers != null && markers.size() != 0;
    }

    public static ProcessState processBandedSubReports(ProcessState state, RootLevelBand rootLevelBand) throws ReportProcessingException {
        InlineSubreportMarker[] markers = InlineSubreportProcessor.collectMarkers(state, rootLevelBand);
        if (markers.length == 0) {
            return state;
        }
        state.getLayoutProcess().getOutputFunction().clearInlineSubreports(SubReportProcessType.BANDED);
        int index = InlineSubreportProcessor.findNextIndex(markers, SubReportProcessType.BANDED, 0);
        if (index == -1) {
            return state;
        }
        ProcessState pstate = new ProcessState();
        pstate.initializeForSubreport(markers, index, state);
        return pstate;
    }

    private static Map<InstanceID, InlineSubreportMarker> collectSubReportMarkers(ProcessState state, RootLevelBand rootLevelBand) throws ReportProcessingException {
        Map<InstanceID, InlineSubreportMarker> list = InlineSubreportProcessor.collectSubReportMarkers((Section)((Object)rootLevelBand), null);
        if (list == null) {
            InlineSubreportMarker[] subreports = state.getLayoutProcess().getOutputFunction().getInlineSubreports();
            if (subreports.length == 0) {
                return null;
            }
            LinkedHashMap<InstanceID, InlineSubreportMarker> map = new LinkedHashMap<InstanceID, InlineSubreportMarker>();
            for (int i = 0; i < subreports.length; ++i) {
                InlineSubreportMarker subreport = subreports[i];
                map.put(subreport.getSubreport().getObjectID(), subreport);
            }
            return map;
        }
        InlineSubreportMarker[] markers = state.getLayoutProcess().getOutputFunction().getInlineSubreports();
        for (int i = 0; i < markers.length; ++i) {
            InlineSubreportMarker marker = markers[i];
            list.put(marker.getSubreport().getObjectID(), marker);
        }
        return list;
    }

    private static Map collectBandedSubReportMarkers(RootLevelBand rootLevelBand, Map<InstanceID, InlineSubreportMarker> list) throws ReportProcessingException {
        int count = rootLevelBand.getSubReportCount();
        for (int i = 0; i < count; ++i) {
            SubReport element = rootLevelBand.getSubReport(i);
            if (list == null) {
                list = new LinkedHashMap<InstanceID, InlineSubreportMarker>();
            }
            list.put(element.getObjectID(), new InlineSubreportMarker(element, null, SubReportProcessType.BANDED));
        }
        return list;
    }

    private static Map<InstanceID, InlineSubreportMarker> collectSubReportMarkers(Section rootLevelBand, Map<InstanceID, InlineSubreportMarker> list) throws ReportProcessingException {
        if (rootLevelBand instanceof RootLevelBand) {
            list = InlineSubreportProcessor.collectBandedSubReportMarkers((RootLevelBand)((Object)rootLevelBand), list);
        }
        int count = rootLevelBand.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element element = rootLevelBand.getElement(i);
            if (element instanceof SubReport) {
                if (list == null) {
                    list = new LinkedHashMap<InstanceID, InlineSubreportMarker>();
                }
                list.put(element.getObjectID(), new InlineSubreportMarker((SubReport)element, DUMMY_SUBREPORT_MARKER, SubReportProcessType.INLINE));
                continue;
            }
            if (!(element instanceof Section)) continue;
            list = InlineSubreportProcessor.collectSubReportMarkers((Section)element, list);
        }
        return list;
    }

    public static int findNextIndex(InlineSubreportMarker[] markers, SubReportProcessType type, int startIndex) {
        for (int i = startIndex; i < markers.length; ++i) {
            InlineSubreportMarker marker = markers[i];
            if (marker.getProcessType() != type) continue;
            return i;
        }
        return -1;
    }
}

