/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base;

import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.AbstractObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectFactoryException;

public class Rectangle2DObjectDescription
extends AbstractObjectDescription {
    public Rectangle2DObjectDescription() {
        super(Rectangle2D.class);
        this.setParameterDefinition("width", Float.class);
        this.setParameterDefinition("height", Float.class);
        this.setParameterDefinition("x", Float.class);
        this.setParameterDefinition("y", Float.class);
    }

    @Override
    public Object createObject() {
        Rectangle2D.Float rect = new Rectangle2D.Float();
        float w = this.getFloatParameter("width");
        float h = this.getFloatParameter("height");
        float x = this.getFloatParameter("x");
        float y = this.getFloatParameter("y");
        ((Rectangle2D)rect).setRect(x, y, w, h);
        return rect;
    }

    private float getFloatParameter(String param) {
        Float p = (Float)this.getParameter(param);
        if (p == null) {
            return 0.0f;
        }
        return p.floatValue();
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!(o instanceof Rectangle2D)) {
            throw new ObjectFactoryException("The given object is no java.awt.geom.Rectangle2D.");
        }
        Rectangle2D rect = (Rectangle2D)o;
        float x = (float)rect.getX();
        float y = (float)rect.getY();
        float w = (float)rect.getWidth();
        float h = (float)rect.getHeight();
        this.setParameter("x", new Float(x));
        this.setParameter("y", new Float(y));
        this.setParameter("width", new Float(w));
        this.setParameter("height", new Float(h));
    }
}

