/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.Obscurificate48PasswordEncryptionServiceProvider;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PasswordEncryptionServiceProvider;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;

public class PasswordEncryptionService {
    private static final Log logger = LogFactory.getLog(PasswordEncryptionService.class);
    private static PasswordEncryptionService instance;
    private PasswordEncryptionServiceProvider provider;
    private HashMap<String, PasswordEncryptionServiceProvider> services = new HashMap();

    private PasswordEncryptionService() {
        this.provider = (PasswordEncryptionServiceProvider)ClassicEngineBoot.getInstance().getObjectFactory().get(PasswordEncryptionServiceProvider.class);
        this.registerService(this.provider);
        logger.debug((Object)("Selected " + this.provider.getClass() + " as default provider."));
    }

    public static synchronized PasswordEncryptionService getInstance() {
        if (instance == null) {
            instance = new PasswordEncryptionService();
        }
        return instance;
    }

    public void registerService(PasswordEncryptionServiceProvider provider) {
        if (provider == null) {
            throw new NullPointerException();
        }
        this.services.put(provider.getPrefix(), provider);
    }

    public PasswordEncryptionServiceProvider getProvider() {
        return this.provider;
    }

    public String encrypt(String rawPassword) {
        if (rawPassword == null) {
            return null;
        }
        return this.provider.getPrefix() + ":" + this.provider.encrypt(rawPassword);
    }

    public String decrypt(RootXmlReadHandler root, String encryptedPassword) {
        boolean legacyFix;
        if (StringUtils.isEmpty((String)encryptedPassword)) {
            return encryptedPassword;
        }
        Object helperObject = root.getHelperObject("prpt-spec-version");
        if (helperObject instanceof Integer) {
            Integer version = (Integer)helperObject;
            if (version == -1) {
                logger.warn((Object)"Decrypting password skipped, as we are dealing with an older version. ");
                return encryptedPassword;
            }
            legacyFix = version < ClassicEngineBoot.computeVersionId(5, 0, 0);
        } else {
            legacyFix = false;
        }
        int separatorPos = encryptedPassword.indexOf(58);
        if (separatorPos == -1) {
            logger.warn((Object)"Decrypting password skipped, as the password-text has no service indicator. ");
            return encryptedPassword;
        }
        String serviceName = encryptedPassword.substring(0, separatorPos);
        String payload = encryptedPassword.substring(separatorPos + 1);
        PasswordEncryptionServiceProvider provider = this.services.get(serviceName);
        if (legacyFix && "encrypted".equals(serviceName)) {
            return new Obscurificate48PasswordEncryptionServiceProvider().decrypt(payload);
        }
        if (provider != null) {
            return provider.decrypt(payload);
        }
        logger.debug((Object)"Decrypting password skipped, as the service indicator is not recognized. ");
        return encryptedPassword;
    }
}

