/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.DisplayAllFlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.FlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.PhysicalPageKey;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelTableContentProducer;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class PageableExcelOutputProcessor
extends AbstractTableOutputProcessor
implements PageableOutputProcessor {
    private List<PhysicalPageKey> physicalPages;
    private OutputProcessorMetaData metaData;
    private ExcelPrinter printer;
    private FlowSelector flowSelector;

    public PageableExcelOutputProcessor(Configuration configuration, OutputStream outputStream, ResourceManager resourceManager) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.physicalPages = new ArrayList<PhysicalPageKey>();
        this.metaData = new ExcelOutputProcessorMetaData(2);
        this.flowSelector = new DisplayAllFlowSelector();
        this.printer = new ExcelPrinter(outputStream, resourceManager);
    }

    public boolean isUseXlsxFormat() {
        return this.printer.isUseXlsxFormat();
    }

    public void setUseXlsxFormat(boolean useXlsxFormat) {
        this.printer.setUseXlsxFormat(useXlsxFormat);
    }

    public InputStream getTemplateInputStream() {
        return this.printer.getTemplateInputStream();
    }

    public void setTemplateInputStream(InputStream templateInputStream) {
        this.printer.setTemplateInputStream(templateInputStream);
    }

    @Override
    protected void processingPagesFinished() {
        super.processingPagesFinished();
        this.physicalPages = Collections.unmodifiableList(this.physicalPages);
    }

    @Override
    public int getPhysicalPageCount() {
        return this.physicalPages.size();
    }

    @Override
    public PhysicalPageKey getPhysicalPage(int page) {
        if (!this.isPaginationFinished()) {
            throw new IllegalStateException();
        }
        return this.physicalPages.get(page);
    }

    @Override
    protected LogicalPageKey createLogicalPage(int width, int height) {
        LogicalPageKey key = super.createLogicalPage(width, height);
        for (int h = 0; h < key.getHeight(); ++h) {
            for (int w = 0; w < key.getWidth(); ++w) {
                this.physicalPages.add(key.getPage(w, h));
            }
        }
        return key;
    }

    @Override
    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public FlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    public void setFlowSelector(FlowSelector flowSelector) {
        this.flowSelector = flowSelector;
    }

    @Override
    protected void processTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer) throws ContentProcessingException {
        if (!this.printer.isInitialized()) {
            this.printer.init(this.metaData);
        }
        this.printer.print(logicalPageKey, logicalPage, contentProducer, false);
    }

    @Override
    protected void processingContentFinished() {
        if (!this.isContentGeneratable()) {
            return;
        }
        if (!this.printer.isInitialized()) {
            this.printer.init(this.metaData);
        }
        this.metaData.commit();
        this.printer.close();
    }

    @Override
    protected TableContentProducer createTableContentProducer(SheetLayout layout) {
        return new ExcelTableContentProducer(layout, this.getMetaData());
    }
}

