/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver;

import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.FontMapper;
import org.pentaho.reporting.libraries.fonts.FontMappingUtility;

public class DefaultFontMapper
implements FontMapper {
    private HashMap fontMapping = new HashMap();
    private byte defaultFont = 0;

    public void addFontMapping(String fontName, byte printerCode) {
        if (fontName == null) {
            throw new NullPointerException();
        }
        this.fontMapping.put(fontName, new Byte(printerCode));
    }

    public void removeFontMapping(String fontName) {
        this.fontMapping.remove(fontName);
    }

    @Override
    public byte getPrinterFont(String fontName) {
        Byte b = (Byte)this.fontMapping.get(fontName);
        if (b != null) {
            return b;
        }
        return this.handleDefault(fontName);
    }

    protected byte handleDefault(String fd) {
        if (FontMappingUtility.isCourier((String)fd)) {
            return 2;
        }
        if (FontMappingUtility.isSerif((String)fd)) {
            return 0;
        }
        if (FontMappingUtility.isSansSerif((String)fd)) {
            return 5;
        }
        return this.defaultFont;
    }

    @Override
    public byte getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(byte defaultFont) {
        this.defaultFont = defaultFont;
    }
}

