/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast;

import org.pentaho.reporting.engine.classic.core.DetailsFooter;
import org.pentaho.reporting.engine.classic.core.DetailsHeader;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.NoDataBand;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.FastExportTemplate;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.process.SubReportProcessType;

public class FastExportOutputFunction
extends AbstractFunction
implements OutputFunction {
    private FastExportTemplate template;

    public FastExportOutputFunction(FastExportTemplate template) {
        this.template = template;
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        if (!event.getState().isSubReportEvent()) {
            boolean prepareRun = event.getState().isPrepareRun();
            this.template.initialize(event.getReport(), this.getRuntime(), prepareRun);
        }
    }

    @Override
    public void reportStarted(ReportEvent event) {
        this.template.write(event.getReport().getPageHeader(), this.getRuntime());
        this.template.write(event.getReport().getReportHeader(), this.getRuntime());
    }

    @Override
    public void reportFinished(ReportEvent event) {
        this.template.write(event.getReport().getReportFooter(), this.getRuntime());
        this.template.write(event.getReport().getPageFooter(), this.getRuntime());
    }

    @Override
    public void reportDone(ReportEvent event) {
        try {
            if (!event.getState().isSubReportEvent()) {
                this.template.finishReport();
            }
        }
        catch (ReportProcessingException pre) {
            throw new InvalidReportStateException(pre.getMessage(), pre);
        }
    }

    @Override
    public void groupStarted(ReportEvent event) {
        int gidx = event.getState().getCurrentGroupIndex();
        RelationalGroup group = (RelationalGroup)event.getReport().getGroup(gidx);
        this.template.write(group.getHeader(), this.getRuntime());
    }

    @Override
    public void groupFinished(ReportEvent event) {
        int gidx = event.getState().getCurrentGroupIndex();
        RelationalGroup group = (RelationalGroup)event.getReport().getGroup(gidx);
        this.template.write(group.getFooter(), this.getRuntime());
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        ItemBand itemBand = event.getReport().getItemBand();
        if (itemBand != null) {
            this.template.write(itemBand, this.getRuntime());
        }
    }

    @Override
    public void itemsStarted(ReportEvent event) {
        NoDataBand noDataBand;
        int numberOfRows = event.getState().getNumberOfRows();
        DetailsHeader detailsHeader = event.getReport().getDetailsHeader();
        if (detailsHeader != null) {
            this.template.write(detailsHeader, this.getRuntime());
        }
        if (numberOfRows == 0 && (noDataBand = event.getReport().getNoDataBand()) != null) {
            this.template.write(noDataBand, this.getRuntime());
        }
    }

    @Override
    public void itemsFinished(ReportEvent event) {
        DetailsFooter detailsFooter = event.getReport().getDetailsFooter();
        if (detailsFooter != null) {
            this.template.write(detailsFooter, this.getRuntime());
        }
    }

    @Override
    public OutputFunction deriveForStorage() {
        return this.clone();
    }

    @Override
    public OutputFunction deriveForPagebreak() {
        return this.clone();
    }

    @Override
    public FastExportOutputFunction clone() {
        try {
            return (FastExportOutputFunction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public InlineSubreportMarker[] getInlineSubreports() {
        return new InlineSubreportMarker[0];
    }

    @Override
    public void clearInlineSubreports(SubReportProcessType processType) {
    }

    @Override
    public void restart(ReportState state) throws ReportProcessingException {
    }

    @Override
    public boolean createRollbackInformation() {
        return false;
    }

    @Override
    public void groupBodyFinished(ReportEvent event) {
    }

    @Override
    public Object getValue() {
        return null;
    }
}

