/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.commonswing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingCommonModule;
import org.pentaho.reporting.libraries.base.util.MemoryStringWriter;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class ExceptionDialog
extends JDialog {
    private static final Log logger = LogFactory.getLog(ExceptionDialog.class);
    private JTextArea backtraceArea;
    private JLabel messageLabel;
    private Exception currentEx;
    private DetailsAction detailsAction;
    private JScrollPane scroller;
    private JPanel filler;
    private Messages messages;

    public ExceptionDialog() {
        this.init();
    }

    public ExceptionDialog(Frame parent) {
        super(parent);
        this.init();
    }

    public ExceptionDialog(Dialog parent) {
        super(parent);
        this.init();
    }

    private void init() {
        this.messages = new Messages(this.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.messages.messages", ObjectUtilities.getClassLoader(SwingCommonModule.class));
        this.setModal(true);
        this.detailsAction = new DetailsAction();
        this.messageLabel = new JLabel();
        this.backtraceArea = new JTextArea();
        this.scroller = new JScrollPane(this.backtraceArea);
        this.scroller.setVisible(false);
        JPanel detailPane = new JPanel();
        detailPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JLabel icon = new JLabel(UIManager.getDefaults().getIcon("OptionPane.errorIcon"));
        icon.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        detailPane.add((Component)icon, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        detailPane.add(this.messageLabel);
        gbc = new GridBagConstraints();
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        detailPane.add((Component)this.createButtonPane(), gbc);
        this.filler = new JPanel();
        this.filler.setPreferredSize(new Dimension(0, 0));
        this.filler.setBackground(Color.green);
        gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 5.0;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        detailPane.add((Component)this.filler, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 16;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 5.0;
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        detailPane.add((Component)this.scroller, gbc);
        this.setContentPane(detailPane);
    }

    public void adjustSize() {
        Dimension scSize = this.scroller.getPreferredSize();
        Dimension cbase = this.filler.getPreferredSize();
        cbase.width = Math.max(scSize.width, cbase.width);
        cbase.height = 0;
        this.filler.setMinimumSize(cbase);
        this.pack();
    }

    protected void setScrollerVisible(boolean b) {
        this.scroller.setVisible(b);
    }

    protected boolean isScrollerVisible() {
        return this.scroller.isVisible();
    }

    private JPanel createButtonPane() {
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2, 5, 5));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonPane.add(new JButton(new OKAction()));
        buttonPane.add(new JButton(this.detailsAction));
        return buttonPane;
    }

    public void setMessage(String mesg) {
        this.messageLabel.setText(mesg);
    }

    public String getMessage() {
        return this.messageLabel.getText();
    }

    public void setException(Exception e) {
        this.currentEx = e;
        if (e == null) {
            this.detailsAction.setEnabled(false);
            this.backtraceArea.setText("");
        } else {
            this.backtraceArea.setText(this.readFromException(e));
        }
    }

    private String readFromException(Exception e) {
        String text = this.messages.getString("ExceptionDialog.USER_NO_BACKTRACE");
        try {
            MemoryStringWriter writer = new MemoryStringWriter();
            PrintWriter pwriter = new PrintWriter((Writer)writer);
            e.printStackTrace(pwriter);
            text = writer.toString();
            pwriter.close();
        }
        catch (Exception ex) {
            logger.info((Object)this.messages.getString("ExceptionDialog.INFO_EXCEPTION_SUPRESSED"));
        }
        return text;
    }

    public Exception getException() {
        return this.currentEx;
    }

    public static void showExceptionDialog(Component parent, String title, String message, Exception e) {
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        ExceptionDialog defaultDialog = window instanceof Frame ? new ExceptionDialog((Frame)window) : (window instanceof Dialog ? new ExceptionDialog((Dialog)window) : new ExceptionDialog());
        if (e != null) {
            Messages messages = new Messages(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.messages.messages", ObjectUtilities.getClassLoader(SwingCommonModule.class));
            logger.error((Object)messages.getErrorString("ExceptionDialog.ERROR_0001_USER_ERROR", new String[0]), (Throwable)e);
        }
        defaultDialog.setTitle(title);
        defaultDialog.setMessage(message);
        defaultDialog.setException(e);
        defaultDialog.adjustSize();
        defaultDialog.setModal(true);
        LibSwingUtil.centerDialogInParent((Dialog)defaultDialog);
        defaultDialog.setVisible(true);
    }

    private final class DetailsAction
    extends AbstractAction {
        private DetailsAction() {
            this.putValue("Name", ">>");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ExceptionDialog.this.setScrollerVisible(!ExceptionDialog.this.isScrollerVisible());
            if (ExceptionDialog.this.isScrollerVisible()) {
                this.putValue("Name", "<<");
            } else {
                this.putValue("Name", ">>");
            }
            ExceptionDialog.this.adjustSize();
        }
    }

    private final class OKAction
    extends AbstractAction {
        private OKAction() {
            this.putValue("Name", UIManager.getDefaults().getString("OptionPane.okButtonText"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ExceptionDialog.this.setVisible(false);
        }
    }
}

