/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.builder;

import java.util.LinkedHashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.builder.MetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;

public class ElementMetaDataBuilder
extends MetaDataBuilder<ElementMetaDataBuilder> {
    private ElementMetaData.TypeClassification reportElementType;
    private AttributeMap<AttributeMetaData> attributes;
    private LinkedHashMap<StyleKey, StyleMetaData> styles = new LinkedHashMap();
    private Class<? extends ElementType> elementType;
    private Class<?> contentType = Object.class;
    private String namespace;

    public ElementMetaDataBuilder() {
        this.attributes = new AttributeMap();
        this.reportElementType = ElementMetaData.TypeClassification.DATA;
    }

    @Override
    protected ElementMetaDataBuilder self() {
        return this;
    }

    public ElementMetaDataBuilder namespace(String namespace) {
        this.namespace = namespace;
        return this.self();
    }

    public ElementMetaDataBuilder typeClassification(ElementMetaData.TypeClassification t) {
        this.reportElementType = t;
        return this;
    }

    public ElementMetaDataBuilder contentType(Class<?> contentType) {
        this.contentType = contentType;
        return this;
    }

    public ElementMetaDataBuilder elementType(Class<? extends ElementType> t) {
        this.elementType = t;
        return this;
    }

    public ElementMetaDataBuilder attributes(AttributeMap<AttributeMetaData> attrs) {
        this.attributes.putAll(attrs);
        return this;
    }

    public ElementMetaDataBuilder attribute(AttributeMetaData attrs) {
        this.attributes.setAttribute(attrs.getNameSpace(), attrs.getName(), (Object)attrs);
        return this;
    }

    public ElementMetaDataBuilder styles(Map<StyleKey, StyleMetaData> styles) {
        this.styles.putAll(styles);
        return this;
    }

    public ElementMetaDataBuilder style(StyleMetaData styles) {
        this.styles.put(styles.getStyleKey(), styles);
        return this;
    }

    public Map<StyleKey, StyleMetaData> stylesRef() {
        return this.styles;
    }

    public ElementMetaData.TypeClassification getReportElementType() {
        return this.reportElementType;
    }

    public AttributeMap<AttributeMetaData> getAttributes() {
        return this.attributes.clone();
    }

    public AttributeMap<AttributeMetaData> attributesRef() {
        return this.attributes;
    }

    public Map<StyleKey, StyleMetaData> getStyles() {
        return (Map)this.styles.clone();
    }

    public Class<? extends ElementType> getElementType() {
        return this.elementType;
    }

    public Class<?> getContentType() {
        return this.contentType;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

