/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.libraries.base.config.Configuration;

public abstract class StackedObjectPool<T> {
    private static final boolean paranoidModelChecks;
    private ArrayList<T> backend = new ArrayList();
    private int fillSize;
    private int useSize;

    public static boolean isParanoidModelChecks() {
        return paranoidModelChecks;
    }

    protected StackedObjectPool() {
    }

    protected abstract T create();

    protected T get() {
        if (this.useSize < this.fillSize) {
            T retval = this.backend.get(this.useSize);
            ++this.useSize;
            return retval;
        }
        T retval = this.create();
        this.backend.add(retval);
        ++this.fillSize;
        ++this.useSize;
        return retval;
    }

    public void free(T t) {
        if (StackedObjectPool.isParanoidModelChecks()) {
            if (this.useSize == 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.backend.get(this.useSize - 1) != t) {
                throw new IllegalArgumentException();
            }
        }
        --this.useSize;
    }

    static {
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        paranoidModelChecks = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.layout.ParanoidChecks"));
    }
}

