/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.process.util.OrphanBlockContext;
import org.pentaho.reporting.engine.classic.core.layout.process.util.OrphanCanvasContext;
import org.pentaho.reporting.engine.classic.core.layout.process.util.OrphanContext;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StackedObjectPool;

public class OrphanContextPool {
    private CanvasContextPool canvasContextPool = new CanvasContextPool();
    private BlockContextPool blockContextPool = new BlockContextPool();

    public OrphanContext create(RenderBox box, OrphanContext context) {
        if ((box.getLayoutNodeType() & 0x12) == 18) {
            StaticBoxLayoutProperties properties = box.getStaticBoxLayoutProperties();
            int orphans = properties.getOrphans();
            OrphanBlockContext retval = (OrphanBlockContext)this.blockContextPool.get();
            retval.init(this.blockContextPool, context, box, orphans);
            return retval;
        }
        OrphanCanvasContext retval = (OrphanCanvasContext)this.canvasContextPool.get();
        retval.init(this.canvasContextPool, context);
        return retval;
    }

    public void free(OrphanContext context) {
        context.clearForPooledReuse();
    }

    private static class CanvasContextPool
    extends StackedObjectPool<OrphanCanvasContext> {
        private CanvasContextPool() {
        }

        @Override
        protected OrphanCanvasContext create() {
            return new OrphanCanvasContext();
        }
    }

    private static class BlockContextPool
    extends StackedObjectPool<OrphanBlockContext> {
        private BlockContextPool() {
        }

        @Override
        protected OrphanBlockContext create() {
            return new OrphanBlockContext();
        }
    }
}

