/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.process.ComputeStaticPropertiesProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisNodeContext;
import org.pentaho.reporting.engine.classic.core.layout.process.util.ProcessUtility;

public class MinorAxisLayoutStepUtil {
    public static final RenderLength FULL_WIDTH_LENGTH = RenderLength.createFromRaw(-100.0);

    private MinorAxisLayoutStepUtil() {
    }

    public static long resolveNodeWidthOnStart(RenderBox box, MinorAxisNodeContext nodeContext, long x) {
        long width = MinorAxisLayoutStepUtil.resolveNodeWidthOnStartInternal(box, nodeContext);
        return MinorAxisLayoutStepUtil.correctForRoundingErrors(nodeContext, x, width);
    }

    private static long correctForRoundingErrors(MinorAxisNodeContext nodeContext, long x, long width) {
        long parentX2 = nodeContext.getParentX2();
        if (parentX2 == 0L) {
            return width;
        }
        long currentX2 = width + x;
        long delta = Math.abs(parentX2 - currentX2);
        if (delta != 0L && delta < 10L) {
            return parentX2 - x;
        }
        return width;
    }

    private static long resolveNodeWidthOnStartInternal(RenderBox box, MinorAxisNodeContext nodeContext) {
        long minChunkWidth = 0L;
        BoxDefinition boxDef = box.getBoxDefinition();
        RenderLength minLength = boxDef.getMinimumWidth();
        RenderLength prefLength = boxDef.getPreferredWidth();
        RenderLength maxLength = boxDef.getMaximumWidth();
        long bcw = nodeContext.getBlockContextWidth();
        long min = minLength.resolve(bcw, 0L);
        long max = maxLength.resolve(bcw, ComputeStaticPropertiesProcessStep.MAX_AUTO);
        if (box.getBoxDefinition().isSizeSpecifiesBorderBox()) {
            long parentSize = nodeContext.getResolvedPreferredSize();
            long pref = prefLength.resolve(bcw, Math.max(parentSize, 0L));
            return ProcessUtility.computeLength(min, max, pref);
        }
        long parentSize = nodeContext.getResolvedPreferredSize() - box.getInsets();
        long pref = prefLength.resolve(bcw, Math.max(parentSize, 0L));
        return ProcessUtility.computeLength(min, max, pref) + box.getInsets();
    }

    public static long resolveNodeWidthOnStartForCanvasLegacy(RenderBox box, MinorAxisNodeContext nodeContext, long x) {
        long width = MinorAxisLayoutStepUtil.resolveNodeWidthOnStartForCanvasLegacyInternal(box, nodeContext);
        return MinorAxisLayoutStepUtil.correctForRoundingErrors(nodeContext, x, width);
    }

    private static long resolveNodeWidthOnStartForCanvasLegacyInternal(RenderBox box, MinorAxisNodeContext nodeContext) {
        long minChunkWidth = 0L;
        BoxDefinition boxDef = box.getBoxDefinition();
        RenderLength definedMinLength = boxDef.getMinimumWidth();
        RenderLength minLength = definedMinLength.getValue() == 0L ? FULL_WIDTH_LENGTH : definedMinLength;
        RenderLength prefLength = boxDef.getPreferredWidth();
        RenderLength maxLength = boxDef.getMaximumWidth();
        long bcw = nodeContext.getBlockContextWidth();
        long min = minLength.resolve(bcw, 0L);
        long max = maxLength.resolve(bcw, ComputeStaticPropertiesProcessStep.MAX_AUTO);
        if (box.getBoxDefinition().isSizeSpecifiesBorderBox()) {
            long parentSize = nodeContext.getResolvedPreferredSize();
            long pref = prefLength.resolve(bcw, Math.max(parentSize, 0L));
            return ProcessUtility.computeLength(min, max, pref);
        }
        long parentSize = nodeContext.getResolvedPreferredSize() - box.getInsets();
        long pref = prefLength.resolve(bcw, Math.max(parentSize, 0L));
        return ProcessUtility.computeLength(min, max, pref) + box.getInsets();
    }

    public static long resolveNodeWidthOnFinish(RenderBox box, MinorAxisNodeContext nodeContext, boolean strictLegacyMode) {
        long width = MinorAxisLayoutStepUtil.resolveNodeWidthOnFinishInternal(box, nodeContext, strictLegacyMode);
        return MinorAxisLayoutStepUtil.correctForRoundingErrors(nodeContext, nodeContext.getX(), width);
    }

    private static long resolveNodeWidthOnFinishInternal(RenderBox box, MinorAxisNodeContext nodeContext, boolean strictLegacyMode) {
        RenderLength minLength;
        long minChunkWidth;
        BoxDefinition boxDef = box.getBoxDefinition();
        if (!RenderLength.AUTO.equals(boxDef.getPreferredWidth())) {
            return nodeContext.getWidth();
        }
        if (!strictLegacyMode || box.useMinimumChunkWidth()) {
            minChunkWidth = nodeContext.getMaxChildX2() - nodeContext.getX1();
            minLength = boxDef.getMinimumWidth();
        } else {
            minChunkWidth = nodeContext.getX2() - nodeContext.getX1();
            minLength = boxDef.getMinimumWidth().getValue() == 0L ? FULL_WIDTH_LENGTH : boxDef.getMinimumWidth();
        }
        RenderLength maxLength = boxDef.getMaximumWidth();
        long bcw = nodeContext.getBlockContextWidth();
        long min = minLength.resolve(bcw, 0L);
        long max = maxLength.resolve(bcw, ComputeStaticPropertiesProcessStep.MAX_AUTO);
        if (box.getBoxDefinition().isSizeSpecifiesBorderBox()) {
            long parentSize = nodeContext.getResolvedPreferredSize();
            long pref = Math.max(parentSize, minChunkWidth + box.getInsets());
            return ProcessUtility.computeLength(min, max, pref);
        }
        long parentSize = nodeContext.getResolvedPreferredSize() - box.getInsets();
        long pref = Math.max(parentSize, minChunkWidth);
        return ProcessUtility.computeLength(min, max, pref) + box.getInsets();
    }

    public static long resolveNodeWidthForMinChunkCalculation(RenderBox box) {
        BoxDefinition boxDef = box.getBoxDefinition();
        RenderLength minLength = boxDef.getMinimumWidth();
        RenderLength prefLength = boxDef.getPreferredWidth();
        RenderLength maxLength = boxDef.getMaximumWidth();
        long min = minLength.resolve(0L, 0L);
        long max = maxLength.resolve(0L, ComputeStaticPropertiesProcessStep.MAX_AUTO);
        if (box.getBoxDefinition().isSizeSpecifiesBorderBox()) {
            long pref = prefLength.resolve(0L, box.getInsets());
            return ProcessUtility.computeLength(min, max, pref);
        }
        long pref = prefLength.resolve(0L, 0L);
        return ProcessUtility.computeLength(min, max, pref) + box.getInsets();
    }
}

