/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ValidationResult;
import org.pentaho.reporting.engine.classic.core.layout.model.context.NodeLayoutProperties;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.VerticalTextAlign;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.libraries.base.config.Configuration;

public abstract class RenderNode
implements Cloneable {
    private static final boolean paranoidModelChecks;
    public static final int HORIZONTAL_AXIS = 0;
    public static final int VERTICAL_AXIS = 1;
    public static final CacheState CACHE_CLEAN;
    public static final CacheState CACHE_DIRTY;
    public static final CacheState CACHE_DEEP_DIRTY;
    private static final int FLAG_FROZEN = 1;
    private static final int FLAG_FINISHED_PAGINATE = 2;
    private static final int FLAG_FINISHED_TABLE = 4;
    private static final int FLAG_VIRTUAL_NODE = 4;
    private static final int FLAG_WIDOW_BOX = 8;
    private static final int FLAG_RESERVED = 65520;
    private int flags;
    private CacheState cacheState;
    private CacheState applyState;
    private RenderBox parentNode;
    private RenderNode nextNode;
    private RenderNode prevNode;
    private NodeLayoutProperties nodeLayoutProperties;
    private long changeTracker;
    private long minimumChunkWidth;
    private long maximumBoxWidth;
    private long validateModelAge;
    private ValidationResult validateModelResult;
    private long linebreakAge;
    private long cachedX;
    private long cachedY;
    private long cachedWidth;
    private long cachedHeight;
    private long x;
    private long y;
    private long width;
    private long height;
    private long cachedAge;

    public static boolean isParanoidModelChecks() {
        return paranoidModelChecks;
    }

    protected RenderNode(int majorAxis, int minorAxis, StyleSheet styleSheet, InstanceID instanceID, ElementType elementType, ReportAttributeMap<Object> attributes) {
        this(new NodeLayoutProperties(majorAxis, minorAxis, styleSheet, attributes, instanceID, elementType));
    }

    protected RenderNode(NodeLayoutProperties nodeLayoutProperties) {
        if (nodeLayoutProperties == null) {
            throw new NullPointerException();
        }
        this.nodeLayoutProperties = nodeLayoutProperties;
        this.cacheState = CACHE_DIRTY;
    }

    protected void reinit(StyleSheet styleSheet, ElementType elementType, ReportAttributeMap<Object> attributes, InstanceID instanceId) {
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (instanceId == null) {
            throw new NullPointerException();
        }
        if (elementType == null) {
            throw new NullPointerException();
        }
        this.flags = 0;
        this.changeTracker = -1L;
        this.validateModelAge = 0L;
        this.cachedX = 0L;
        this.cachedY = 0L;
        this.cachedWidth = 0L;
        this.cachedHeight = 0L;
        this.x = 0L;
        this.y = 0L;
        this.width = 0L;
        this.height = 0L;
        this.minimumChunkWidth = 0L;
        this.maximumBoxWidth = 0L;
        this.cacheState = CACHE_DIRTY;
        this.nodeLayoutProperties = new NodeLayoutProperties(this.nodeLayoutProperties.getMajorAxis(), this.nodeLayoutProperties.getMinorAxis(), styleSheet, attributes, instanceId, elementType);
    }

    public ElementType getElementType() {
        return this.nodeLayoutProperties.getElementType();
    }

    public ReportAttributeMap<Object> getAttributes() {
        return this.nodeLayoutProperties.getAttributes();
    }

    public int getContentRefCount() {
        return 0;
    }

    public int getTableRefCount() {
        return 0;
    }

    public int getDescendantCount() {
        return 1;
    }

    public boolean isSizeSpecifiesBorderBox() {
        return true;
    }

    public abstract int getNodeType();

    public int getLayoutNodeType() {
        return this.getNodeType();
    }

    public int getMinorAxis() {
        return this.nodeLayoutProperties.getMinorAxis();
    }

    public int getMajorAxis() {
        return this.nodeLayoutProperties.getMajorAxis();
    }

    public final NodeLayoutProperties getNodeLayoutProperties() {
        return this.nodeLayoutProperties;
    }

    public final long getX() {
        return this.x;
    }

    public final void setX(long x) {
        this.x = x;
    }

    public final long getY() {
        return this.y;
    }

    public void shift(long amount) {
        this.y += amount;
    }

    public void setY(long y) {
        this.y = y;
    }

    protected final void updateCacheState(CacheState state) {
        switch (state) {
            case CLEAN: {
                break;
            }
            case DIRTY: {
                if (this.cacheState != CACHE_CLEAN) break;
                this.cacheState = CACHE_DIRTY;
                RenderBox parent = this.getParent();
                if (parent == null) break;
                parent.updateCacheState(CACHE_DIRTY);
                break;
            }
            case DEEP_DIRTY: {
                RenderBox parent;
                if (this.cacheState == CACHE_CLEAN && (parent = this.getParent()) != null) {
                    parent.updateCacheState(CACHE_DEEP_DIRTY);
                }
                this.cacheState = CACHE_DEEP_DIRTY;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public final long getWidth() {
        return this.width;
    }

    public final void setWidth(long width) {
        if (width < 0L) {
            throw new IndexOutOfBoundsException("Width cannot be negative");
        }
        this.width = width;
        this.updateCacheState(CACHE_DIRTY);
    }

    public final long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        if (height < 0L) {
            throw new IndexOutOfBoundsException("Height cannot be negative");
        }
        this.height = height;
    }

    public final StyleSheet getStyleSheet() {
        return this.nodeLayoutProperties.getStyleSheet();
    }

    public InstanceID getInstanceId() {
        return this.nodeLayoutProperties.getInstanceId();
    }

    protected void updateChangeTracker() {
        RenderBox parent;
        ++this.changeTracker;
        if (this.cacheState == CACHE_CLEAN) {
            this.cacheState = CACHE_DIRTY;
        }
        if ((parent = this.getParent()) != null) {
            parent.updateChangeTracker();
        }
    }

    public final long getChangeTracker() {
        return this.changeTracker;
    }

    public final RenderBox getParent() {
        return this.parentNode;
    }

    public RenderBox getLayoutParent() {
        if (this.parentNode != null && this.parentNode.getNodeType() == 524290) {
            return this.parentNode.getLayoutParent();
        }
        return this.parentNode;
    }

    protected final void setParent(RenderBox parent) {
        if (RenderNode.isParanoidModelChecks()) {
            RenderNode prev = this.getPrev();
            if (parent != null && prev == parent) {
                throw new IllegalStateException("Assertation failed: Cannot have a parent that is the same as a silbling.");
            }
            if (parent == null) {
                RenderNode next = this.getNext();
                if (next != null) {
                    throw new NullPointerException();
                }
                if (prev != null) {
                    throw new NullPointerException();
                }
            }
        }
        this.parentNode = parent;
    }

    public final RenderNode getPrev() {
        return this.prevNode;
    }

    protected final void setPrevUnchecked(RenderNode prev) {
        this.prevNode = prev;
    }

    protected final void setPrev(RenderNode prev) {
        this.prevNode = prev;
        if (RenderNode.isParanoidModelChecks() && prev != null) {
            RenderBox parent = this.getParent();
            if (prev == parent) {
                throw new IllegalStateException();
            }
            if (parent != null && parent.getFirstChild() == this) {
                throw new NullPointerException("Cannot have a prev node if the parent has me as first child.");
            }
        }
    }

    public final RenderNode getNext() {
        return this.nextNode;
    }

    protected final void setNextUnchecked(RenderNode next) {
        this.nextNode = next;
    }

    protected final void setNext(RenderNode next) {
        this.nextNode = next;
        if (RenderNode.isParanoidModelChecks() && next != null) {
            RenderBox parent = this.getParent();
            if (next == parent) {
                throw new IllegalStateException();
            }
            if (parent != null && parent.getLastChild() == this) {
                throw new NullPointerException("Cannot have a next-node, if the parent has me as last child.");
            }
        }
    }

    public LogicalPageBox getLogicalPage() {
        for (RenderNode parent = this; parent != null; parent = parent.getParent()) {
            if (parent.getNodeType() != 1042) continue;
            return (LogicalPageBox)parent;
        }
        return null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed for some reason.");
        }
    }

    public RenderNode derive(boolean deep) {
        RenderNode node = (RenderNode)this.clone();
        node.parentNode = null;
        node.nextNode = null;
        node.prevNode = null;
        if (deep) {
            node.cachedAge = this.changeTracker;
            node.validateModelAge = -1L;
            node.cacheState = CACHE_DIRTY;
        }
        return node;
    }

    public RenderNode deriveFrozen(boolean deep) {
        RenderNode node = (RenderNode)this.clone();
        node.parentNode = null;
        node.nextNode = null;
        node.prevNode = null;
        node.freeze();
        return node;
    }

    public boolean isFrozen() {
        return this.isFlag(1);
    }

    public RenderNode findNodeById(InstanceID instanceId) {
        if (instanceId == this.getInstanceId()) {
            return this;
        }
        return null;
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isDiscardable() {
        return false;
    }

    public boolean isIgnorableForRendering() {
        return this.isEmpty();
    }

    public void freeze() {
        this.setFlag(1, true);
    }

    public long getMaximumBoxWidth() {
        return this.maximumBoxWidth;
    }

    public void setMaximumBoxWidth(long maximumBoxWidth) {
        this.maximumBoxWidth = maximumBoxWidth;
    }

    public long getMinimumChunkWidth() {
        return this.minimumChunkWidth;
    }

    protected void setMinimumChunkWidth(long minimumChunkWidth) {
        if (minimumChunkWidth < 0L) {
            throw new IllegalArgumentException();
        }
        this.minimumChunkWidth = minimumChunkWidth;
    }

    public long getEffectiveMarginTop() {
        return 0L;
    }

    public long getEffectiveMarginBottom() {
        return 0L;
    }

    public VerticalTextAlign getVerticalTextAlignment() {
        return this.nodeLayoutProperties.getVerticalTextAlign();
    }

    public String getName() {
        return null;
    }

    public boolean isBreakAfter() {
        return false;
    }

    public long getValidateModelAge() {
        return this.validateModelAge;
    }

    protected void resetValidateModelResult() {
        this.validateModelAge = -1L;
    }

    public void setValidateModelResult(ValidationResult result) {
        this.validateModelAge = this.changeTracker;
        this.validateModelResult = result;
    }

    public ValidationResult isValidateModelResult() {
        return this.validateModelResult;
    }

    public long getLinebreakAge() {
        return this.linebreakAge;
    }

    public void setLinebreakAge(long linebreakAge) {
        this.linebreakAge = linebreakAge;
    }

    public final long getCachedX() {
        return this.cachedX;
    }

    public void setCachedX(long cachedX) {
        this.cachedX = cachedX;
    }

    public final long getCachedY() {
        return this.cachedY;
    }

    public final long getCachedY2() {
        return this.cachedY + this.cachedHeight;
    }

    public void setCachedY(long cachedY) {
        this.cachedY = cachedY;
    }

    public void shiftCached(long amount) {
        this.cachedY += amount;
    }

    public final long getCachedWidth() {
        return this.cachedWidth;
    }

    public final long getCachedX2() {
        return this.cachedX + this.cachedWidth;
    }

    public void setCachedWidth(long cachedWidth) {
        if (cachedWidth < 0L) {
            throw new IndexOutOfBoundsException("'cached width' cannot be negative.");
        }
        this.cachedWidth = cachedWidth;
    }

    public final long getCachedHeight() {
        return this.cachedHeight;
    }

    public void setCachedHeight(long cachedHeight) {
        if (cachedHeight < 0L) {
            throw new IndexOutOfBoundsException("'cached height' cannot be negative, was " + cachedHeight);
        }
        this.cachedHeight = cachedHeight;
    }

    public void apply() {
        this.x = this.cachedX;
        this.y = this.cachedY;
        this.width = this.cachedWidth;
        this.height = this.cachedHeight;
        this.cachedAge = this.changeTracker;
        this.cacheState = CacheState.CLEAN;
        this.applyState = CacheState.CLEAN;
        RenderBox parent = this.getParent();
        if (parent != null) {
            parent.addOverflowArea(this.x + this.getOverflowAreaWidth() - parent.getX(), this.y + this.getOverflowAreaHeight() - parent.getY());
        }
    }

    public final boolean isLinebreakCacheValid() {
        return this.linebreakAge == this.changeTracker;
    }

    public final boolean isValidateModelCacheValid() {
        if (this.validateModelAge != this.changeTracker) {
            return false;
        }
        return this.validateModelResult != ValidationResult.UNKNOWN;
    }

    public boolean isFinishedPaginate() {
        return this.isFlag(2);
    }

    public void setFinishedPaginate(boolean finished) {
        if (this.isFinishedPaginate() && !finished) {
            throw new IllegalStateException("Cannot undo a finished-marker");
        }
        this.setFlag(2, finished);
    }

    public boolean isFinishedTable() {
        return this.isFlag(4);
    }

    public void setFinishedTable(boolean finished) {
        if (this.isFinishedTable() && !finished) {
            throw new IllegalStateException("Cannot undo a finished-marker");
        }
        this.setFlag(4, finished);
    }

    public boolean isDeepFinishedTable() {
        return this.isFinishedTable();
    }

    public CacheState getCacheState() {
        return this.cacheState;
    }

    public ReportStateKey getStateKey() {
        return null;
    }

    public boolean isBoxOverflowX() {
        return false;
    }

    public boolean isBoxOverflowY() {
        return false;
    }

    public final boolean isNodeVisible(StrictBounds drawArea, boolean overflowX, boolean overflowY) {
        long drawAreaX0 = drawArea.getX();
        long drawAreaY0 = drawArea.getY();
        return this.isNodeVisible(drawAreaX0, drawAreaY0, drawArea.getWidth(), drawArea.getHeight(), overflowX, overflowY);
    }

    public final boolean isNodeVisible(StrictBounds drawArea) {
        long drawAreaX0 = drawArea.getX();
        long drawAreaY0 = drawArea.getY();
        return this.isNodeVisible(drawAreaX0, drawAreaY0, drawArea.getWidth(), drawArea.getHeight());
    }

    public final boolean isNodeVisible(long drawAreaX0, long drawAreaY0, long drawAreaWidth, long drawAreaHeight) {
        return this.isNodeVisible(drawAreaX0, drawAreaY0, drawAreaWidth, drawAreaHeight, this.isBoxOverflowX(), this.isBoxOverflowY());
    }

    public final boolean isNodeVisible(long drawAreaX0, long drawAreaY0, long drawAreaWidth, long drawAreaHeight, boolean overflowX, boolean overflowY) {
        if (!this.getStyleSheet().getBooleanStyleProperty(ElementStyleKeys.VISIBLE)) {
            return false;
        }
        long drawAreaX1 = drawAreaX0 + drawAreaWidth;
        long drawAreaY1 = drawAreaY0 + drawAreaHeight;
        long x2 = this.x + this.width;
        long y2 = this.y + this.height;
        if (this.width == 0L) {
            if (x2 < drawAreaX0) {
                return false;
            }
            if (this.x > drawAreaX1) {
                return false;
            }
        } else if (!overflowX) {
            if (x2 <= drawAreaX0) {
                return false;
            }
            if (this.x >= drawAreaX1) {
                return false;
            }
        }
        if (this.height == 0L) {
            if (y2 < drawAreaY0) {
                return false;
            }
            if (this.y > drawAreaY1) {
                return false;
            }
        } else if (!overflowY) {
            if (y2 <= drawAreaY0) {
                return false;
            }
            if (this.y >= drawAreaY1) {
                return false;
            }
        }
        return true;
    }

    public boolean isVirtualNode() {
        return this.isFlag(4);
    }

    public void setVirtualNode(boolean virtualNode) {
        this.setFlag(4, virtualNode);
    }

    protected void setFlag(int flag, boolean value) {
        this.flags = value ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    protected boolean isFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public final boolean isBoxVisible(StrictBounds drawArea) {
        return this.isBoxVisible(drawArea.getX(), drawArea.getY(), drawArea.getWidth(), drawArea.getHeight());
    }

    public final boolean isBoxVisible(long x, long y, long width, long height) {
        int layoutNodeType;
        if (!this.isNodeVisible(x, y, width, height)) {
            return false;
        }
        RenderBox parent = this.getParent();
        if (parent == null) {
            return true;
        }
        StyleSheet styleSheet = this.getStyleSheet();
        if (styleSheet.getStyleProperty(ElementStyleKeys.ANCHOR_NAME) != null) {
            return true;
        }
        if (parent.getNodeType() != 524290 && !parent.getStaticBoxLayoutProperties().isOverflowX()) {
            long parentX1 = parent.getX();
            long parentX2 = parentX1 + parent.getWidth();
            if (this.getWidth() == 0L) {
                return true;
            }
            long boxX1 = this.getX();
            long boxX2 = boxX1 + this.getWidth();
            if (boxX2 <= parentX1) {
                return false;
            }
            if (boxX1 >= parentX2) {
                return false;
            }
        }
        if ((layoutNodeType = this.getLayoutNodeType()) == 294914 || layoutNodeType == 278530) {
            return true;
        }
        if (parent.getNodeType() != 524290 && !parent.getStaticBoxLayoutProperties().isOverflowY()) {
            long parentY1 = parent.getY();
            long parentY2 = parentY1 + parent.getHeight();
            if (this.getHeight() == 0L) {
                return true;
            }
            long boxY1 = this.getY();
            long boxY2 = boxY1 + this.getHeight();
            if (boxY2 <= parentY1) {
                return false;
            }
            if (boxY1 >= parentY2) {
                return false;
            }
        }
        return true;
    }

    public long getOverflowAreaHeight() {
        return this.getHeight();
    }

    public long getOverflowAreaWidth() {
        return this.getWidth();
    }

    public long getEffectiveMinimumChunkSize() {
        return this.minimumChunkWidth;
    }

    public int getChildCount() {
        return 0;
    }

    public boolean isWidowBox() {
        return this.isFlag(8);
    }

    public void setWidowBox(boolean widowBox) {
        this.setFlag(8, widowBox);
    }

    public boolean isOrphanLeaf() {
        return false;
    }

    public RenderBox.RestrictFinishClearOut getRestrictFinishedClearOut() {
        return RenderBox.RestrictFinishClearOut.UNRESTRICTED;
    }

    public long getCachedAge() {
        return this.cachedAge;
    }

    public boolean isCacheValid() {
        if (this.cachedAge != this.changeTracker) {
            return false;
        }
        return this.cacheState == CACHE_CLEAN;
    }

    protected final void setCachedAge(long cachedAge) {
        this.cachedAge = cachedAge;
    }

    public final long getY2() {
        return this.y + this.height;
    }

    public boolean isVisible() {
        return this.nodeLayoutProperties.isVisible();
    }

    public boolean isContainsReservedContent() {
        return false;
    }

    public void markApplyStateDirty() {
        if (this.applyState != CacheState.CLEAN) {
            return;
        }
        this.applyState = CACHE_DIRTY;
        RenderBox parent = this.getParent();
        if (parent != null) {
            parent.markApplyStateDirty();
        }
    }

    public CacheState getApplyState() {
        return this.applyState;
    }

    public int getRowIndex() {
        return 0;
    }

    public boolean isRenderBox() {
        return false;
    }

    public int getWidowLeafCount() {
        return 0;
    }

    public int getOrphanLeafCount() {
        return 0;
    }

    static {
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        paranoidModelChecks = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.layout.ParanoidChecks"));
        CACHE_CLEAN = CacheState.CLEAN;
        CACHE_DIRTY = CacheState.DIRTY;
        CACHE_DEEP_DIRTY = CacheState.DEEP_DIRTY;
    }

    public static enum CacheState {
        CLEAN,
        DIRTY,
        DEEP_DIRTY;

    }
}

