/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;

public class PageFunction
extends AbstractFunction
implements PageEventListener {
    private transient int page;
    private String group;
    private int startPage = 1;
    private int pageIncrement = 1;
    private int dependencyLevel = -2;
    private boolean ignoreNextPageStart;
    private boolean ignoreNextGroupStart;

    public PageFunction() {
    }

    public PageFunction(String name) {
        this();
        this.setName(name);
    }

    @Override
    public boolean isDeepTraversing() {
        return true;
    }

    @Override
    public int getDependencyLevel() {
        return this.dependencyLevel;
    }

    @Override
    public void setDependencyLevel(int dependencyLevel) {
        if (dependencyLevel < -2) {
            throw new IllegalArgumentException("PageFunction.setDependencyLevel(...) : A dependency level lower than paginate is not allowed.");
        }
        this.dependencyLevel = dependencyLevel;
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    public void setPageIncrement(int pageIncrement) {
        this.pageIncrement = pageIncrement;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getPage() {
        return this.page;
    }

    protected void setPage(int page) {
        this.page = page;
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        if (event.isDeepTraversing()) {
            return;
        }
        this.setPage(this.getStartPage());
        this.ignoreNextGroupStart = true;
        this.ignoreNextPageStart = false;
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (event.isDeepTraversing()) {
            return;
        }
        if (this.getGroup() == null) {
            return;
        }
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            if (this.ignoreNextGroupStart) {
                this.ignoreNextGroupStart = false;
                return;
            }
            this.ignoreNextPageStart = true;
            this.setPage(this.getStartPage());
        }
    }

    @Override
    public void pageStarted(ReportEvent event) {
        if ((event.getType() & 1) == 1 && !event.isDeepTraversing()) {
            this.setPage(this.getStartPage());
            return;
        }
        if (this.ignoreNextPageStart) {
            this.ignoreNextPageStart = false;
            return;
        }
        this.setPage(this.getPage() + this.getPageIncrement());
    }

    protected boolean isIgnoreNextPageStart() {
        return this.ignoreNextPageStart;
    }

    @Override
    public void pageFinished(ReportEvent event) {
    }

    @Override
    public Object getValue() {
        return IntegerCache.getInteger(this.getPage());
    }

    protected boolean isIgnoreNextGroupStart() {
        return this.ignoreNextGroupStart;
    }

    protected boolean isIgnorePageCancelEvents() {
        return true;
    }

    public void setIgnorePageCancelEvents(boolean ignorePageCancelEvents) {
    }
}

