/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.math.BigDecimal;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionUtilities;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.util.Sequence;

public class ItemSumFunction
extends AbstractFunction
implements FieldAggregationFunction {
    protected static final BigDecimal ZERO = new BigDecimal(0.0);
    private Sequence<BigDecimal> sum = new Sequence();
    private transient int lastGroupSequenceNumber;
    private String group;
    private String field;
    private String crosstabFilterGroup;

    public ItemSumFunction() {
    }

    public ItemSumFunction(String name) {
        this();
        this.setName(name);
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        this.clear();
    }

    protected void clear() {
        this.lastGroupSequenceNumber = 0;
        this.sum.clear();
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            this.clear();
        }
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String name) {
        this.group = name;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public void setField(String field) {
        this.field = field;
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        Object fieldValue = this.getDataRow().get(this.getField());
        if (fieldValue == null) {
            return;
        }
        if (!(fieldValue instanceof Number)) {
            return;
        }
        Number numerValue = (Number)fieldValue;
        BigDecimal number = ExpressionUtilities.convertToBigDecimal(numerValue);
        BigDecimal oldValue = this.sum.get(this.lastGroupSequenceNumber);
        if (oldValue == null) {
            this.sum.set(this.lastGroupSequenceNumber, number);
        } else {
            this.sum.set(this.lastGroupSequenceNumber, oldValue.add(number));
        }
    }

    @Override
    public Object getValue() {
        BigDecimal value = this.sum.get(this.lastGroupSequenceNumber);
        if (value == null) {
            return ZERO;
        }
        return value;
    }

    @Override
    public void summaryRowSelection(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public Expression getInstance() {
        ItemSumFunction function = (ItemSumFunction)super.getInstance();
        function.sum = this.sum.clone();
        function.lastGroupSequenceNumber = 0;
        return function;
    }

    @Override
    public Object clone() {
        try {
            ItemSumFunction clone = (ItemSumFunction)super.clone();
            clone.sum = this.sum.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public String getCrosstabFilterGroup() {
        return this.crosstabFilterGroup;
    }

    @Override
    public void setCrosstabFilterGroup(String crosstabFilterGroup) {
        this.crosstabFilterGroup = crosstabFilterGroup;
    }
}

