/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.text.DateFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.DateFormatFilter;
import org.pentaho.reporting.engine.classic.core.filter.FormatSpecification;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class SimpleDateFormatFilter
extends DateFormatFilter {
    private Locale lastLocale;
    private boolean keepState;

    public SimpleDateFormatFilter() {
        this.setFormatter(new SimpleDateFormat());
    }

    public SimpleDateFormat getSimpleDateFormat() {
        return (SimpleDateFormat)this.getFormatter();
    }

    public void setSimpleDateFormat(SimpleDateFormat format) {
        super.setFormatter(format);
    }

    @Override
    public void setFormatter(Format format) {
        SimpleDateFormat sdfmt = (SimpleDateFormat)format;
        super.setFormatter(sdfmt);
    }

    public String getFormatString() {
        return this.getSimpleDateFormat().toPattern();
    }

    public void setFormatString(String format) {
        if (format == null) {
            throw new NullPointerException();
        }
        this.getSimpleDateFormat().applyPattern(format);
        this.invalidateCache();
    }

    public String getLocalizedFormatString() {
        return this.getSimpleDateFormat().toLocalizedPattern();
    }

    public void setLocalizedFormatString(String format) {
        this.getSimpleDateFormat().applyLocalizedPattern(format);
        this.invalidateCache();
    }

    public boolean isKeepState() {
        return this.keepState;
    }

    public void setKeepState(boolean keepState) {
        this.keepState = keepState;
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        Locale locale;
        if (!this.keepState && runtime != null && (locale = runtime.getResourceBundleFactory().getLocale()) != null && !locale.equals(this.lastLocale)) {
            this.lastLocale = locale;
            this.getSimpleDateFormat().setDateFormatSymbols(new DateFormatSymbols(locale));
            this.invalidateCache();
        }
        return super.getValue(runtime, element);
    }

    @Override
    public FormatSpecification getFormatString(ExpressionRuntime runtime, ReportElement element, FormatSpecification formatSpecification) {
        if (formatSpecification == null) {
            formatSpecification = new FormatSpecification();
        }
        formatSpecification.redefine(1, this.getFormatString());
        return formatSpecification;
    }
}

