/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.event;

import java.util.EventObject;
import org.pentaho.reporting.engine.classic.core.states.ReportState;

public class ReportProgressEvent
extends EventObject
implements Cloneable {
    public static final int COMPUTING_LAYOUT = 0;
    public static final int PRECOMPUTING_VALUES = 1;
    public static final int PAGINATING = 2;
    public static final int GENERATING_CONTENT = 3;
    private static final int DEFAULT_VALUE = -1;
    private int level;
    private int maximumLevel;
    private int activity;
    private int row;
    private int maximumRow;
    private int page;
    private int totalPages;

    public ReportProgressEvent(Object source) {
        super(source);
        this.maximumLevel = -1;
        this.level = -1;
        this.maximumRow = -1;
        this.page = -1;
        this.totalPages = -1;
        this.activity = 0;
        this.row = -1;
    }

    @Deprecated
    public ReportProgressEvent(Object source, int page) {
        super(source);
        this.maximumLevel = -1;
        this.level = -1;
        this.maximumRow = -1;
        this.page = page;
        this.totalPages = -1;
        this.activity = 0;
        this.row = -1;
    }

    public ReportProgressEvent(Object source, int page, int totalPages) {
        this(source, page);
        this.totalPages = totalPages;
    }

    @Deprecated
    public ReportProgressEvent(Object source, int activity, int row, int maximumRow, int page, int level, int maximumLevel) {
        super(source);
        this.maximumLevel = maximumLevel;
        this.level = level;
        this.maximumRow = maximumRow;
        this.page = page;
        this.totalPages = -1;
        this.activity = activity;
        this.row = row;
    }

    public ReportProgressEvent(Object source, int activity, int row, int maximumRow, int page, int totalPages, int level, int maximumLevel) {
        this(source, activity, row, maximumRow, page, level, maximumLevel);
        this.totalPages = totalPages;
    }

    @Override
    public String toString() {
        return "ReportProgressEvent[activity=" + this.activity + ", row=" + this.row + ", maximumRow=" + this.maximumRow + ", page=" + this.page + ", totalPages=" + this.totalPages + ", level=" + this.level + ", maximumLevel=" + this.maximumLevel + ']';
    }

    public int getRow() {
        return this.row;
    }

    public int getActivity() {
        return this.activity;
    }

    public int getPage() {
        return this.page;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getMaximumRow() {
        return this.maximumRow;
    }

    public int getMaximumLevel() {
        return this.maximumLevel;
    }

    public int getLevel() {
        return this.level;
    }

    public void reuse(int activity, ReportState rawState, int pageCount) {
        this.reuse(activity, rawState, pageCount, this.totalPages);
    }

    public void reuse(int activity, ReportState rawState, int pageCount, int totalPages) {
        ReportState state = rawState;
        while (state.getParentState() != null) {
            state = state.getParentState();
        }
        this.reuse(activity, state.getCurrentRow(), state.getNumberOfRows(), pageCount, totalPages, state.getProgressLevel(), state.getProgressLevelCount());
    }

    public void reuse(int activity, int row, int maximumRow, int page, int level, int maximumLevel) {
        this.maximumRow = maximumRow;
        this.page = page;
        this.activity = activity;
        this.row = row;
        this.maximumLevel = maximumLevel;
        this.level = level;
    }

    public void reuse(int activity, int row, int maximumRow, int page, int totalPages, int level, int maximumLevel) {
        this.reuse(activity, row, maximumRow, page, level, maximumLevel);
        this.totalPages = totalPages;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Cloning not successful.");
        }
    }

    public static double computePercentageComplete(ReportProgressEvent event, boolean onlyPagination) {
        int dataLevels;
        double levelSizePercentage;
        double levelPercentage;
        if (event.getLevel() == Integer.MAX_VALUE) {
            levelPercentage = 0.0;
            levelSizePercentage = 0.1;
        } else if (onlyPagination) {
            dataLevels = Math.max(0, event.getMaximumLevel());
            int layoutWeight = 5;
            if (event.getLevel() == event.getMaximumLevel() - 1) {
                levelPercentage = 0.1 + 0.9 * (double)(dataLevels / (dataLevels + 5));
                levelSizePercentage = 1.0 - levelPercentage;
            } else {
                levelPercentage = 0.1 + 0.9 * (double)(event.getLevel() / (dataLevels + 5));
                levelSizePercentage = 0.1 + 0.9 * (1.0 / (double)(dataLevels + 5));
            }
        } else {
            dataLevels = Math.max(0, event.getMaximumLevel());
            int layoutWeight = 5;
            if (event.getLevel() == event.getMaximumLevel() - 1) {
                if (event.getActivity() == 3) {
                    levelPercentage = 0.1 + 0.9 * (double)(event.getLevel() / dataLevels + 10);
                    levelSizePercentage = 0.1 + 0.9 * (double)((dataLevels + 5) / (dataLevels + 10));
                } else {
                    levelPercentage = 0.1 + 0.9 * (double)(event.getLevel() / (dataLevels + 10));
                    levelSizePercentage = 0.1 + 0.9 * (double)(dataLevels / (dataLevels + 10));
                }
            } else {
                levelPercentage = 0.1 + 0.9 * (double)(event.getLevel() / (dataLevels + 10));
                levelSizePercentage = 0.1 + 0.9 * (1.0 / (double)(dataLevels + 10));
            }
        }
        double subPercentage = levelSizePercentage * ((double)event.getRow() / (double)event.getMaximumRow());
        double percentage = 100.0 * (levelPercentage + subPercentage);
        return Math.max(0.0, Math.min(100.0, percentage));
    }
}

