/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.dom;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.dom.AndMatcher;
import org.pentaho.reporting.engine.classic.core.dom.AnyNodeMatcher;
import org.pentaho.reporting.engine.classic.core.dom.AttributeMatcher;
import org.pentaho.reporting.engine.classic.core.dom.ChildMatcher;
import org.pentaho.reporting.engine.classic.core.dom.DescendantMatcher;
import org.pentaho.reporting.engine.classic.core.dom.ElementMatcher;
import org.pentaho.reporting.engine.classic.core.dom.MatcherContext;
import org.pentaho.reporting.engine.classic.core.dom.NodeMatcher;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;

public class ReportStructureMatcher {
    private static ElementMatcher createMatcher(StreamTokenizer tokenizer) {
        if (tokenizer.ttype == 42) {
            return new AnyNodeMatcher();
        }
        return new ElementMatcher(tokenizer.sval);
    }

    public static NodeMatcher parse(String s) throws IOException {
        int token;
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(s));
        tokenizer.wordChars(48, 57);
        tokenizer.ordinaryChar(46);
        tokenizer.ordinaryChar(44);
        tokenizer.ordinaryChars(0, 32);
        ElementMatcher elementMatcher = null;
        NodeMatcher n = null;
        Type selectorType = Type.Start;
        while ((token = tokenizer.nextToken()) != -1) {
            if (token == -3 || token == 42) {
                ElementMatcher matcher = null;
                switch (selectorType) {
                    case Start: {
                        matcher = elementMatcher = ReportStructureMatcher.createMatcher(tokenizer);
                        break;
                    }
                    case Child: {
                        n = new ChildMatcher(n);
                        matcher = elementMatcher = ReportStructureMatcher.createMatcher(tokenizer);
                        break;
                    }
                    case Descendant: {
                        n = new DescendantMatcher(n);
                        matcher = elementMatcher = ReportStructureMatcher.createMatcher(tokenizer);
                        break;
                    }
                    case Id: {
                        if (elementMatcher == null) {
                            if (n != null) {
                                n = new DescendantMatcher(n);
                            }
                            matcher = elementMatcher = ReportStructureMatcher.createMatcher(tokenizer);
                        }
                        elementMatcher.add(new AttributeMatcher("http://www.w3.org/XML/1998/namespace", "id", tokenizer.sval));
                        break;
                    }
                    case Class: {
                        if (elementMatcher == null) {
                            if (n != null) {
                                n = new DescendantMatcher(n);
                            }
                            matcher = elementMatcher = ReportStructureMatcher.createMatcher(tokenizer);
                        }
                        elementMatcher.add(new AttributeMatcher("http://reporting.pentaho.org/namespaces/engine/attributes/core", "style-class", tokenizer.sval));
                        break;
                    }
                    default: {
                        throw new IOException();
                    }
                }
                selectorType = Type.Element;
                if (matcher == null) continue;
                if (n != null) {
                    n = new AndMatcher(matcher, n);
                    continue;
                }
                n = matcher;
                continue;
            }
            if (token == 62) {
                selectorType = Type.Child;
            }
            if (token == 46) {
                selectorType = Type.Class;
            }
            if (token == 35) {
                selectorType = Type.Id;
            }
            if (!Character.isWhitespace(token)) continue;
            if (selectorType == Type.Class || selectorType == Type.Id) {
                throw new IllegalStateException();
            }
            if (selectorType == Type.Child) continue;
            selectorType = Type.Descendant;
        }
        return n;
    }

    public static ReportElement match(MatcherContext context, ReportElement base, NodeMatcher parse) {
        if (parse == null) {
            throw new NullPointerException();
        }
        context.setSingleSelectionHint(true);
        return new NodeIterator().get(context, base, parse);
    }

    public static ReportElement[] matchAll(MatcherContext context, ReportElement base, NodeMatcher parse) {
        if (parse == null) {
            throw new NullPointerException();
        }
        context.setSingleSelectionHint(false);
        return new NodeIterator().getAll(context, base, parse);
    }

    public static ReportElement match(MatcherContext context, ReportElement base, String selector) throws IOException {
        NodeMatcher parse = ReportStructureMatcher.parse(selector);
        return ReportStructureMatcher.match(context, base, parse);
    }

    public static ReportElement[] matchAll(MatcherContext context, ReportElement base, String selector) throws IOException {
        NodeMatcher parse = ReportStructureMatcher.parse(selector);
        return ReportStructureMatcher.matchAll(context, base, parse);
    }

    public static ReportElement[] findElementsByName(ReportElement section, String name) {
        return ReportStructureMatcher.findElementsByAttribute(section, "http://reporting.pentaho.org/namespaces/engine/attributes/core", "name", name);
    }

    public static ReportElement[] findElementsByAttribute(ReportElement section, String ns, String name) {
        return ReportStructureMatcher.findElementsByAttribute(section, ns, name, null);
    }

    public static ReportElement[] findElementsByAttribute(ReportElement section, String ns, String name, Object value) {
        MatcherContext context = new MatcherContext();
        context.setMatchSubReportChilds(false);
        return ReportStructureMatcher.matchAll(context, section, new AttributeMatcher(ns, name, value));
    }

    public static ReportElement[] findElementsByType(ReportElement section, ElementType type) {
        MatcherContext context = new MatcherContext();
        context.setMatchSubReportChilds(false);
        String name = type.getMetaData().getName();
        return ReportStructureMatcher.matchAll(context, section, new ElementMatcher(name));
    }

    public static ReportElement findElementByType(Element element, ElementType type) {
        MatcherContext context = new MatcherContext();
        context.setMatchSubReportChilds(false);
        String name = type.getMetaData().getName();
        return ReportStructureMatcher.match(context, (ReportElement)element, new ElementMatcher(name));
    }

    public static enum Type {
        Start,
        Descendant,
        Child,
        Id,
        Class,
        Element;

    }

    private static class NodeIterator {
        private boolean singleResult;
        private ArrayList<ReportElement> nodes = new ArrayList();
        private NodeMatcher matcher;
        private MatcherContext context;

        private NodeIterator() {
        }

        public ReportElement get(MatcherContext context, ReportElement node, NodeMatcher matcher) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (matcher == null) {
                throw new NullPointerException();
            }
            this.context = context;
            this.matcher = matcher;
            this.nodes.clear();
            this.singleResult = true;
            this.startProcessing(node, true);
            if (this.nodes.isEmpty()) {
                return null;
            }
            return this.nodes.get(0);
        }

        private void startProcessing(ReportElement node, boolean first) {
            if (node instanceof Section) {
                Section s = (Section)node;
                if (first || this.startBox(node)) {
                    int elementCount = s.getElementCount();
                    for (int i = 0; i < elementCount; ++i) {
                        this.startProcessing(s.getElement(i), false);
                    }
                }
            } else {
                this.processOtherNode(node);
            }
        }

        public ReportElement[] getAll(MatcherContext context, ReportElement node, NodeMatcher matcher) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (matcher == null) {
                throw new NullPointerException();
            }
            this.context = context;
            this.matcher = matcher;
            this.nodes.clear();
            this.singleResult = false;
            this.startProcessing(node, true);
            return this.nodes.toArray(new ReportElement[this.nodes.size()]);
        }

        protected boolean startBox(ReportElement box) {
            if (this.singleResult && !this.nodes.isEmpty()) {
                return false;
            }
            if (!this.context.isMatchSubReportChilds() && box.getMetaData().getReportElementType() == ElementMetaData.TypeClassification.SUBREPORT) {
                return false;
            }
            if (this.matcher.matches(this.context, box)) {
                this.nodes.add(box);
                if (this.singleResult) {
                    return false;
                }
            }
            return true;
        }

        protected void processOtherNode(ReportElement node) {
            if (this.singleResult && !this.nodes.isEmpty()) {
                return;
            }
            if (this.matcher.matches(this.context, node)) {
                this.nodes.add(node);
            }
        }
    }
}

