/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.devtools;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.GroupedMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;

public class StyleMetadataGenerator {
    private static String readMetadataAttribute(MetaData metaData, String name, String defaultValue) {
        String metaAttribute = metaData.getMetaAttribute(name, Locale.ENGLISH);
        if (metaAttribute == null) {
            return defaultValue;
        }
        return metaAttribute;
    }

    private static void printMetadata(MetaData metaData, String prefix, String name, String defaultValue) {
        System.out.println(prefix + name + "=" + StyleMetadataGenerator.readMetadataAttribute(metaData, name, defaultValue));
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        HashMap<String, StyleMetaData> allStyles = new HashMap<String, StyleMetaData>();
        ElementMetaData[] allTypes = ElementTypeRegistry.getInstance().getAllElementTypes();
        Arrays.sort(allTypes, GroupedMetaDataComparator.ENGLISH);
        for (int i = 0; i < allTypes.length; ++i) {
            ElementMetaData type = allTypes[i];
            StyleMetaData[] styles = type.getStyleDescriptions();
            for (int j = 0; j < styles.length; ++j) {
                StyleMetaData style = styles[j];
                allStyles.put(style.getName(), style);
            }
        }
        StyleMetaData[] objects = allStyles.values().toArray(new StyleMetaData[allStyles.size()]);
        Arrays.sort(objects, GroupedMetaDataComparator.ENGLISH);
        for (int i = 0; i < objects.length; ++i) {
            StyleMetaData style = objects[i];
            String stylePrefix = "style." + style.getName() + ".";
            StyleMetadataGenerator.printMetadata(style, stylePrefix, "display-name", style.getName());
            StyleMetadataGenerator.printMetadata(style, stylePrefix, "grouping", "");
            StyleMetadataGenerator.printMetadata(style, stylePrefix, "grouping.ordinal", "0");
            StyleMetadataGenerator.printMetadata(style, stylePrefix, "ordinal", "0");
            StyleMetadataGenerator.printMetadata(style, stylePrefix, "description", "");
            StyleMetadataGenerator.printMetadata(style, stylePrefix, "deprecated", "");
            System.out.println();
        }
    }

    private static class AttributeCarrier
    implements Comparable {
        public AttributeMetaData metaData;
        public String prefix;

        private AttributeCarrier(String prefix, AttributeMetaData metaData) {
            this.prefix = prefix;
            this.metaData = metaData;
        }

        public int compareTo(Object o) {
            AttributeCarrier carrier = (AttributeCarrier)o;
            int compare = GroupedMetaDataComparator.ENGLISH.compare(this.metaData, carrier.metaData);
            if (compare == 0) {
                return this.prefix.compareTo(carrier.prefix);
            }
            return compare;
        }
    }
}

