/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.ui.IThemeManager;
import org.pentaho.platform.api.ui.ModuleThemeInfo;
import org.pentaho.platform.api.ui.Theme;
import org.pentaho.platform.api.ui.ThemeResource;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.UIServlet;

public class ThemeServlet
extends ServletBase {
    private static final long serialVersionUID = -7408362317719420602L;
    private static final Log logger = LogFactory.getLog(UIServlet.class);
    private IThemeManager themeManager = (IThemeManager)PentahoSystem.get(IThemeManager.class, null);

    @Override
    public Log getLogger() {
        return logger;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            JSONObject themeObject;
            String moduleName = req.getParameter("context");
            ServletOutputStream out = resp.getOutputStream();
            resp.setContentType("text/javascript");
            resp.setHeader("Cache-Control", "no-cache");
            IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getPentahoSession(req));
            String activeTheme = (String)this.getPentahoSession(req).getAttribute("pentaho-user-theme");
            String ua = req.getHeader("User-Agent");
            if (!StringUtils.isEmpty((String)ua) && ua.matches(".*(?i)(iPad|iPod|iPhone|Android).*")) {
                activeTheme = PentahoSystem.getSystemSetting((String)"default-theme", (String)"ruby");
            }
            if (activeTheme == null) {
                try {
                    activeTheme = settingsService.getUserSetting("pentaho-user-theme", null).getSettingValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (activeTheme == null) {
                    activeTheme = PentahoSystem.getSystemSetting((String)"default-theme", (String)"ruby");
                }
            }
            out.write(("\n\n// Theming scripts. This file is generated by (" + ((Object)((Object)this)).getClass().getName() + ") and cannot be found on disk\n").getBytes());
            out.write(("var active_theme = \"" + activeTheme + "\";\n\n").getBytes());
            JSONObject root = new JSONObject();
            for (String systemThemeName : this.themeManager.getSystemThemeIds()) {
                Theme theme = this.themeManager.getSystemTheme(systemThemeName);
                themeObject = new JSONObject();
                root.put(theme.getId(), (Object)themeObject);
                themeObject.put("rootDir", (Object)theme.getThemeRootDir());
                for (ThemeResource res : theme.getResources()) {
                    themeObject.append("resources", (Object)res.getLocation());
                }
            }
            out.write(("var core_theme_tree = " + root.toString() + ";\n\n").getBytes());
            out.write("// Inject the theme script to handle the insertion of requested theme resources\n\n".getBytes());
            ModuleThemeInfo moduleThemeinfo = this.themeManager.getModuleThemeInfo(moduleName);
            if (moduleThemeinfo != null) {
                root = new JSONObject();
                for (Theme theme : moduleThemeinfo.getModuleThemes()) {
                    themeObject = new JSONObject();
                    root.put(theme.getName(), (Object)themeObject);
                    themeObject.put("rootDir", (Object)theme.getThemeRootDir());
                    for (ThemeResource res : theme.getResources()) {
                        themeObject.append("resources", (Object)res.getLocation());
                    }
                }
                out.write(("var module_theme_tree = " + root.toString() + ";\n\n").getBytes());
            }
            out.write("(function() {\nvar script = document.createElement('script');\nscript.type = 'text/javascript';\nscript.src = CONTEXT_PATH + 'js/themeResources.js';\nvar existing = document.getElementsByTagName('script')[0];\nexisting.parentNode.insertBefore(script, existing);\n}());".getBytes());
        }
        catch (IOException e) {
            logger.debug((Object)"IO exception creating Theme info", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (JSONException e) {
            logger.debug((Object)"JSON exception creating Theme info", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }
}

