/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.web.WebUtil;

public abstract class ServletBase
extends HttpServlet
implements ILogger {
    public static final boolean debug = true;
    private int loggingLevel = 5;

    protected IPentahoSession getPentahoSession(HttpServletRequest request) {
        return PentahoSessionHolder.getSession();
    }

    public abstract Log getLogger();

    public String getObjectName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public int getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(int logLevel) {
        this.loggingLevel = logLevel;
    }

    public void trace(String message) {
        if (this.loggingLevel <= 1) {
            this.getLogger().trace((Object)message);
        }
    }

    public void debug(String message) {
        if (this.loggingLevel <= 2) {
            this.getLogger().debug((Object)message);
        }
    }

    public void info(String message) {
        if (this.loggingLevel <= 3) {
            this.getLogger().info((Object)message);
        }
    }

    public void warn(String message) {
        if (this.loggingLevel <= 4) {
            this.getLogger().warn((Object)message);
        }
    }

    public void error(String message) {
        if (this.loggingLevel <= 5) {
            this.getLogger().error((Object)message);
        }
    }

    public void fatal(String message) {
        if (this.loggingLevel <= 6) {
            this.getLogger().fatal((Object)message);
        }
    }

    public void trace(String message, Throwable error) {
        if (this.loggingLevel <= 1) {
            this.getLogger().trace((Object)message, error);
            Logger.addException((Throwable)error);
        }
    }

    public void debug(String message, Throwable error) {
        if (this.loggingLevel <= 2) {
            this.getLogger().debug((Object)message, error);
            Logger.addException((Throwable)error);
        }
    }

    public void info(String message, Throwable error) {
        if (this.loggingLevel <= 3) {
            this.getLogger().info((Object)message, error);
            Logger.addException((Throwable)error);
        }
    }

    public void warn(String message, Throwable error) {
        if (this.loggingLevel <= 4) {
            this.getLogger().warn((Object)message, error);
            Logger.addException((Throwable)error);
        }
    }

    public void error(String message, Throwable error) {
        if (this.loggingLevel <= 5) {
            this.getLogger().error((Object)message, error);
            Logger.addException((Throwable)error);
        }
    }

    public void fatal(String message, Throwable error) {
        if (this.loggingLevel <= 6) {
            this.getLogger().fatal((Object)message, error);
            Logger.addException((Throwable)error);
        }
    }

    public void setCorsHeaders(HttpServletRequest request, HttpServletResponse response) {
        WebUtil.setCorsResponseHeaders(request, response);
    }
}

