/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;

public class LocalizationServlet
extends ServletBase {
    private static final Log logger = LogFactory.getLog(LocalizationServlet.class);
    private static final String DEFAULT_CACHE_MESSAGES_SETTING = "false";

    @Override
    public Log getLogger() {
        return logger;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pluginId = req.getParameter("plugin");
        String name = req.getParameter("name");
        try {
            String json = this.getJSONBundle(pluginId, name);
            this.setCorsHeaders(req, resp);
            resp.setContentType("text/plain");
            resp.setStatus(200);
            resp.setCharacterEncoding(LocaleHelper.getSystemEncoding());
            try (PrintWriter writer = resp.getWriter();){
                writer.write(json);
            }
        }
        catch (Exception ex) {
            this.error(Messages.getInstance().getErrorString("LocalizationServlet.ERROR_0000_ERROR"), ex);
            resp.sendError(500);
        }
    }

    protected ResourceBundle getBundle(String pluginId, String name) {
        IPluginManager pm = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        ClassLoader pluginClassLoader = pm.getClassLoader(pluginId);
        if (pluginClassLoader == null) {
            throw new IllegalArgumentException(Messages.getInstance().getErrorString("LocalizationServlet.ERROR_0001_INVALID_PLUGIN_ID", new Object[]{pluginId}));
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(Messages.getInstance().getErrorString("LocalizationServlet.ERROR_0002_INVALID_RESOURCE_NAME", new Object[]{name}));
        }
        ResourceBundle bundle = ResourceBundle.getBundle(name, LocaleHelper.getLocale(), pluginClassLoader);
        if (!this.isMessageCachingEnabled(pm, pluginId)) {
            ResourceBundle.clearCache();
        }
        return bundle;
    }

    public boolean isMessageCachingEnabled(IPluginManager pm, String pluginId) {
        Object cache = pm.getPluginSetting(pluginId, "cache-messages", DEFAULT_CACHE_MESSAGES_SETTING);
        return !DEFAULT_CACHE_MESSAGES_SETTING.equals(cache);
    }

    public String getJSONBundle(String pluginId, String name) {
        try {
            return this.getJsonForBundle(this.getBundle(pluginId, name));
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    protected String getJsonForBundle(ResourceBundle bundle) throws JSONException {
        JSONObject cat = new JSONObject();
        for (String key : bundle.keySet()) {
            cat.put(key, (Object)bundle.getString(key));
        }
        return cat.toString();
    }
}

