/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.security;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.SessionCookieConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class PentahoBasicProcessingFilter
extends BasicAuthenticationFilter
implements ApplicationEventPublisherAware {
    @VisibleForTesting
    static final String SESSION_FLUSHED_COOKIE_NAME = "session-flushed";
    @VisibleForTesting
    static final String SESSION_ID_COOKIE_NAME = "JSESSIONID";
    private ApplicationEventPublisher applicationEventPublisher;

    public PentahoBasicProcessingFilter(AuthenticationManager authenticationManager, AuthenticationEntryPoint authenticationEntryPoint) {
        super(authenticationManager, authenticationEntryPoint);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getRequestedSessionId() != null && !request.isRequestedSessionIdValid()) {
            if (this.isBasicAuthRequest(request)) {
                PentahoBasicProcessingFilter.clearSessionFlushedCookie(request, response);
                this.getAuthenticationEntryPoint().commence(request, response, (AuthenticationException)new BadCredentialsException("Clearing Basic-Auth"));
                return;
            }
            boolean hasExpiredSessionCookie = Arrays.stream(request.getCookies()).anyMatch(cookie -> SESSION_ID_COOKIE_NAME.equals(cookie.getName()));
            if (hasExpiredSessionCookie) {
                response.addCookie(this.createSessionFlushedCookie(request));
            }
        } else if (this.isBasicAuthRequest(request) && SecurityContextHolder.getContext().getAuthentication() == null && PentahoBasicProcessingFilter.clearSessionFlushedCookie(request, response)) {
            this.getAuthenticationEntryPoint().commence(request, response, (AuthenticationException)new BadCredentialsException("Clearing Basic-Auth"));
            return;
        }
        this.doFilterInternalSuper(request, response, chain);
    }

    @VisibleForTesting
    void doFilterInternalSuper(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        super.doFilterInternal(request, response, chain);
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        super.onSuccessfulAuthentication(request, response, authResult);
        request.getSession().setAttribute("BasicAuth", (Object)"true");
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new AuthenticationSuccessEvent(authResult));
        }
    }

    protected boolean isBasicAuthRequest(@NonNull HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        return header != null && header.indexOf("Basic") == 0;
    }

    @NonNull
    protected Cookie createSessionFlushedCookie(@NonNull HttpServletRequest request) {
        Cookie cookie = new Cookie(SESSION_FLUSHED_COOKIE_NAME, "true");
        PentahoBasicProcessingFilter.configureSessionFlushedCookie(cookie, request, -1);
        return cookie;
    }

    protected static void configureSessionFlushedCookie(@NonNull Cookie cookie, @NonNull HttpServletRequest request, int maxAge) {
        SessionCookieConfig sessionCookieConfig = request.getServletContext().getSessionCookieConfig();
        cookie.setPath(request.getContextPath() != null ? request.getContextPath() : "/");
        cookie.setHttpOnly(sessionCookieConfig.isHttpOnly());
        cookie.setSecure(sessionCookieConfig.isSecure());
        cookie.setMaxAge(maxAge);
    }

    static boolean clearSessionFlushedCookie(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!SESSION_FLUSHED_COOKIE_NAME.equals(cookie.getName())) continue;
                PentahoBasicProcessingFilter.configureSessionFlushedCookie(cookie, request, 0);
                response.addCookie(cookie);
                return true;
            }
        }
        return false;
    }
}

