/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.audit.MDCUtil;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class PentahoMDCFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        IPentahoSession session = PentahoSessionHolder.getSession();
        MDC.put((String)"remoteAddr", (String)request.getRemoteAddr());
        MDC.put((String)"remoteHost", (String)request.getRemoteHost());
        MDC.put((String)"remotePort", (String)String.valueOf(request.getRemotePort()));
        MDC.put((String)"serverName", (String)request.getServerName());
        MDC.put((String)"serverPort", (String)String.valueOf(request.getServerPort()));
        if (request.getLocalAddr() != null) {
            MDC.put((String)"localAddr", (String)request.getLocalAddr());
        }
        MDC.put((String)"localName", (String)request.getLocalName());
        MDC.put((String)"localPort", (String)String.valueOf(request.getLocalPort()));
        if (authentication != null) {
            MDC.put((String)"sessionName", (String)session.getName());
            MDC.put((String)"sessionId", (String)session.getId());
        }
        try {
            filterChain.doFilter(request, response);
        }
        finally {
            MDCUtil.clear();
        }
    }

    public void destroy() {
    }
}

