/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources.services;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.channels.IllegalSelectorException;
import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryAccessDeniedException;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.webservices.LocaleMapDto;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclAceDto;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileTreeDto;
import org.pentaho.platform.api.repository2.unified.webservices.StringKeyStringValueDto;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.exporter.PentahoPlatformExporter;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importexport.BaseExportProcessor;
import org.pentaho.platform.plugin.services.importexport.DefaultExportHandler;
import org.pentaho.platform.plugin.services.importexport.ExportException;
import org.pentaho.platform.plugin.services.importexport.ExportHandler;
import org.pentaho.platform.plugin.services.importexport.IRepositoryImportLogger;
import org.pentaho.platform.plugin.services.importexport.ImportSession;
import org.pentaho.platform.plugin.services.importexport.SimpleExportProcessor;
import org.pentaho.platform.plugin.services.importexport.ZipExportProcessor;
import org.pentaho.platform.repository.RepositoryDownloadWhitelist;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.pentaho.platform.repository2.locale.PentahoLocale;
import org.pentaho.platform.repository2.messages.Messages;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileInputStream;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileOutputStream;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.pentaho.platform.repository2.unified.webservices.DefaultUnifiedRepositoryWebService;
import org.pentaho.platform.repository2.unified.webservices.PropertiesWrapper;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileAdapter;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.api.resources.SessionResource;
import org.pentaho.platform.web.http.api.resources.Setting;
import org.pentaho.platform.web.http.api.resources.StringListWrapper;
import org.pentaho.platform.web.http.api.resources.operations.CopyFilesOperation;
import org.pentaho.platform.web.http.api.resources.utils.FileUtils;
import org.pentaho.platform.web.http.api.resources.utils.RepositoryFileHelper;
import org.pentaho.platform.web.http.api.resources.utils.SystemUtils;
import org.pentaho.platform.web.servlet.HttpMimeTypeListener;

public class FileService {
    public static final Integer MODE_OVERWRITE = 1;
    public static final Integer MODE_RENAME = 2;
    public static final Integer MODE_NO_OVERWRITE = 3;
    private static final Log logger = LogFactory.getLog(FileService.class);
    protected IAuthorizationPolicy policy;
    protected DefaultUnifiedRepositoryWebService defaultUnifiedRepositoryWebService;
    protected IUnifiedRepository repository;
    protected RepositoryDownloadWhitelist whitelist;
    protected SessionResource sessionResource;
    private PentahoPlatformExporter backupExporter;

    public DownloadFileWrapper systemBackup(String userAgent) throws IOException, ExportException {
        if (this.doCanAdminister()) {
            String originalFileName = "SystemBackup.zip";
            String encodedFileName = this.makeEncodedFileName(originalFileName);
            StreamingOutput streamingOutput = this.getBackupStream();
            String attachment = HttpMimeTypeListener.buildContentDispositionValue(originalFileName, true);
            return new DownloadFileWrapper(streamingOutput, attachment, encodedFileName);
        }
        throw new SecurityException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemRestore(InputStream fileUpload, String overwriteFile, String applyAclSettings, String overwriteAclSettings) throws PlatformImportException, SecurityException {
        if (this.doCanAdminister()) {
            boolean overwriteFileFlag = !"false".equals(overwriteFile);
            boolean applyAclSettingsFlag = !"false".equals(applyAclSettings);
            boolean overwriteAclSettingsFlag = "true".equals(overwriteAclSettings);
            IRepositoryImportLogger importLogger = null;
            Level level = Level.ERROR;
            ByteArrayOutputStream importLoggerStream = new ByteArrayOutputStream();
            String importDirectory = "/";
            RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder();
            bundleBuilder.input(fileUpload);
            bundleBuilder.charSet("UTF-8");
            bundleBuilder.hidden(false);
            bundleBuilder.schedulable(true);
            bundleBuilder.path(importDirectory);
            bundleBuilder.overwriteFile(overwriteFileFlag);
            bundleBuilder.name("SystemBackup.zip");
            bundleBuilder.applyAclSettings(applyAclSettingsFlag);
            bundleBuilder.overwriteAclSettings(overwriteAclSettingsFlag);
            bundleBuilder.retainOwnership(true);
            bundleBuilder.preserveDsw(true);
            ImportSession.getSession().setAclProperties(applyAclSettingsFlag, true, overwriteAclSettingsFlag);
            IPlatformImporter importer = (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
            importLogger = importer.getRepositoryImportLogger();
            importLogger.startJob(importLoggerStream, importDirectory, level);
            try {
                importer.importFile(bundleBuilder.build());
            }
            finally {
                importLogger.endJob();
            }
        } else {
            throw new SecurityException();
        }
    }

    private StreamingOutput getBackupStream() throws IOException, ExportException {
        File zipFile = this.getBackupExporter().performExport();
        final FileInputStream inputStream = new FileInputStream(zipFile);
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                IOUtils.copy((InputStream)inputStream, (OutputStream)output);
            }
        };
    }

    public void doDeleteFiles(String params) throws Exception {
        String[] sourceFileIds = FileUtils.convertCommaSeparatedStringToArray(params);
        for (int i = 0; i < sourceFileIds.length; ++i) {
            this.getRepoWs().deleteFile(sourceFileIds[i], null);
        }
    }

    public void doDeleteFilesPermanent(String params) throws Exception {
        String[] sourceFileIds = FileUtils.convertCommaSeparatedStringToArray(params);
        try {
            for (int i = 0; i < sourceFileIds.length; ++i) {
                this.getRepoWs().deleteFileWithPermanentFlag(sourceFileIds[i], true, null);
            }
        }
        catch (Exception e) {
            logger.error((Object)org.pentaho.platform.web.http.messages.Messages.getInstance().getString("SystemResource.GENERAL_ERROR"), (Throwable)e);
            throw e;
        }
    }

    public void doDeleteLocale(String pathId, String locale) throws Exception {
        try {
            RepositoryFileDto file = this.getRepoWs().getFile(this.idToPath(pathId));
            if (file != null) {
                this.getRepoWs().deleteLocalePropertiesForFile(file.getId(), locale);
            }
        }
        catch (Exception e) {
            logger.error((Object)org.pentaho.platform.web.http.messages.Messages.getInstance().getString("SystemResource.GENERAL_ERROR"), (Throwable)e);
            throw e;
        }
    }

    public List<Setting> doGetCanAccessList(String pathId, String permissions) {
        StringTokenizer tokenizer = new StringTokenizer(permissions, "|");
        ArrayList<Setting> permMap = new ArrayList<Setting>();
        while (tokenizer.hasMoreTokens()) {
            Integer perm = Integer.valueOf(tokenizer.nextToken());
            EnumSet<RepositoryFilePermission> permission = EnumSet.of(RepositoryFilePermission.values()[perm]);
            permMap.add(new Setting(perm.toString(), new Boolean(this.getRepository().hasAccess(this.idToPath(pathId), permission)).toString()));
        }
        return permMap;
    }

    public List<Setting> doGetPathsAccessList(StringListWrapper pathsWrapper) {
        ArrayList<Setting> pathsPermissonsSettings = new ArrayList<Setting>();
        String permissions = RepositoryFilePermission.READ.ordinal() + "|" + RepositoryFilePermission.WRITE.ordinal() + "|" + RepositoryFilePermission.DELETE.ordinal() + "|" + RepositoryFilePermission.ACL_MANAGEMENT.ordinal() + "|" + RepositoryFilePermission.ALL.ordinal();
        List<String> paths = pathsWrapper.getStrings();
        for (String path : paths) {
            List<Setting> permList = this.doGetCanAccessList(path, permissions);
            for (Setting perm : permList) {
                if (!Boolean.parseBoolean(perm.getValue())) continue;
                Setting setting = new Setting();
                setting.setName(path);
                setting.setValue(perm.getName());
                pathsPermissonsSettings.add(setting);
            }
        }
        return pathsPermissonsSettings;
    }

    public void createFile(String charsetName, String pathId, InputStream fileContents) throws Exception {
        try {
            if (FileUtils.containsControlCharacters(pathId)) {
                throw new InvalidNameException();
            }
            String idToPath = this.idToPath(pathId);
            RepositoryFileOutputStream rfos = this.getRepositoryFileOutputStream(idToPath);
            rfos.setCharsetName(charsetName);
            rfos.setAutoCreateDirStructure(true);
            this.copy(fileContents, (OutputStream)rfos);
            rfos.close();
            fileContents.close();
        }
        catch (Exception e) {
            logger.error((Object)org.pentaho.platform.web.http.messages.Messages.getInstance().getString("SystemResource.GENERAL_ERROR"), (Throwable)e);
            throw e;
        }
    }

    public void doMoveFiles(String destPathId, String params) throws FileNotFoundException {
        String idToPath = this.idToPath(destPathId);
        RepositoryFileDto repositoryFileDto = this.getRepoWs().getFile(idToPath);
        if (repositoryFileDto == null) {
            throw new FileNotFoundException(idToPath);
        }
        String[] sourceFileIds = FileUtils.convertCommaSeparatedStringToArray(params);
        try {
            for (int i = 0; i < sourceFileIds.length; ++i) {
                this.getRepoWs().moveFile(sourceFileIds[i], repositoryFileDto.getPath(), null);
            }
        }
        catch (IllegalArgumentException | UnifiedRepositoryAccessDeniedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }

    public void doRestoreFiles(String params) throws InternalError {
        String[] sourceFileIds = FileUtils.convertCommaSeparatedStringToArray(params);
        try {
            for (int i = 0; i < sourceFileIds.length; ++i) {
                this.getRepoWs().undeleteFile(sourceFileIds[i], null);
            }
        }
        catch (Exception e) {
            if (e instanceof UnifiedRepositoryAccessDeniedException) {
                throw (UnifiedRepositoryAccessDeniedException)((Object)e);
            }
            logger.error((Object)org.pentaho.platform.web.http.messages.Messages.getInstance().getString("SystemResource.FILE_RESTORE_FAILED"), (Throwable)e);
            throw new InternalError();
        }
    }

    public boolean doRestoreFilesInHomeDir(String params, int overwriteMode) {
        if (overwriteMode < 1 || overwriteMode > 3) {
            overwriteMode = MODE_RENAME;
        }
        String userHomeFolderPath = ClientRepositoryPaths.getUserHomeFolderPath((String)this.getSession().getName());
        String filesToDeletePermanent = null;
        if (overwriteMode == MODE_RENAME) {
            this.doCopyFiles(userHomeFolderPath, overwriteMode, params);
            filesToDeletePermanent = params;
        } else if (overwriteMode == MODE_NO_OVERWRITE) {
            String nonConflictFileIds = this.getSourceFileIdsThatNotConflictWithFolderFiles(userHomeFolderPath, params);
            if (nonConflictFileIds.isEmpty()) {
                return true;
            }
            this.doCopyFiles(userHomeFolderPath, overwriteMode, nonConflictFileIds);
            filesToDeletePermanent = nonConflictFileIds;
        } else if (overwriteMode == MODE_OVERWRITE) {
            String conflictFileIdsInHomeDir = this.getFolderFileIdsThatConflictWithSource(userHomeFolderPath, params);
            if (!conflictFileIdsInHomeDir.isEmpty()) {
                try {
                    this.doDeleteFilesPermanent(conflictFileIdsInHomeDir);
                    this.doMoveFiles(userHomeFolderPath, params);
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)("File with id: " + e.getMessage() + " is not found!"));
                    return false;
                }
                catch (Exception e) {
                    logger.warn((Object)("Files with ids: " + params + " were restored, but not deleted"));
                    return false;
                }
            }
            try {
                this.doMoveFiles(userHomeFolderPath, params);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("File with id: " + e.getMessage() + " is not found!"));
                return false;
            }
        }
        if (filesToDeletePermanent != null && !params.isEmpty()) {
            try {
                this.doDeleteFilesPermanent(filesToDeletePermanent);
            }
            catch (Exception e) {
                logger.warn((Object)("Files with ids: " + filesToDeletePermanent + " were restored, but not deleted"));
            }
        }
        return true;
    }

    public String getFolderFileIdsThatConflictWithSource(String pathToFolder, String params) {
        if (params == null) {
            throw new IllegalArgumentException("parameters cannot be null");
        }
        String[] sourceFileIds = FileUtils.convertCommaSeparatedStringToArray(params);
        ArrayList<String> conflictFileIdsList = new ArrayList<String>();
        List<RepositoryFileDto> homeFolderFiles = this.doGetChildren(pathToFolder, null, false, true);
        for (RepositoryFileDto fileInHomeFolder : homeFolderFiles) {
            for (String sourceFileId : sourceFileIds) {
                RepositoryFile fileToRestore = this.getRepository().getFileById((Serializable)((Object)sourceFileId));
                if (!fileToRestore.getName().equals(fileInHomeFolder.getName())) continue;
                conflictFileIdsList.add(fileInHomeFolder.getId());
            }
        }
        return this.getCommaSeparatedFileIds(conflictFileIdsList);
    }

    protected String getSourceFileIdsThatNotConflictWithFolderFiles(String pathToFolder, String params) {
        String[] sourceFileIds = FileUtils.convertCommaSeparatedStringToArray(params);
        ArrayList<String> nonConflictFileIdsList = new ArrayList<String>();
        List<RepositoryFileDto> homeFolderFiles = this.doGetChildren(pathToFolder, null, true, true);
        for (String sourceFileId : sourceFileIds) {
            boolean isConflict = false;
            RepositoryFile fileToRestore = this.getRepository().getFileById((Serializable)((Object)sourceFileId));
            if (fileToRestore == null) {
                logger.error((Object)("Could not get file with id: " + sourceFileId));
                continue;
            }
            for (RepositoryFileDto fileInHomeFolder : homeFolderFiles) {
                if (!fileToRestore.getName().equals(fileInHomeFolder.getName())) continue;
                isConflict = true;
                break;
            }
            if (isConflict) continue;
            nonConflictFileIdsList.add(sourceFileId);
        }
        return this.getCommaSeparatedFileIds(nonConflictFileIdsList);
    }

    protected String getCommaSeparatedFileIds(List<String> fileIdsList) {
        if (fileIdsList == null || fileIdsList.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String fileId : fileIdsList) {
            stringBuilder.append(fileId).append(",");
        }
        String fileIds = stringBuilder.toString();
        fileIds = fileIds.substring(0, fileIds.length() - 1);
        return fileIds;
    }

    public DownloadFileWrapper doGetFileOrDirAsDownload(String userAgent, String pathId, String strWithManifest) throws Throwable {
        String path = this.idToPath(pathId);
        this.validateDownloadAccess(path);
        IAuthorizationPolicy policy = this.getPolicy();
        String encodedFileName = null;
        if (StringUtils.isEmpty((String)pathId)) {
            throw new InvalidParameterException(pathId);
        }
        if (!this.isPathValid(path)) {
            throw new IllegalSelectorException();
        }
        RepositoryFile repositoryFile = this.getRepository().getFile(path);
        if (repositoryFile == null) {
            throw new FileNotFoundException(path);
        }
        boolean withManifest = !"false".equals(strWithManifest);
        boolean requiresZip = repositoryFile.isFolder() || withManifest;
        BaseExportProcessor exportProcessor = this.getDownloadExportProcessor(path, requiresZip, withManifest);
        String originalFileName = requiresZip ? repositoryFile.getName() + ".zip" : repositoryFile.getName();
        encodedFileName = this.makeEncodedFileName(originalFileName);
        exportProcessor.addExportHandler(this.getDownloadExportHandler());
        StreamingOutput streamingOutput = this.getDownloadStream(repositoryFile, exportProcessor);
        return new DownloadFileWrapper(streamingOutput, HttpMimeTypeListener.buildContentDispositionValue(originalFileName, true), encodedFileName);
    }

    private String makeEncodedFileName(String originalFile) throws UnsupportedEncodingException {
        return URLEncoder.encode(originalFile, "UTF-8").replaceAll("\\+", "%20");
    }

    public RepositoryFileToStreamWrapper doGetFileAsInline(String pathId) throws FileNotFoundException {
        String path = null;
        RepositoryFile repositoryFile = null;
        path = this.idToPath(pathId);
        if (this.isPath(path)) {
            if (!this.isPathValid(path)) {
                throw new IllegalArgumentException();
            }
            repositoryFile = this.getRepository().getFile(path);
        } else {
            repositoryFile = this.getRepository().getFileById((Serializable)((Object)pathId));
        }
        if (repositoryFile == null) {
            throw new FileNotFoundException();
        }
        if (!this.getWhitelist().accept(repositoryFile.getName()) && !this.getPolicy().isAllowed("org.pentaho.security.publish")) {
            throw new IllegalArgumentException();
        }
        try {
            SimpleRepositoryFileData fileData = (SimpleRepositoryFileData)this.getRepository().getDataForRead(repositoryFile.getId(), SimpleRepositoryFileData.class);
            InputStream is = fileData.getInputStream();
            StreamingOutput streamingOutput = this.getStreamingOutput(is);
            RepositoryFileToStreamWrapper wrapper = new RepositoryFileToStreamWrapper();
            wrapper.setOutputStream(streamingOutput);
            wrapper.setRepositoryFile(repositoryFile);
            return wrapper;
        }
        catch (Exception e) {
            logger.error((Object)org.pentaho.platform.web.http.messages.Messages.getInstance().getString("FileResource.EXPORT_FAILED", new Object[]{repositoryFile.getName() + " " + e.getMessage()}), (Throwable)e);
            throw new InternalError();
        }
    }

    public List<StringKeyStringValueDto> doGetLocaleProperties(String pathId, String locale) {
        Properties properties;
        PropertiesWrapper propertiesWrapper;
        RepositoryFileDto file = this.getRepoWs().getFile(this.idToPath(pathId));
        ArrayList<StringKeyStringValueDto> keyValueList = new ArrayList<StringKeyStringValueDto>();
        if (file != null && (propertiesWrapper = this.getRepoWs().getLocalePropertiesForFileById(file.getId(), locale)) != null && (properties = propertiesWrapper.getProperties()) != null && !properties.isEmpty()) {
            for (String key : properties.stringPropertyNames()) {
                keyValueList.add(this.getStringKeyStringValueDto(key, properties.getProperty(key)));
            }
        }
        return keyValueList;
    }

    public void doSetLocaleProperties(String pathId, String locale, List<StringKeyStringValueDto> properties) throws Exception {
        RepositoryFileDto file = this.getRepoWs().getFile(this.idToPath(pathId));
        Properties fileProperties = new Properties();
        if (properties != null && !properties.isEmpty()) {
            for (StringKeyStringValueDto dto : properties) {
                fileProperties.put(dto.getKey(), dto.getValue());
            }
        }
        this.getRepoWs().setLocalePropertiesForFileByFileId(file.getId(), locale, fileProperties);
    }

    public void doCopyFiles(String pathId, Integer mode, String params) {
        if (!this.getPolicy().isAllowed("org.pentaho.repository.create")) {
            throw new IllegalArgumentException();
        }
        if (mode == null) {
            mode = MODE_RENAME;
        }
        String path = this.idToPath(pathId);
        String[] sourceFileIds = FileUtils.convertCommaSeparatedStringToArray(params);
        CopyFilesOperation copyFilesOperation = new CopyFilesOperation(this.getRepository(), this.getRepoWs(), Arrays.asList(sourceFileIds), path, mode);
        copyFilesOperation.execute();
    }

    public RepositoryFileToStreamWrapper doGetFileOrDir(String pathId) throws FileNotFoundException {
        String path = this.idToPath(pathId);
        if (!this.isPathValid(path)) {
            throw new IllegalArgumentException();
        }
        RepositoryFile repoFile = this.getRepository().getFile(path);
        if (repoFile == null) {
            throw new FileNotFoundException();
        }
        if (!this.getWhitelist().accept(repoFile.getName()) && !this.getPolicy().isAllowed("org.pentaho.security.publish")) {
            throw new IllegalArgumentException();
        }
        RepositoryFileInputStream is = this.getRepositoryFileInputStream(repoFile);
        StreamingOutput streamingOutput = this.getStreamingOutput((InputStream)is);
        RepositoryFileToStreamWrapper wrapper = new RepositoryFileToStreamWrapper();
        wrapper.setOutputStream(streamingOutput);
        wrapper.setRepositoryFile(repoFile);
        wrapper.setMimetype(is.getMimeType());
        return wrapper;
    }

    public void setFileAcls(String pathId, RepositoryFileAclDto acl) throws FileNotFoundException {
        RepositoryFileDto file = this.getRepoWs().getFile(this.idToPath(pathId));
        if (file == null) {
            throw new FileNotFoundException();
        }
        acl.setId(file.getId());
        List aces = acl.getAces();
        if (aces != null) {
            Iterator it = aces.iterator();
            while (it.hasNext()) {
                RepositoryFileAclAceDto ace = (RepositoryFileAclAceDto)it.next();
                if (ace.isModifiable()) continue;
                it.remove();
            }
        }
        this.getRepoWs().updateAcl(acl);
    }

    public String doGetIsVisible(String pathId) {
        RepositoryFileDto repositoryFileDto = this.getRepoWs().getFile(this.idToPath(pathId));
        return repositoryFileDto != null && repositoryFileDto.isHidden() ? "false" : "true";
    }

    public boolean isFolder(String pathId) {
        RepositoryFileDto repositoryFileDto = this.getRepoWs().getFile(this.idToPath(pathId));
        return repositoryFileDto != null && repositoryFileDto.isFolder();
    }

    public boolean doesExist(String pathId) {
        RepositoryFileDto repositoryFileDto = this.getRepoWs().getFile(this.idToPath(pathId));
        return repositoryFileDto != null && repositoryFileDto.getId() != null;
    }

    private boolean isInsideOfAnyHiddenFolder(RepositoryFileDto repositoryFileDto) {
        if (repositoryFileDto == null || repositoryFileDto.isHidden()) {
            return true;
        }
        int indexLastFolderSeparator = repositoryFileDto.getPath().lastIndexOf(47);
        if (indexLastFolderSeparator < 0) {
            return false;
        }
        String parentPathId = repositoryFileDto.getPath().substring(0, indexLastFolderSeparator).replace('/', ':');
        if (StringUtils.isEmpty((String)parentPathId)) {
            return false;
        }
        return this.isInsideOfAnyHiddenFolder(this.getRepoWs().getFile(this.idToPath(parentPathId)));
    }

    public String doGetDefaultLocation(String pathId) {
        RepositoryFileDto repositoryFileDto = this.getRepoWs().getFile(this.idToPath(pathId));
        if (repositoryFileDto == null) {
            return ClientRepositoryPaths.getRootFolderPath();
        }
        if (this.isInsideOfAnyHiddenFolder(repositoryFileDto)) {
            String defaultFolder = ((ISystemConfig)PentahoSystem.get(ISystemConfig.class)).getProperty("system.defaultFolderWhenHomeFolderIsHidden");
            if (defaultFolder != null && defaultFolder.length() > 0) {
                repositoryFileDto = this.getRepoWs().getFile(defaultFolder);
                if (repositoryFileDto == null) {
                    return ClientRepositoryPaths.getRootFolderPath();
                }
                if (this.isInsideOfAnyHiddenFolder(repositoryFileDto)) {
                    repositoryFileDto = this.getRepoWs().getFile(ClientRepositoryPaths.getPublicFolderPath());
                    if (this.isInsideOfAnyHiddenFolder(repositoryFileDto)) {
                        return ClientRepositoryPaths.getRootFolderPath();
                    }
                    return ClientRepositoryPaths.getPublicFolderPath();
                }
                return defaultFolder;
            }
            repositoryFileDto = this.getRepoWs().getFile(ClientRepositoryPaths.getPublicFolderPath());
            if (this.isInsideOfAnyHiddenFolder(repositoryFileDto)) {
                return ClientRepositoryPaths.getRootFolderPath();
            }
            return ClientRepositoryPaths.getPublicFolderPath();
        }
        return repositoryFileDto.getPath();
    }

    public String doGetCanAccess(String pathId, String permissions) {
        StringTokenizer tokenizer = new StringTokenizer(permissions, "|");
        ArrayList<Integer> permissionList = new ArrayList<Integer>();
        while (tokenizer.hasMoreTokens()) {
            Integer perm = Integer.valueOf(tokenizer.nextToken());
            switch (perm) {
                case 0: {
                    permissionList.add(RepositoryFilePermission.READ.ordinal());
                    break;
                }
                case 1: {
                    permissionList.add(RepositoryFilePermission.WRITE.ordinal());
                    break;
                }
                case 2: {
                    permissionList.add(RepositoryFilePermission.DELETE.ordinal());
                    break;
                }
                case 3: {
                    permissionList.add(RepositoryFilePermission.ACL_MANAGEMENT.ordinal());
                    break;
                }
                case 4: {
                    permissionList.add(RepositoryFilePermission.ALL.ordinal());
                }
            }
        }
        return this.getRepoWs().hasAccess(this.idToPath(pathId), permissionList) ? "true" : "false";
    }

    public StringBuffer doGetReservedChars() {
        List reservedCharacters = this.getRepoWs().getReservedChars();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < reservedCharacters.size(); ++i) {
            buffer.append(reservedCharacters.get(i));
        }
        return buffer;
    }

    public StringBuffer doGetReservedCharactersDisplay() {
        List reservedCharacters = this.getRepoWs().getReservedChars();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < reservedCharacters.size(); ++i) {
            if (((Character)reservedCharacters.get(i)).charValue() >= '\u0007' && ((Character)reservedCharacters.get(i)).charValue() <= '\r') {
                buffer.append(this.escapeJava("" + reservedCharacters.get(i)));
            } else {
                buffer.append(reservedCharacters.get(i));
            }
            if (i + 1 >= reservedCharacters.size()) continue;
            buffer.append(',');
        }
        return buffer;
    }

    public RepositoryFileDto doGetRootProperties() {
        return this.getRepoWs().getFile("/");
    }

    public RepositoryFileDto doGetProperties(String pathId) throws FileNotFoundException {
        RepositoryFileDto file = this.getRepoWs().getFile(FileUtils.idToPath(pathId));
        if (file == null) {
            throw new FileNotFoundException();
        }
        return file;
    }

    public String doGetCanEdit() {
        String editPermission = PentahoSystem.getSystemSetting((String)"edit-permission", (String)"");
        if (editPermission != null && editPermission.length() > 0) {
            return this.getPolicy().isAllowed(editPermission) ? "true" : "false";
        }
        return "true";
    }

    public String doGetCanCreate() {
        return this.getPolicy().isAllowed("org.pentaho.repository.create") ? "true" : "false";
    }

    public RepositoryFileDto doGetContentCreator(String pathId) throws FileNotFoundException {
        RepositoryFileDto file = this.getRepoWs().getFile(this.idToPath(pathId));
        if (file == null) {
            throw new FileNotFoundException();
        }
        Map fileMetadata = this.getRepository().getFileMetadata((Serializable)((Object)file.getId()));
        String creatorId = (String)fileMetadata.get(PentahoJcrConstants.PHO_CONTENTCREATOR);
        if (creatorId != null && creatorId.length() > 0) {
            return this.getRepoWs().getFileById(creatorId);
        }
        return null;
    }

    public List<RepositoryFileDto> doGetDeletedFiles() {
        return this.getRepoWs().getDeletedFiles();
    }

    public List<StringKeyStringValueDto> doGetMetadata(String pathId) throws FileNotFoundException {
        List list = null;
        String path = null;
        if (pathId == null || pathId.equals("/")) {
            path = "/";
        } else if (!pathId.startsWith("/")) {
            path = this.idToPath(pathId);
        }
        RepositoryFileDto file = this.getRepoWs().getFile(path);
        if (file == null) {
            throw new FileNotFoundException();
        }
        list = this.getRepoWs().getFileMetadata(file.getId());
        if (list != null) {
            boolean hasSchedulable = false;
            for (StringKeyStringValueDto value : list) {
                if (!value.getKey().equals("_PERM_SCHEDULABLE")) continue;
                hasSchedulable = true;
                break;
            }
            if (!hasSchedulable) {
                StringKeyStringValueDto schedPerm = new StringKeyStringValueDto("_PERM_SCHEDULABLE", "true");
                list.add(schedPerm);
            }
            list.add(new StringKeyStringValueDto("_PERM_HIDDEN", String.valueOf(file.isHidden())));
        }
        return list;
    }

    public void doSetMetadata(String pathId, List<StringKeyStringValueDto> metadata) throws GeneralSecurityException {
        boolean canManage;
        RepositoryFileDto file = this.getRepoWs().getFile(this.idToPath(pathId));
        RepositoryFileAclDto fileAcl = this.getRepoWs().getAcl(file.getId());
        boolean bl = canManage = this.getSession().getName().equals(fileAcl.getOwner()) || this.getPolicy().isAllowed("org.pentaho.repository.read") && this.getPolicy().isAllowed("org.pentaho.repository.create") && this.getPolicy().isAllowed("org.pentaho.security.administerSecurity");
        if (!canManage) {
            if (fileAcl.isEntriesInheriting()) {
                List aces = this.getRepoWs().getEffectiveAces(file.getId());
                fileAcl.setAces(aces, fileAcl.isEntriesInheriting());
            }
            for (int i = 0; i < fileAcl.getAces().size(); ++i) {
                RepositoryFileAclAceDto acl = (RepositoryFileAclAceDto)fileAcl.getAces().get(i);
                if (!acl.getRecipient().equals(this.getSession().getName()) || !acl.getPermissions().contains(RepositoryFilePermission.ACL_MANAGEMENT.ordinal()) && !acl.getPermissions().contains(RepositoryFilePermission.ALL.ordinal())) continue;
                canManage = true;
                break;
            }
        }
        if (canManage) {
            Map fileMetadata = this.getRepository().getFileMetadata((Serializable)((Object)file.getId()));
            boolean isHidden = false;
            boolean isSchedulable = true;
            fileMetadata.remove("_PERM_HIDDEN");
            for (StringKeyStringValueDto nv : metadata) {
                String key = nv.getKey();
                if ("_PERM_HIDDEN".equalsIgnoreCase(key)) {
                    isHidden = BooleanUtils.toBoolean((String)nv.getValue());
                    continue;
                }
                if ("_PERM_SCHEDULABLE".equalsIgnoreCase(key)) {
                    isSchedulable = BooleanUtils.toBoolean((String)nv.getValue());
                }
                fileMetadata.put(key, nv.getValue());
            }
            if (!file.isFolder()) {
                this.getRepository().setFileMetadata((Serializable)((Object)file.getId()), fileMetadata);
            }
            if (file.isHidden() != isHidden) {
                file.setHidden(isHidden);
                file.setNotSchedulable(!isSchedulable);
                RepositoryFile sourceFile = this.getRepository().getFileById((Serializable)((Object)file.getId()));
                RepositoryFileDto destFileDto = this.toFileDto(sourceFile, null, false);
                destFileDto.setHidden(isHidden);
                destFileDto.setNotSchedulable(!isSchedulable);
                RepositoryFile destFile = this.toFile(destFileDto);
                RepositoryFileAcl acl = this.getRepository().getAcl(sourceFile.getId());
                if (!file.isFolder()) {
                    IRepositoryFileData data = RepositoryFileHelper.getFileData(sourceFile);
                    this.getRepository().updateFile(destFile, data, null);
                    this.getRepository().updateAcl(acl);
                } else {
                    this.getRepository().updateFolder(destFile, null);
                }
            }
        } else {
            throw new GeneralSecurityException();
        }
    }

    protected RepositoryFileDto toFileDto(RepositoryFile repositoryFile, Set<String> memberSet, boolean exclude) {
        return RepositoryFileAdapter.toFileDto((RepositoryFile)repositoryFile, memberSet, (boolean)exclude);
    }

    public RepositoryFile toFile(RepositoryFileDto repositoryFileDto) {
        return RepositoryFileAdapter.toFile((RepositoryFileDto)repositoryFileDto);
    }

    public RepositoryDownloadWhitelist getWhitelist() {
        if (this.whitelist == null) {
            this.whitelist = new RepositoryDownloadWhitelist();
        }
        return this.whitelist;
    }

    public boolean isPathValid(String path) {
        return !path.startsWith("/etc") && !path.startsWith("/system");
    }

    public boolean isPath(String pathId) {
        return pathId != null && pathId.contains("/");
    }

    public boolean canRestoreToFolderWithNoConflicts(String pathToFolder, String params) {
        if (params == null) {
            throw new IllegalArgumentException("parameters cannot be null");
        }
        List<RepositoryFileDto> filesInFolder = this.doGetChildren(pathToFolder, null, false, true);
        String[] sourceFileIds = FileUtils.convertCommaSeparatedStringToArray(params);
        for (RepositoryFileDto fileInFolder : filesInFolder) {
            for (String sourceFileId : sourceFileIds) {
                RepositoryFile fileToRestore = this.getRepository().getFileById((Serializable)((Object)sourceFileId));
                if (!fileToRestore.getName().equals(fileInFolder.getName())) continue;
                return false;
            }
        }
        return true;
    }

    public IAuthorizationPolicy getPolicy() {
        if (this.policy == null) {
            this.policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        }
        return this.policy;
    }

    public void doSetContentCreator(String pathId, RepositoryFileDto contentCreator) throws FileNotFoundException {
        RepositoryFileDto file = this.getRepoWs().getFile(this.idToPath(pathId));
        if (file == null) {
            throw new FileNotFoundException();
        }
        try {
            Map fileMetadata = this.getRepository().getFileMetadata((Serializable)((Object)file.getId()));
            fileMetadata.put(PentahoJcrConstants.PHO_CONTENTCREATOR, contentCreator.getId());
            this.getRepository().setFileMetadata((Serializable)((Object)file.getId()), fileMetadata);
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }

    public List<LocaleMapDto> doGetFileLocales(String pathId) throws FileNotFoundException {
        ArrayList<LocaleMapDto> availableLocales = new ArrayList<LocaleMapDto>();
        RepositoryFileDto file = this.getRepoWs().getFile(this.idToPath(pathId));
        if (file == null) {
            throw new FileNotFoundException();
        }
        try {
            List locales = this.getRepoWs().getAvailableLocalesForFileById(file.getId());
            if (locales != null && !locales.isEmpty()) {
                for (PentahoLocale locale : locales) {
                    availableLocales.add(new LocaleMapDto(locale.toString(), null));
                }
            }
        }
        catch (Exception e) {
            throw new InternalError();
        }
        return availableLocales;
    }

    public boolean doCanAdminister() {
        boolean status = false;
        try {
            status = this.getPolicy().isAllowed("org.pentaho.repository.read") && this.getPolicy().isAllowed("org.pentaho.repository.create") && this.getPolicy().isAllowed("org.pentaho.security.administerSecurity");
        }
        catch (Exception e) {
            logger.error((Object)org.pentaho.platform.web.http.messages.Messages.getInstance().getString("SystemResource.CAN_ADMINISTER"), (Throwable)e);
        }
        return status;
    }

    public RepositoryFileAclDto doGetFileAcl(String pathId) {
        RepositoryFileDto file = this.getRepoWs().getFile(FileUtils.idToPath(pathId));
        RepositoryFileAclDto fileAcl = this.getRepoWs().getAcl(file.getId());
        if (fileAcl.isEntriesInheriting()) {
            List aces = this.getRepoWs().getEffectiveAcesWithForceFlag(file.getId(), fileAcl.isEntriesInheriting());
            fileAcl.setAces(aces, fileAcl.isEntriesInheriting());
        }
        this.addAdminRole(fileAcl);
        return fileAcl;
    }

    protected void addAdminRole(RepositoryFileAclDto fileAcl) {
        String adminRoleName = (String)PentahoSystem.get(String.class, (String)"singleTenantAdminAuthorityName", (IPentahoSession)PentahoSessionHolder.getSession());
        if (fileAcl.getAces() == null) {
            fileAcl.setAces(new LinkedList());
        }
        for (RepositoryFileAclAceDto facl : fileAcl.getAces()) {
            if (!facl.getRecipient().equals(adminRoleName) || facl.getRecipientType() != 1) continue;
            return;
        }
        RepositoryFileAclAceDto adminGroup = new RepositoryFileAclAceDto();
        adminGroup.setRecipient(adminRoleName);
        adminGroup.setRecipientType(1);
        adminGroup.setModifiable(false);
        LinkedList<Integer> perms = new LinkedList<Integer>();
        perms.add(4);
        adminGroup.setPermissions(perms);
        fileAcl.getAces().add(adminGroup);
    }

    public RepositoryFileTreeDto doGetTree(String pathId, Integer depth, String filter, Boolean showHidden, Boolean includeAcls) {
        return this.doGetTree(pathId, depth, filter, showHidden, includeAcls, false);
    }

    public RepositoryFileTreeDto doGetTree(String pathId, Integer depth, String filter, Boolean showHidden, Boolean includeAcls, Boolean includeSystemFolders) {
        String path = null;
        if (pathId == null || pathId.equals("/")) {
            path = "/";
        } else if (!pathId.startsWith("/")) {
            path = this.idToPath(pathId);
        }
        RepositoryRequest repositoryRequest = this.getRepositoryRequest(path, showHidden, depth, filter);
        repositoryRequest.setIncludeAcls(includeAcls.booleanValue());
        repositoryRequest.setIncludeSystemFolders(includeSystemFolders.booleanValue());
        RepositoryFileTreeDto tree = null;
        try {
            tree = this.getRepoWs().getTreeFromRequest(repositoryRequest);
        }
        catch (UnifiedRepositoryException e) {
            logger.error((Object)e.getCause());
        }
        for (RepositoryFileTreeDto dto : tree.getChildren()) {
            if (dto.getFile().getName().equals(ClientRepositoryPaths.getHomeFolderName()) && dto.getFile().getPath().equals(ClientRepositoryPaths.getHomeFolderPath())) {
                dto.getFile().setTitle(org.pentaho.platform.web.http.messages.Messages.getInstance().getString("FileResource.HOME_FOLDER_DISPLAY_TITLE"));
                continue;
            }
            if (!dto.getFile().getName().equals(ClientRepositoryPaths.getPublicFolderName()) || !dto.getFile().getPath().equals(ClientRepositoryPaths.getPublicFolderPath())) continue;
            dto.getFile().setTitle(org.pentaho.platform.web.http.messages.Messages.getInstance().getString("FileResource.PUBLIC_FOLDER_DISPLAY_TITLE"));
        }
        if (tree != null && this.isShowingTitle(repositoryRequest)) {
            Collator collator = this.getCollatorInstance();
            collator.setStrength(0);
            this.sortByLocaleTitle(collator, tree);
        }
        return tree;
    }

    public void sortByLocaleTitle(final Collator collator, RepositoryFileTreeDto tree) {
        if (tree == null || tree.getChildren() == null || tree.getChildren().size() <= 0) {
            return;
        }
        for (RepositoryFileTreeDto rft : tree.getChildren()) {
            this.sortByLocaleTitle(collator, rft);
        }
        Collections.sort(tree.getChildren(), new Comparator<RepositoryFileTreeDto>(){

            @Override
            public int compare(RepositoryFileTreeDto repositoryFileTree, RepositoryFileTreeDto repositoryFileTree2) {
                String title2;
                String title1 = repositoryFileTree.getFile().getTitle();
                if (collator.compare(title1, title2 = repositoryFileTree2.getFile().getTitle()) == 0) {
                    return title1.compareTo(title2);
                }
                return collator.compare(title1, title2);
            }
        });
    }

    public List<RepositoryFileDto> doGetGeneratedContent(String pathId) throws FileNotFoundException {
        SessionResource sessionResource = this.getSessionResource();
        return this.doGetGeneratedContentForUser(pathId, sessionResource.doGetCurrentUserDir());
    }

    public List<RepositoryFileDto> doGetGeneratedContent(String pathId, String user) throws FileNotFoundException {
        SessionResource sessionResource = this.getSessionResource();
        return this.doGetGeneratedContentForUser(pathId, sessionResource.doGetUserDir(user));
    }

    private List<RepositoryFileDto> doGetGeneratedContentForUser(String pathId, String userDir) throws FileNotFoundException {
        RepositoryFileDto targetFile = this.doGetProperties(pathId);
        if (targetFile != null) {
            String targetFileId = targetFile.getId();
            return this.searchGeneratedContent(userDir, targetFileId, PentahoJcrConstants.PHO_CONTENTCREATOR);
        }
        logger.error((Object)org.pentaho.platform.web.http.messages.Messages.getInstance().getString("FileResource.FILE_NOT_FOUND", new Object[]{pathId}));
        throw new FileNotFoundException(pathId);
    }

    protected List<RepositoryFileDto> searchGeneratedContent(String userDir, String targetComparator, String metadataConstant) throws FileNotFoundException {
        ArrayList<RepositoryFileDto> content = new ArrayList<RepositoryFileDto>();
        RepositoryFile workspaceFolder = this.getRepository().getFile(userDir);
        if (workspaceFolder != null) {
            List children = this.getRepository().getChildren(workspaceFolder.getId());
            for (RepositoryFile child : children) {
                Map fileMetadata;
                String creatorId;
                if (child.isFolder() || (creatorId = (String)(fileMetadata = this.getRepository().getFileMetadata(child.getId())).get(metadataConstant)) == null || !creatorId.equals(targetComparator)) continue;
                content.add(this.toFileDto(child, null, false));
            }
        } else {
            logger.error((Object)org.pentaho.platform.web.http.messages.Messages.getInstance().getString("FileResource.WORKSPACE_FOLDER_NOT_FOUND", new Object[]{userDir}));
            throw new FileNotFoundException(userDir);
        }
        return content;
    }

    protected SessionResource getSessionResource() {
        if (this.sessionResource == null) {
            this.sessionResource = new SessionResource();
        }
        return this.sessionResource;
    }

    public boolean doRename(String pathId, String newName) throws Exception {
        String extension;
        IUnifiedRepository repository = this.getRepository();
        RepositoryFile fileToBeRenamed = repository.getFile(FileUtils.idToPath(pathId));
        StringBuilder buf = new StringBuilder(fileToBeRenamed.getPath().length());
        buf.append(this.getParentPath(fileToBeRenamed.getPath()));
        buf.append("/");
        buf.append(newName);
        if (!fileToBeRenamed.isFolder() && (extension = this.getExtension(fileToBeRenamed.getName())) != null) {
            buf.append(extension);
        }
        if (repository.getFile(buf.toString()) != null) {
            throw new IllegalArgumentException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0003_ILLEGAL_DEST_PATH"));
        }
        repository.moveFile(fileToBeRenamed.getId(), buf.toString(), "Renaming the file");
        RepositoryFile movedFile = repository.getFileById(fileToBeRenamed.getId());
        if (movedFile != null) {
            if (!movedFile.isFolder()) {
                HashMap<String, Object> localePropertiesMap = movedFile.getLocalePropertiesMap();
                if (localePropertiesMap == null) {
                    localePropertiesMap = new HashMap<String, Object>();
                    Properties properties = new Properties();
                    properties.setProperty("file.title", newName);
                    properties.setProperty("title", newName);
                    localePropertiesMap.put("default", properties);
                } else {
                    for (Map.Entry entry : localePropertiesMap.entrySet()) {
                        Properties properties = (Properties)entry.getValue();
                        if (properties.containsKey("file.title")) {
                            properties.setProperty("file.title", newName);
                        }
                        if (!properties.containsKey("title")) continue;
                        properties.setProperty("title", newName);
                    }
                }
                RepositoryFile updatedFile = new RepositoryFile.Builder(movedFile).localePropertiesMap(localePropertiesMap).name(newName).title(newName).build();
                repository.updateFile(updatedFile, RepositoryFileHelper.getFileData(movedFile), "Updating the file");
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean doCreateDir(String pathId) {
        String path = this.idToPath(pathId);
        return this.doCreateDirFor(path);
    }

    boolean doCreateDirFor(String pathWithSlashes) {
        String[] folders = pathWithSlashes.split("[/]");
        RepositoryFileDto parentDir = this.getRepoWs().getFile("/");
        boolean dirCreated = false;
        for (String folder : folders) {
            RepositoryFileDto currentFolder;
            String currentFolderPath = (parentDir.getPath() + "/" + folder).substring(1);
            if (!currentFolderPath.startsWith("/")) {
                currentFolderPath = "/" + currentFolderPath;
            }
            if ((currentFolder = this.getRepoWs().getFile(currentFolderPath)) == null) {
                currentFolder = new RepositoryFileDto();
                currentFolder.setFolder(true);
                currentFolder.setName(this.decode(folder));
                currentFolder.setPath(parentDir.getPath() + "/" + folder);
                currentFolder = this.getRepoWs().createFolder(parentDir.getId(), currentFolder, currentFolderPath);
                dirCreated = true;
            }
            parentDir = currentFolder;
        }
        return dirCreated;
    }

    public boolean doCreateDirSafe(String pathId) throws InvalidNameException {
        if (pathId.indexOf(47) != -1) {
            throw new InvalidNameException();
        }
        String path = this.idToPath(pathId);
        if (path.indexOf(92) != -1) {
            throw new InvalidNameException();
        }
        if (!this.isValidFolderName(path)) {
            throw new InvalidNameException();
        }
        return this.doCreateDirFor(path);
    }

    public boolean isValidFolderName(String path) {
        if (FileUtils.containsReservedCharacter(path, this.doGetReservedChars().toString().toCharArray()) || FileUtils.containsControlCharacters(path)) {
            return false;
        }
        String folderName = this.decode(FilenameUtils.getName((String)path));
        return !".".equals(folderName) && !"..".equals(folderName) && !FileUtils.containsControlCharacters(folderName);
    }

    public boolean isValidFileName(String name) {
        return !StringUtils.isEmpty((String)name) && name.trim().equals(name) && this.decode(name).trim().equals(this.decode(name)) && !FileUtils.containsReservedCharacter(name, this.doGetReservedChars().toString().toCharArray()) && !FileUtils.containsControlCharacters(name) && !FileUtils.containsControlCharacters(this.decode(name));
    }

    private String getParentPath(String path) {
        return FileUtils.getParentPath(path);
    }

    private String getExtension(String name) {
        int startIndex = name.lastIndexOf(46);
        if (startIndex >= 0) {
            return name.substring(startIndex, name.length());
        }
        return null;
    }

    protected DefaultUnifiedRepositoryWebService getRepoWs() {
        if (this.defaultUnifiedRepositoryWebService == null) {
            this.defaultUnifiedRepositoryWebService = new DefaultUnifiedRepositoryWebService();
        }
        return this.defaultUnifiedRepositoryWebService;
    }

    public int copy(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copy((InputStream)input, (OutputStream)output);
    }

    public RepositoryFileOutputStream getRepositoryFileOutputStream(String path) {
        return new RepositoryFileOutputStream(path);
    }

    public RepositoryFileInputStream getRepositoryFileInputStream(RepositoryFile repositoryFile) throws FileNotFoundException {
        return new RepositoryFileInputStream(repositoryFile);
    }

    public StreamingOutput getStreamingOutput(final InputStream is) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                FileService.this.copy(is, output);
            }
        };
    }

    public StringKeyStringValueDto getStringKeyStringValueDto(String key, String value) {
        return new StringKeyStringValueDto(key, value);
    }

    public IUnifiedRepository getRepository() {
        if (this.repository == null) {
            this.repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        }
        return this.repository;
    }

    public String idToPath(String pathId) {
        return FileUtils.idToPath(pathId);
    }

    protected IPentahoSession getSession() {
        return PentahoSessionHolder.getSession();
    }

    protected String escapeJava(String value) {
        return StringEscapeUtils.escapeJava((String)value);
    }

    protected BaseExportProcessor getDownloadExportProcessor(String path, boolean requiresZip, boolean withManifest) {
        return requiresZip ? new ZipExportProcessor(path, this.getRepository(), withManifest) : new SimpleExportProcessor(path, this.getRepository());
    }

    protected ExportHandler getDownloadExportHandler() {
        return (ExportHandler)PentahoSystem.get(DefaultExportHandler.class);
    }

    protected StreamingOutput getDownloadStream(RepositoryFile repositoryFile, BaseExportProcessor exportProcessor) throws ExportException, IOException {
        File zipFile = exportProcessor.performExport(repositoryFile);
        final FileInputStream is = new FileInputStream(zipFile);
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                IOUtils.copy((InputStream)is, (OutputStream)output);
            }
        };
    }

    protected RepositoryRequest getRepositoryRequest(String path, Boolean showHidden, Integer depth, String filter) {
        return new RepositoryRequest(path, showHidden, depth, filter);
    }

    protected Collator getCollatorInstance() {
        return Collator.getInstance(LocaleHelper.getLocale());
    }

    public List<RepositoryFileDto> doGetChildren(String pathId, String filter, Boolean showHidden, Boolean includeAcls) {
        List<Object> repositoryFileDtoList = new ArrayList<RepositoryFileDto>();
        RepositoryFileDto repositoryFileDto = this.getRepoWs().getFile(FileUtils.idToPath(pathId));
        if (repositoryFileDto != null && this.isPathValid(repositoryFileDto.getPath())) {
            RepositoryRequest repositoryRequest = this.getRepositoryRequest(repositoryFileDto, showHidden, filter, includeAcls);
            repositoryFileDtoList = this.getRepoWs().getChildrenFromRequest(repositoryRequest);
            if (this.isShowingTitle(repositoryRequest)) {
                Collator collator = this.getCollator(0);
                this.sortByLocaleTitle(collator, repositoryFileDtoList);
            }
        }
        return repositoryFileDtoList;
    }

    public boolean isShowingTitle(RepositoryRequest repositoryRequest) {
        return !(repositoryRequest.getExcludeMemberSet() != null && !repositoryRequest.getExcludeMemberSet().isEmpty() ? repositoryRequest.getExcludeMemberSet().contains("title") : repositoryRequest.getIncludeMemberSet() != null && !repositoryRequest.getIncludeMemberSet().contains("title"));
    }

    public void sortByLocaleTitle(final Collator collator, List<RepositoryFileDto> repositoryFileDtoList) {
        if (repositoryFileDtoList == null || repositoryFileDtoList.size() <= 0) {
            return;
        }
        Collections.sort(repositoryFileDtoList, new Comparator<RepositoryFileDto>(){

            @Override
            public int compare(RepositoryFileDto repositoryFile, RepositoryFileDto repositoryFile2) {
                String title2;
                String title1 = repositoryFile.getTitle();
                if (collator.compare(title1, title2 = repositoryFile2.getTitle()) == 0) {
                    return title1.compareTo(title2);
                }
                return collator.compare(title1, title2);
            }
        });
    }

    protected RepositoryRequest getRepositoryRequest(RepositoryFileDto repositoryFileDto, Boolean showHidden, String filter, Boolean includeAcls) {
        RepositoryRequest repositoryRequest = new RepositoryRequest(repositoryFileDto.getId(), showHidden, Integer.valueOf(0), filter);
        repositoryRequest.setIncludeAcls(includeAcls.booleanValue());
        return repositoryRequest;
    }

    protected Collator getCollator(int strength) {
        Collator collator = this.getCollatorInstance();
        collator.setStrength(strength);
        return collator;
    }

    private PentahoPlatformExporter getBackupExporter() {
        if (this.backupExporter == null) {
            this.backupExporter = new PentahoPlatformExporter(this.getRepository());
        }
        return this.backupExporter;
    }

    protected String decode(String folder) {
        String decodeName = folder;
        try {
            decodeName = URLDecoder.decode(folder, "UTF-8");
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return decodeName;
    }

    protected void validateDownloadAccess(String importDir) throws PentahoAccessControlException {
        boolean canDownload = SystemUtils.canDownload(importDir);
        if (!canDownload) {
            throw new PentahoAccessControlException("User is not authorized to perform this operation");
        }
    }

    public static class InvalidNameException
    extends Exception {
        private static final long serialVersionUID = 5394548505099358146L;
    }

    public class RepositoryFileToStreamWrapper {
        private StreamingOutput outputStream;
        private RepositoryFile repositoryFile;
        private String mimetype;

        public void setOutputStream(StreamingOutput outputStream) {
            this.outputStream = outputStream;
        }

        public void setRepositoryFile(RepositoryFile repositoryFile) {
            this.repositoryFile = repositoryFile;
        }

        public void setMimetype(String mimetype) {
            this.mimetype = mimetype;
        }

        public StreamingOutput getOutputStream() {
            return this.outputStream;
        }

        public String getMimetype() {
            return this.mimetype;
        }

        public RepositoryFile getRepositoryFile() {
            return this.repositoryFile;
        }
    }

    public class DownloadFileWrapper {
        private StreamingOutput outputStream;
        private String attachment;
        private String encodedFileName;

        public DownloadFileWrapper(StreamingOutput outputStream, String attachment, String encodedFileName) {
            this.outputStream = outputStream;
            this.attachment = attachment;
            this.encodedFileName = encodedFileName;
        }

        public StreamingOutput getOutputStream() {
            return this.outputStream;
        }

        public String getAttachment() {
            return this.attachment;
        }

        public String getEncodedFileName() {
            return this.encodedFileName;
        }
    }
}

