/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.modules.jersey.ExternallyManagedLifecycle;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IConfiguration;
import org.pentaho.platform.api.engine.IContentInfo;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginOperation;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.api.repository2.unified.webservices.ExecutableFileTypeDto;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.AuthenticationProvider;
import org.pentaho.platform.web.http.api.resources.TimeZoneWrapper;
import org.pentaho.platform.web.http.api.resources.services.SystemService;
import org.pentaho.platform.web.http.messages.Messages;

@Path(value="/system/")
@ExternallyManagedLifecycle
@Facet(name="Unsupported")
public class SystemResource
extends AbstractJaxRSResource {
    private static final Log logger = LogFactory.getLog(SystemResource.class);
    private ISystemConfig systemConfig;
    private IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);

    public SystemResource() {
        this((ISystemConfig)PentahoSystem.get(ISystemConfig.class));
    }

    public SystemResource(ISystemConfig systemConfig) {
        this.systemConfig = systemConfig;
    }

    @GET
    @Produces(value={"application/xml"})
    @Facet(name="Unsupported")
    public Response getAll() throws Exception {
        try {
            if (this.canAdminister()) {
                return Response.ok((Object)SystemService.getSystemService().getAll().asXML()).type("application/xml").build();
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Throwable t) {
            throw new WebApplicationException(t);
        }
    }

    @GET
    @Path(value="/authentication-provider")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public Response getAuthenticationProvider() throws Exception {
        try {
            IConfiguration config = this.systemConfig.getConfiguration("security");
            String provider = config.getProperties().getProperty("provider");
            return Response.ok((Object)new AuthenticationProvider(provider)).type("application/json").build();
        }
        catch (Throwable t) {
            logger.error((Object)Messages.getInstance().getString("SystemResource.GENERAL_ERROR"), t);
            throw new Exception(t);
        }
    }

    @GET
    @Path(value="/timezones")
    @Produces(value={"application/json", "application/xml"})
    @Facet(name="Unsupported")
    public TimeZoneWrapper getTimeZones() {
        HashMap<String, String> timeZones = new HashMap<String, String>();
        for (String tzId : TimeZone.getAvailableIDs()) {
            if (tzId.toLowerCase().contains("gmt")) continue;
            timeZones.put(tzId, this.formatTimezoneIdToDisplayName(tzId));
        }
        return new TimeZoneWrapper(timeZones, TimeZone.getDefault().getID());
    }

    private String formatTimezoneIdToDisplayName(String tzId) {
        int offset = TimeZone.getTimeZone(tzId).getOffset(System.currentTimeMillis());
        String sign = offset >= 0 ? "+" : "-";
        offset = Math.abs(offset);
        String text = String.format("%s%02d%02d", sign, offset / 3600000, offset / 60000 % 60);
        return tzId + " - " + TimeZone.getTimeZone(tzId).getDisplayName(true, 1) + " (UTC" + text + ")";
    }

    @GET
    @Path(value="/locale")
    @Facet(name="Unsupported")
    public Response getLocale() {
        return Response.ok((Object)LocaleHelper.getLocale().toString()).build();
    }

    @POST
    @Path(value="/locale")
    @Facet(name="Unsupported")
    public Response setLocaleOverride(String locale) {
        Locale sessionLocale = null;
        if (!StringUtils.isEmpty((String)locale)) {
            String localeNormalized = locale.replaceAll("[-/]", "_");
            try {
                sessionLocale = LocaleUtils.toLocale((String)localeNormalized);
            }
            catch (IllegalArgumentException ex) {
                return Response.serverError().entity((Object)ex.getMessage()).build();
            }
        }
        IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)PentahoSessionHolder.getSession());
        settingsService.setUserSetting("user_selected_language", locale);
        logger.debug((Object)("Defining language to : " + locale));
        LocaleHelper.setSessionLocaleOverride((Locale)sessionLocale);
        LocaleHelper.setThreadLocaleOverride((Locale)sessionLocale);
        return this.getLocale();
    }

    @Path(value="/executableTypes")
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Facet(name="Unsupported")
    public Response getExecutableTypes() {
        ArrayList<ExecutableFileTypeDto> executableTypes = new ArrayList<ExecutableFileTypeDto>();
        for (String contentType : this.pluginManager.getContentTypes()) {
            IContentInfo contentInfo = this.pluginManager.getContentTypeInfo(contentType);
            ExecutableFileTypeDto executableFileType = new ExecutableFileTypeDto();
            executableFileType.setDescription(contentInfo.getDescription());
            executableFileType.setExtension(contentInfo.getExtension());
            executableFileType.setTitle(contentInfo.getTitle());
            executableFileType.setCanSchedule(this.hasOperationId(contentInfo.getOperations(), "SCHEDULE_NEW"));
            executableFileType.setCanEdit(this.hasOperationId(contentInfo.getOperations(), "EDIT"));
            executableTypes.add(executableFileType);
        }
        GenericEntity<List<ExecutableFileTypeDto>> entity = new GenericEntity<List<ExecutableFileTypeDto>>(executableTypes){};
        return Response.ok((Object)entity).build();
    }

    private boolean hasOperationId(List<IPluginOperation> operations, String operationId) {
        if (operations != null && StringUtils.isNotBlank((String)operationId)) {
            for (IPluginOperation operation : operations) {
                if (operation == null || !StringUtils.isNotBlank((String)operation.getId()) || !operation.getId().equals(operationId) || !StringUtils.isNotBlank((String)operation.getPerspective())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canAdminister() {
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        return policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && policy.isAllowed("org.pentaho.security.administerSecurity");
    }
}

