/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.config.PropertiesFileConfiguration;
import org.pentaho.platform.engine.core.system.PentahoSystem;

@Path(value="/deeplinkAllowedHosts")
public class MantleResource {
    private final Log log = LogFactory.getLog(MantleResource.class);
    private static final List<String> whiteListedHosts = new ArrayList<String>();

    @GET
    @Path(value="/getDeeplinkAllowedHosts")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully sent result."), @ResponseCode(code=500, condition="Failed to get data.")})
    public List<String> getDeeplinkAllowedHosts() {
        return this.getListHosts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getListHosts() {
        if (whiteListedHosts.isEmpty()) {
            File propFile = new File(PentahoSystem.getApplicationContext().getSolutionRootPath() + "/system/deeplink_allowed_urls.properties");
            try {
                PropertiesFileConfiguration config = new PropertiesFileConfiguration("mantle", propFile);
                for (Map.Entry<Object, Object> prop : config.getProperties().entrySet()) {
                    if (!((String)prop.getKey()).startsWith("allowedHost.")) continue;
                    whiteListedHosts.add((String)prop.getValue());
                }
            }
            catch (IOException e) {
                this.log.warn((Object)(propFile.getAbsolutePath() + " not found. Failed during loading of properties. Resetting to default config."), (Throwable)e);
            }
            finally {
                if (whiteListedHosts.isEmpty()) {
                    whiteListedHosts.add("http://localhost");
                }
            }
        }
        return whiteListedHosts;
    }
}

