/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.io.InputStream;
import java.util.Collection;
import javax.ws.rs.FormParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory;
import org.apache.logging.log4j.core.util.Loader;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.owasp.encoder.Encode;
import org.pentaho.platform.api.util.LogUtil;

@Path(value="/logconfig")
public class Log4jResource {
    private static final Logger LOGGER = LogManager.getLogger(Log4jResource.class);
    private static final String CONFIG = "log4j2.xml";

    @PUT
    @Path(value="/reload")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully reload from configuration.")})
    @Produces(value={"text/plain"})
    public Response reloadConfiguration() throws Exception {
        LogUtil.setLevel((Logger)LOGGER, (Level)Level.INFO);
        LOGGER.info("Reloading configuration...");
        InputStream is = Loader.getResourceAsStream((String)CONFIG, (ClassLoader)Loader.getClassLoader());
        ConfigurationSource source = new ConfigurationSource(is);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)true);
        Configuration config = XmlConfigurationFactory.getInstance().getConfiguration(ctx, source);
        ctx.stop();
        ctx.start(config);
        return Response.ok((Object)"Done").build();
    }

    @PUT
    @Path(value="/update")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully update log level."), @ResponseCode(code=304, condition="Log level is not modified.")})
    @Produces(value={"text/plain"})
    public Response updateLogLevel(@FormParam(value="level") String targetLevel, @FormParam(value="category") String category) throws Exception {
        LogUtil.setLevel((Logger)LOGGER, (Level)Level.INFO);
        if (StringUtils.isBlank((String)targetLevel) && StringUtils.isBlank((String)category)) {
            return Response.notModified((String)"No parameter provided, log level not modified.").build();
        }
        Logger root = LogManager.getRootLogger();
        if (StringUtils.isNotBlank((String)targetLevel)) {
            LOGGER.info("Request to set log level: " + targetLevel);
            if (StringUtils.isNotBlank((String)category)) {
                LOGGER.info("Request to set log level for package: " + category);
                if (LogUtil.exists((String)category)) {
                    Logger catLog = LogManager.getLogger((String)category);
                    LogUtil.setLevel((Logger)catLog, (Level)Level.toLevel((String)targetLevel, (Level)root.getLevel()));
                    return Response.ok((Object)("Setting log level for: '" + catLog.getName() + "' to be: " + catLog.getLevel())).build();
                }
                return Response.notModified((String)("Category: '" + Encode.forHtml((String)category) + "' not found, log level not modified.")).build();
            }
            LogUtil.setRootLoggerLevel((Level)Level.toLevel((String)targetLevel, (Level)root.getLevel()));
            LOGGER.info("Root logger level set to: " + root.getLevel());
            LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
            Collection allLoggers = logContext.getLoggers();
            allLoggers.forEach(logger -> LogUtil.setLevel((Logger)logger, (Level)Level.toLevel((String)targetLevel, (Level)root.getLevel())));
        }
        return Response.ok((Object)"Log level updated.").build();
    }
}

