/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.gwt.rpc.support;

import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.platform.web.gwt.rpc.IGwtRpcSerializationPolicyCache;

public class GwtRpcSerializationPolicyCache
implements IGwtRpcSerializationPolicyCache {
    @NonNull
    private final Map<String, SerializationPolicy> serializationPolicyCache = new ConcurrentHashMap<String, SerializationPolicy>();

    @Override
    @NonNull
    public SerializationPolicy getSerializationPolicy(@Nullable String moduleBaseURL, @Nullable String strongName, @NonNull SerializationPolicyProvider sourceProvider) {
        String key = moduleBaseURL + strongName;
        SerializationPolicy serializationPolicy = this.serializationPolicyCache.get(key);
        if (serializationPolicy != null) {
            return serializationPolicy;
        }
        serializationPolicy = sourceProvider.getSerializationPolicy(moduleBaseURL, strongName);
        if (serializationPolicy == null) {
            throw new RuntimeException("Serialization Policy Provider returned null for " + moduleBaseURL + " " + strongName + ".");
        }
        this.serializationPolicyCache.put(key, serializationPolicy);
        return serializationPolicy;
    }
}

