/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.StringUtil;

public class WebUtil {
    static final String ORIGIN_HEADER = "origin";
    static final String CORS_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    static final String CORS_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";

    private WebUtil() {
    }

    public static void setCorsResponseHeaders(HttpServletRequest request, HttpServletResponse response) {
        WebUtil.setCorsResponseHeaders(request, response, null);
    }

    public static void setCorsResponseHeaders(HttpServletRequest request, HttpServletResponse response, Map<String, List<String>> corsHeadersConfiguration) {
        if (!WebUtil.isCorsRequestsAllowed()) {
            return;
        }
        String origin = request.getHeader(ORIGIN_HEADER);
        if (WebUtil.isCorsRequestOriginAllowed(origin)) {
            response.setHeader(CORS_ALLOW_ORIGIN_HEADER, origin);
            response.setHeader(CORS_ALLOW_CREDENTIALS_HEADER, "true");
            if (corsHeadersConfiguration != null) {
                corsHeadersConfiguration.forEach((header, parameters) -> {
                    String value = String.join((CharSequence)",", parameters);
                    response.setHeader(header, value);
                });
            }
        }
    }

    public static boolean isCorsRequestsAllowed() {
        String isCorsAllowed = WebUtil.getCorsRequestsAllowedSystemProperty();
        return "true".equals(isCorsAllowed);
    }

    @VisibleForTesting
    static List<String> getCorsRequestsAllowedOrigins() {
        String allowedDomains = WebUtil.getCorsAllowedOriginsSystemProperty();
        boolean hasDomains = !StringUtil.isEmpty((String)allowedDomains);
        return hasDomains ? Arrays.asList(allowedDomains.split("\\s*,\\s*")) : null;
    }

    @VisibleForTesting
    static boolean isCorsRequestOriginAllowed(String origin) {
        List<String> allowedDomains = WebUtil.getCorsRequestsAllowedOrigins();
        return allowedDomains != null && allowedDomains.contains(origin);
    }

    static String getCorsRequestsAllowedSystemProperty() {
        ISystemConfig systemConfig = (ISystemConfig)PentahoSystem.get(ISystemConfig.class);
        if (systemConfig == null) {
            return "false";
        }
        return systemConfig.getProperty("system.cors-requests-allowed", "false");
    }

    static String getCorsAllowedOriginsSystemProperty() {
        ISystemConfig systemConfig = (ISystemConfig)PentahoSystem.get(ISystemConfig.class);
        if (systemConfig == null) {
            return null;
        }
        return systemConfig.getProperty("system.cors-requests-allowed-domains");
    }
}

