/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole;

import java.io.Serializable;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.cache.EhCacheBasedUserCache;

public class PentahoEhCacheBasedUserCache
extends EhCacheBasedUserCache {
    private static final Log logger = LogFactory.getLog(PentahoEhCacheBasedUserCache.class);
    private boolean caseSensitive = false;

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public UserDetails getUserFromCache(String username) {
        return super.getUserFromCache(this.caseSensitive ? username : username.toLowerCase());
    }

    public void putUserInCache(UserDetails user) {
        Element element = new Element((Serializable)((Object)(this.caseSensitive ? user.getUsername() : user.getUsername().toLowerCase())), (Serializable)user);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + element.getKey()));
        }
        this.getCache().put(element);
    }

    public void removeUserFromCache(String username) {
        super.removeUserFromCache(this.caseSensitive ? username : username.toLowerCase());
    }
}

