/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.perspective.pojo.IPluginPerspective;
import org.pentaho.platform.plugin.services.pluginmgr.SystemPathXmlPluginProvider;
import org.pentaho.platform.plugin.services.pluginmgr.perspective.pojo.DefaultPluginPerspective;
import org.pentaho.ui.xul.XulOverlay;
import org.pentaho.ui.xul.impl.DefaultXulOverlay;

public class PerspectiveUtil {
    public static final int DEFAULT_LAYOUT_PRIORITY = 1000;

    static IPluginPerspective createPerspective(Element perspectiveNode) {
        if (perspectiveNode != null) {
            String title = perspectiveNode.attributeValue("title");
            String id = perspectiveNode.attributeValue("id");
            String contentUrl = perspectiveNode.attributeValue("content-url");
            String resourceBundleUri = perspectiveNode.attributeValue("resourcebundle");
            String layoutPriorityStr = perspectiveNode.attributeValue("layout-priority");
            int layoutPriority = 1000;
            if (layoutPriorityStr != null && layoutPriorityStr.length() > 0) {
                try {
                    layoutPriority = Integer.parseInt(layoutPriorityStr);
                }
                catch (Exception e) {
                    layoutPriority = 1000;
                }
            }
            String securityActionStr = perspectiveNode.attributeValue("required-security-action");
            ArrayList<String> actions = new ArrayList<String>();
            if (securityActionStr != null) {
                StringTokenizer st = new StringTokenizer(securityActionStr, ";, ");
                while (st.hasMoreTokens()) {
                    String action = st.nextToken();
                    actions.add(action);
                }
            }
            ArrayList<XulOverlay> overlays = PerspectiveUtil.processOverlays(perspectiveNode);
            DefaultPluginPerspective perspective = new DefaultPluginPerspective();
            perspective.setTitle(title);
            perspective.setId(id);
            perspective.setContentUrl(contentUrl);
            perspective.setLayoutPriority(layoutPriority);
            perspective.setOverlays(overlays);
            perspective.setRequiredSecurityActions(actions);
            perspective.setResourceBundleUri(resourceBundleUri);
            return perspective;
        }
        return null;
    }

    private static ArrayList<XulOverlay> processOverlays(Element node) {
        if (node == null) {
            return null;
        }
        ArrayList<XulOverlay> overlays = new ArrayList<XulOverlay>();
        List overlayElements = node.selectNodes("overlay");
        for (Node overlayNode : overlayElements) {
            DefaultXulOverlay overlay = SystemPathXmlPluginProvider.processOverlay((Element)overlayNode);
            if (overlay == null) continue;
            overlays.add((XulOverlay)overlay);
        }
        return overlays;
    }
}

