/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.metadata;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metadata.util.SecurityHelper;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.ILogoutListener;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.metadata.IAclAwarePentahoMetadataDomainRepositoryImporter;
import org.pentaho.platform.plugin.services.metadata.IDataSourceAwareMetadataDomainRepository;
import org.pentaho.platform.plugin.services.metadata.IModelAnnotationsAwareMetadataDomainRepositoryImporter;
import org.pentaho.platform.plugin.services.metadata.IPentahoMetadataDomainRepositoryExporter;
import org.pentaho.platform.plugin.services.metadata.IPentahoMetadataDomainRepositoryImporter;
import org.pentaho.platform.plugin.services.metadata.PentahoDataSourceType;

public class SessionCachingMetadataDomainRepository
implements IMetadataDomainRepository,
IPentahoMetadataDomainRepositoryExporter,
ILogoutListener,
IAclAwarePentahoMetadataDomainRepositoryImporter,
IModelAnnotationsAwareMetadataDomainRepositoryImporter,
IDataSourceAwareMetadataDomainRepository {
    private static final Log logger = LogFactory.getLog(SessionCachingMetadataDomainRepository.class);
    public static String CACHE_REGION = "metadata-domain-repository";
    static final int DEFAULT_NUMBER_OF_THREADS = 3;
    ICacheManager cacheManager;
    boolean domainIdsCacheEnabled = true;
    int numberOfThreads = 3;
    private final IMetadataDomainRepository delegate;
    private static final String DOMAIN_CACHE_KEY_PREDICATE = "domain-id-cache-for-session:";
    protected final CacheIteratorCallback REMOVE_ALL_CALLBACK = new CacheIteratorCallback(){

        @Override
        public Boolean call(ICacheManager cacheManager, CacheKey key) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing domain from cache: " + key));
            }
            cacheManager.removeFromRegionCache(CACHE_REGION, (Object)key);
            return true;
        }
    };

    public SessionCachingMetadataDomainRepository(IMetadataDomainRepository delegate) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
        this.cacheManager = PentahoSystem.getCacheManager(null);
        if (this.cacheManager != null && !this.cacheManager.cacheEnabled(CACHE_REGION) && !this.cacheManager.addCacheRegion(CACHE_REGION)) {
            this.cacheManager = null;
        }
        if (this.cacheManager == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " (" + CACHE_REGION + ") cannot be initialized");
        }
        PentahoSystem.addLogoutListener((ILogoutListener)this);
        ISystemConfig systemConfig = (ISystemConfig)PentahoSystem.get(ISystemConfig.class);
        if (systemConfig != null) {
            String enableDomainIdCache = systemConfig.getProperty("system.enableDomainIdCache");
            this.domainIdsCacheEnabled = enableDomainIdCache == null || Boolean.valueOf(enableDomainIdCache) != false;
            this.numberOfThreads = this.getNumberOfThreads(systemConfig);
        }
    }

    public SessionCachingMetadataDomainRepository(IMetadataDomainRepository delegate, ICacheManager cacheManager, boolean domainIdsCacheEnabled, int numberOfThreads) {
        this.delegate = delegate;
        this.cacheManager = cacheManager;
        this.domainIdsCacheEnabled = domainIdsCacheEnabled;
        this.numberOfThreads = numberOfThreads;
    }

    int getNumberOfThreads(ISystemConfig systemConfig) {
        int convertedNumber = NumberUtils.toInt((String)systemConfig.getProperty("system.number-threads"));
        return convertedNumber < 1 ? 3 : convertedNumber;
    }

    protected void forAllKeys(CacheIteratorCallback callback) {
        block4: {
            try {
                Set cachedObjects = this.cacheManager.getAllKeysFromRegionCache(CACHE_REGION);
                if (cachedObjects != null) {
                    CacheKey key;
                    Object k;
                    Iterator iterator = cachedObjects.iterator();
                    while (!(!iterator.hasNext() || (k = iterator.next()) instanceof CacheKey && Boolean.FALSE.equals(callback.call(this.cacheManager, key = (CacheKey)k)))) {
                    }
                }
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)"", e);
            }
        }
    }

    protected void forAllKeysInSession(final IPentahoSession session, final CacheIteratorCallback callback) {
        this.forAllKeys(new CacheIteratorCallback(){

            @Override
            public Boolean call(ICacheManager cacheManager, CacheKey key) {
                if ((session.getId() == null ? key.sessionId == null : session.getId().equals(key.sessionId)) && Boolean.FALSE.equals(callback.call(cacheManager, key))) {
                    return false;
                }
                return true;
            }
        });
    }

    public Domain getDomain(String id) {
        IPentahoSession session = PentahoSessionHolder.getSession();
        CacheKey key = new CacheKey(session.getId(), id);
        Domain domain = (Domain)this.cacheManager.getFromRegionCache(CACHE_REGION, (Object)key);
        if (domain != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found domain in cache: " + key));
            }
            if (this.delegate instanceof IAclAwarePentahoMetadataDomainRepositoryImporter && !((IAclAwarePentahoMetadataDomainRepositoryImporter)this.delegate).hasAccessFor(id)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("User no longer has access to Domain, purging from session cache: " + key));
                }
                this.purgeDomain(domain.getId());
                domain = null;
            }
            return domain;
        }
        domain = this.delegate.getDomain(id);
        if (domain != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Requested Domain wasn't in Session Cache, but was found in the delegating repository: " + id));
            }
            SecurityHelper helper = new SecurityHelper();
            domain = helper.createSecureDomain((IMetadataDomainRepository)this, domain);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Caching domain by session: " + key));
            }
            this.cacheManager.putInRegionCache(CACHE_REGION, (Object)key, (Object)domain);
        }
        return domain;
    }

    private void purgeDomain(final String domainId) {
        this.forAllKeys(new CacheIteratorCallback(){

            @Override
            public Boolean call(ICacheManager cacheManager, CacheKey key) {
                if (domainId == null ? key.domainId == null : domainId.equals(key.domainId)) {
                    cacheManager.removeFromRegionCache(CACHE_REGION, (Object)key);
                }
                return true;
            }
        });
        this.removeDomainFromIDCache(domainId);
    }

    public void reloadDomains() {
        this.forAllKeys(this.REMOVE_ALL_CALLBACK);
        this.clearDomainIdsFromCache();
        this.delegate.reloadDomains();
    }

    public void flushDomains() {
        this.forAllKeys(this.REMOVE_ALL_CALLBACK);
        this.clearDomainIdsFromCache();
        this.delegate.flushDomains();
    }

    protected void flushDomains(IPentahoSession session) {
        this.forAllKeysInSession(session, this.REMOVE_ALL_CALLBACK);
        this.clearDomainIdsFromCache(session);
    }

    protected void clearDomainIdsFromCache() {
        block4: {
            try {
                Set cachedObjects = this.cacheManager.getAllKeysFromRegionCache(CACHE_REGION);
                if (cachedObjects != null) {
                    for (Object k : cachedObjects) {
                        String key;
                        if (!(k instanceof String) || (key = (String)k) == null || !key.startsWith(DOMAIN_CACHE_KEY_PREDICATE)) continue;
                        this.cacheManager.removeFromRegionCache(CACHE_REGION, (Object)key);
                    }
                }
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)"", e);
            }
        }
    }

    protected void clearDomainIdsFromCache(IPentahoSession session) {
        String key = this.generateDomainIdCacheKeyForSession(session);
        if (this.cacheManager.getFromRegionCache(CACHE_REGION, (Object)key) != null) {
            this.cacheManager.removeFromRegionCache(CACHE_REGION, (Object)key);
        }
    }

    private boolean removeDomainFromIDCache(Set<String> domainIds) {
        boolean dirtyCache = false;
        for (String domainId : domainIds) {
            if (!(this.delegate instanceof IAclAwarePentahoMetadataDomainRepositoryImporter) || ((IAclAwarePentahoMetadataDomainRepositoryImporter)this.delegate).hasAccessFor(domainId)) continue;
            domainIds.remove(domainId);
            this.removeDomainFromIDCache(domainId);
            dirtyCache = true;
        }
        return dirtyCache;
    }

    private void removeDomainFromIDCache(String domainId) {
        block4: {
            try {
                Set cachedObjects = this.cacheManager.getAllKeysFromRegionCache(CACHE_REGION);
                if (cachedObjects != null) {
                    for (Object k : cachedObjects) {
                        String key;
                        if (!(k instanceof String) || (key = (String)k) == null || !key.startsWith(DOMAIN_CACHE_KEY_PREDICATE)) continue;
                        Set domainIds = (Set)this.cacheManager.getFromRegionCache(CACHE_REGION, (Object)key);
                        domainIds.remove(domainId);
                        this.cacheManager.putInRegionCache(CACHE_REGION, (Object)key, (Object)domainIds);
                    }
                }
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)"", e);
            }
        }
    }

    protected String generateDomainIdCacheKeyForSession(IPentahoSession session) {
        return DOMAIN_CACHE_KEY_PREDICATE + session.getId();
    }

    protected String generateDomainIdCacheKeyForSession(IPentahoSession session, String type) {
        return DOMAIN_CACHE_KEY_PREDICATE + type + ":" + session.getId();
    }

    @Override
    public void removeDomain(String domainId) {
        this.delegate.removeDomain(domainId);
        this.purgeDomain(domainId);
        this.removeDomainFromIDCache(domainId);
    }

    public void storeDomain(Domain domain, boolean overwrite) throws DomainIdNullException, DomainAlreadyExistsException, DomainStorageException {
        this.delegate.storeDomain(domain, overwrite);
        this.purgeDomain(domain.getId());
        this.clearDomainIdsFromCache();
    }

    public void removeModel(String domainId, String modelId) throws DomainIdNullException, DomainStorageException {
        this.delegate.removeModel(domainId, modelId);
        this.purgeDomain(domainId);
    }

    public Set<String> getDomainIds() {
        return this.getDomainIds(PentahoSessionHolder.getSession());
    }

    Set<String> getDomainIds(IPentahoSession pentahoSession) {
        String domainKey = this.generateDomainIdCacheKeyForSession(pentahoSession);
        return this.getDomainIdsHelper(pentahoSession, domainKey, () -> ((IMetadataDomainRepository)this.delegate).getDomainIds());
    }

    @Override
    public Set<String> getMetadataDomainIds() {
        return this.getMetadataDomainIds(PentahoSessionHolder.getSession());
    }

    Set<String> getMetadataDomainIds(IPentahoSession pentahoSession) {
        if (this.delegate instanceof IDataSourceAwareMetadataDomainRepository) {
            String domainKey = this.generateDomainIdCacheKeyForSession(pentahoSession, PentahoDataSourceType.METADATA.toString());
            return this.getDomainIdsHelper(pentahoSession, domainKey, ((IDataSourceAwareMetadataDomainRepository)this.delegate)::getMetadataDomainIds);
        }
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public Set<String> getDataSourceWizardDomainIds() {
        return this.getDataSourceWizardDomainIds(PentahoSessionHolder.getSession());
    }

    Set<String> getDataSourceWizardDomainIds(IPentahoSession pentahoSession) {
        if (this.delegate instanceof IDataSourceAwareMetadataDomainRepository) {
            String domainKey = this.generateDomainIdCacheKeyForSession(pentahoSession, PentahoDataSourceType.DATA_SOURCE_WIZARD.toString());
            return this.getDomainIdsHelper(pentahoSession, domainKey, ((IDataSourceAwareMetadataDomainRepository)this.delegate)::getDataSourceWizardDomainIds);
        }
        throw new UnsupportedOperationException("not supported");
    }

    Set<String> getDomainIdsHelper(IPentahoSession session, String domainKey, Supplier<Set<String>> delegateGetDomainIds) {
        Set<String> domainIds = this.getDomainIdsFromCache(domainKey, delegateGetDomainIds);
        this.asyncPopulateCacheDomain(domainIds, session);
        return domainIds;
    }

    Set<String> getDomainIdsFromCache(String domainKey, Supplier<Set<String>> delegateGetDomainIds) {
        Set<String> domainIds;
        if (this.domainIdsCacheEnabled) {
            domainIds = (Set<String>)this.cacheManager.getFromRegionCache(CACHE_REGION, (Object)domainKey);
            if (domainIds != null) {
                boolean dirtyCache = this.removeDomainFromIDCache(domainIds);
                if (dirtyCache) {
                    this.cacheManager.putInRegionCache(CACHE_REGION, (Object)domainKey, new HashSet<String>(domainIds));
                }
                return domainIds;
            }
        } else {
            this.delegate.reloadDomains();
        }
        domainIds = delegateGetDomainIds.get();
        if (this.domainIdsCacheEnabled) {
            this.cacheManager.putInRegionCache(CACHE_REGION, (Object)domainKey, new HashSet<String>(domainIds));
        }
        return domainIds;
    }

    public String generateRowLevelSecurityConstraint(LogicalModel model) {
        return this.delegate.generateRowLevelSecurityConstraint(model);
    }

    public boolean hasAccess(int accessType, IConcept aclHolder) {
        return this.delegate.hasAccess(accessType, aclHolder);
    }

    public void onLogout(IPentahoSession session) {
        this.flushDomains(session);
    }

    @Override
    public Map<String, InputStream> getDomainFilesData(String domainId) {
        if (this.delegate instanceof IPentahoMetadataDomainRepositoryExporter) {
            return ((IPentahoMetadataDomainRepositoryExporter)this.delegate).getDomainFilesData(domainId);
        }
        throw new UnsupportedOperationException("Exporting is not supported by this Metadata Domain Repository");
    }

    @Override
    public void storeDomain(InputStream inputStream, String domainId, boolean overwrite, RepositoryFileAcl acl) throws DomainIdNullException, DomainAlreadyExistsException, DomainStorageException {
        if (this.delegate instanceof IAclAwarePentahoMetadataDomainRepositoryImporter) {
            ((IAclAwarePentahoMetadataDomainRepositoryImporter)this.delegate).storeDomain(inputStream, domainId, overwrite, acl);
        }
    }

    @Override
    public void setAclFor(String domainId, RepositoryFileAcl acl) {
        if (this.delegate instanceof IAclAwarePentahoMetadataDomainRepositoryImporter) {
            ((IAclAwarePentahoMetadataDomainRepositoryImporter)this.delegate).setAclFor(domainId, acl);
        }
    }

    @Override
    public RepositoryFileAcl getAclFor(String domainId) {
        if (this.delegate instanceof IAclAwarePentahoMetadataDomainRepositoryImporter) {
            return ((IAclAwarePentahoMetadataDomainRepositoryImporter)this.delegate).getAclFor(domainId);
        }
        return null;
    }

    @Override
    public boolean hasAccessFor(String domainId) {
        return !(this.delegate instanceof IAclAwarePentahoMetadataDomainRepositoryImporter) || ((IAclAwarePentahoMetadataDomainRepositoryImporter)this.delegate).hasAccessFor(domainId);
    }

    @Override
    public void storeDomain(InputStream inputStream, String domainId, boolean overwrite) throws DomainIdNullException, DomainAlreadyExistsException, DomainStorageException {
        if (this.delegate instanceof IPentahoMetadataDomainRepositoryImporter) {
            ((IAclAwarePentahoMetadataDomainRepositoryImporter)this.delegate).storeDomain(inputStream, domainId, overwrite);
        }
    }

    @Override
    public void addLocalizationFile(String domainId, String locale, InputStream inputStream, boolean overwrite) throws DomainStorageException {
        if (this.delegate instanceof IPentahoMetadataDomainRepositoryImporter) {
            ((IAclAwarePentahoMetadataDomainRepositoryImporter)this.delegate).addLocalizationFile(domainId, locale, inputStream, overwrite);
        }
    }

    @Override
    public String loadAnnotationsXml(String domainId) {
        if (this.delegate instanceof IModelAnnotationsAwareMetadataDomainRepositoryImporter) {
            return ((IModelAnnotationsAwareMetadataDomainRepositoryImporter)this.delegate).loadAnnotationsXml(domainId);
        }
        return null;
    }

    @Override
    public void storeAnnotationsXml(String domainId, String annotationsXml) {
        if (this.delegate instanceof IModelAnnotationsAwareMetadataDomainRepositoryImporter) {
            ((IModelAnnotationsAwareMetadataDomainRepositoryImporter)this.delegate).storeAnnotationsXml(domainId, annotationsXml);
        }
    }

    Thread asyncPopulateCacheDomain(Collection<String> domainIds, IPentahoSession pentahoSession) {
        PentahoAsyncThreadRunner patr = new PentahoAsyncThreadRunner(this.numberOfThreads, pentahoSession);
        return this.asyncPopulateCacheDomain(patr, this.createCallablesGetDomain(this, domainIds, pentahoSession.getId()));
    }

    Thread asyncPopulateCacheDomain(PentahoAsyncThreadRunner pentahoAsyncThreadRunner, Collection<GetDomainCallable> callables) {
        return pentahoAsyncThreadRunner.asyncRun(callables);
    }

    Collection<GetDomainCallable> createCallablesGetDomain(IMetadataDomainRepository repository, Collection<String> domainIds, String sessionId) {
        return Optional.ofNullable(domainIds).orElseGet(Collections::emptyList).stream().map(id -> new GetDomainCallable(repository, (String)id, sessionId, logger)).collect(Collectors.toList());
    }

    public static class PentahoSessionThread
    extends Thread {
        public PentahoSessionThread(Runnable target, IPentahoSession pentahoSession) {
            super(target);
            PentahoSessionHolder.setSession((IPentahoSession)pentahoSession);
        }
    }

    public static class PentahoAsyncThreadRunner {
        private static final Log logger = LogFactory.getLog(PentahoAsyncThreadRunner.class);
        int numberOfThreads;
        IPentahoSession pentahoSession;
        private final String threadExecutorNamingPattern;
        private final String threadMasterName;
        private static final String DEFAULT_THREAD_NAMING_PATTERN = "pentaho-runner-exec-%d";
        private static final String DEFAULT_THREAD_MASTER_NAME = "pentaho-runner-master";

        public PentahoAsyncThreadRunner(int numberOfThreads, IPentahoSession pentahoSession, String threadMasterName, String threadExecutorNamingPattern) {
            this.numberOfThreads = numberOfThreads;
            this.pentahoSession = pentahoSession;
            this.threadMasterName = threadMasterName;
            this.threadExecutorNamingPattern = threadExecutorNamingPattern;
        }

        public PentahoAsyncThreadRunner(int numberOfThreads, IPentahoSession pentahoSession) {
            this(numberOfThreads, pentahoSession, DEFAULT_THREAD_MASTER_NAME, DEFAULT_THREAD_NAMING_PATTERN);
        }

        ExecutorService createExecutorService() {
            BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern(this.threadExecutorNamingPattern).wrappedFactory(r -> new PentahoSessionThread(r, this.pentahoSession)).build();
            ExecutorService executorService = Executors.newFixedThreadPool(this.numberOfThreads, (ThreadFactory)threadFactory);
            logger.debug((Object)String.format("creating executorService with number of threads: %d and Pentaho sessionId: %s", this.numberOfThreads, this.pentahoSession.getId()));
            return executorService;
        }

        public <T> Thread asyncRun(Collection<? extends Callable<T>> tasks) {
            return this.asyncRun(this::createExecutorService, tasks);
        }

        <T> Thread asyncRun(Supplier<? extends ExecutorService> fnCreateExecutorService, Collection<? extends Callable<T>> tasks) {
            if (tasks == null) {
                return null;
            }
            Thread thread = new Thread(() -> {
                ExecutorService executorService = (ExecutorService)fnCreateExecutorService.get();
                this.executeTasks(executorService, tasks);
                executorService.shutdown();
            }, this.threadMasterName);
            thread.start();
            return thread;
        }

        <T> Collection<T> executeTasks(ExecutorService executorService, Collection<? extends Callable<T>> tasks) {
            HashSet successfulTaskReturns = new HashSet();
            try {
                logger.debug((Object)String.format("start executeTasks(executorService: %s, size(tasks): %d)", executorService.hashCode(), tasks.size()));
                List futures = executorService.invokeAll(tasks);
                for (Future future : futures) {
                    Object returnValue = this.futureGet(future);
                    if (returnValue == null) continue;
                    successfulTaskReturns.add(returnValue);
                    logger.debug((Object)String.format("successful callable executeTasks(executorService: %s, size(tasks): %d) return value: %s", executorService.hashCode(), tasks.size(), returnValue));
                }
                logger.debug((Object)String.format("end executeTasks(executorService: %s, size(tasks): %d)  with size(successfulTaskReturns): %d ", executorService.hashCode(), tasks.size(), successfulTaskReturns.size()));
            }
            catch (InterruptedException ie) {
                logger.error((Object)"Error in invokeAll tasks", (Throwable)ie);
                Thread.currentThread().interrupt();
            }
            return successfulTaskReturns;
        }

        <T> T futureGet(Future<T> future) {
            T returnValue = null;
            try {
                returnValue = future.get();
            }
            catch (InterruptedException ie) {
                logger.error((Object)"Error - InterruptedException in executing task", (Throwable)ie);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ee) {
                logger.error((Object)"Error - ExecutionException in executing task", (Throwable)ee);
            }
            return returnValue;
        }
    }

    public static class GetDomainCallable
    implements Callable<String> {
        IMetadataDomainRepository repository;
        String domainId;
        String sessionId;
        Log log;

        public GetDomainCallable(IMetadataDomainRepository repository, String domainId, String sessionId, Log log) {
            this.repository = repository;
            this.domainId = domainId;
            this.sessionId = sessionId;
            this.log = log;
        }

        @Override
        public String call() throws Exception {
            this.log.debug((Object)String.format("start thread #getDomain(domainId=%s) with sessionId=%s", this.domainId, this.sessionId));
            Domain domain = this.repository.getDomain(this.domainId);
            if (domain == null) {
                this.log.error((Object)String.format("Error #getDomain(domainId=%s) with sessionId=%s -> null in GetDomainCallable#call", this.domainId, this.sessionId));
            }
            this.log.debug((Object)String.format("finished thread #getDomain(domainId=%s) with sessionId=%s", this.domainId, this.sessionId));
            return domain != null ? domain.getId() : null;
        }

        public String getDomainId() {
            return this.domainId;
        }
    }

    protected static interface CacheIteratorCallback {
        public Boolean call(ICacheManager var1, CacheKey var2);
    }

    public static class CacheKey
    implements Serializable {
        private static final long serialVersionUID = 1737869846319540136L;
        public String sessionId;
        public String domainId;

        protected CacheKey() {
        }

        public CacheKey(String sessionId, String domainId) {
            this.sessionId = sessionId;
            this.domainId = domainId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.domainId != null ? !this.domainId.equals(cacheKey.domainId) : cacheKey.domainId != null) {
                return false;
            }
            return !(this.sessionId != null ? !this.sessionId.equals(cacheKey.sessionId) : cacheKey.sessionId != null);
        }

        public int hashCode() {
            int result = this.sessionId != null ? this.sessionId.hashCode() : 0;
            result = 31 * result + (this.domainId != null ? this.domainId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "(" + this.sessionId + "," + this.domainId + ")";
        }
    }
}

