/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.metadata;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metadata.util.LocalizationUtil;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository2.unified.IAclNodeHelper;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.metadata.IAclAwarePentahoMetadataDomainRepositoryImporter;
import org.pentaho.platform.plugin.services.metadata.IDataSourceAwareMetadataDomainRepository;
import org.pentaho.platform.plugin.services.metadata.IModelAnnotationsAwareMetadataDomainRepositoryImporter;
import org.pentaho.platform.plugin.services.metadata.IPentahoMetadataDomainRepositoryExporter;
import org.pentaho.platform.plugin.services.metadata.PentahoDataSourceType;
import org.pentaho.platform.plugin.services.metadata.PentahoDataSourceTypeMap;
import org.pentaho.platform.plugin.services.metadata.PentahoMetadataDomainRepositoryInfo;
import org.pentaho.platform.plugin.services.metadata.PentahoMetadataInformationMap;
import org.pentaho.platform.repository2.unified.RepositoryUtils;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileInputStream;
import org.pentaho.platform.repository2.unified.jcr.JcrAclNodeHelper;

public class PentahoMetadataDomainRepository
implements IMetadataDomainRepository,
IModelAnnotationsAwareMetadataDomainRepositoryImporter,
IAclAwarePentahoMetadataDomainRepositoryImporter,
IPentahoMetadataDomainRepositoryExporter,
IDataSourceAwareMetadataDomainRepository {
    private static final Log logger = LogFactory.getLog(PentahoMetadataDomainRepository.class);
    private static final Messages messages = Messages.getInstance();
    private static final Map<IUnifiedRepository, PentahoMetadataInformationMap> metaMapStore = new HashMap<IUnifiedRepository, PentahoMetadataInformationMap>();
    static final String PROPERTY_NAME_TYPE = "file-type";
    static final String TYPE_DOMAIN = "domain";
    static final String TYPE_LOCALE = "locale";
    static final String PROPERTY_NAME_DOMAIN_ID = "domain-id";
    static final String PROPERTY_NAME_LOCALE = "locale";
    static final String PROPERTY_NAME_DATASOURCE_TYPE = "datasource-type";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DOMAIN_MIME_TYPE = "text/xml";
    private static final String LOCALE_MIME_TYPE = "text/plain";
    private static final String XMI_EXTENSION = ".xmi";
    private static final EnumSet<RepositoryFilePermission> READ = EnumSet.of(RepositoryFilePermission.READ);
    private IUnifiedRepository repository;
    private final PentahoMetadataInformationMap metadataMapping;
    private final PentahoDataSourceTypeMap dataSourceTypeMapping;
    private XmiParser xmiParser;
    private RepositoryUtils repositoryUtils;
    private LocalizationUtil localizationUtil;
    private IAclNodeHelper aclHelper;
    private final ReentrantReadWriteLock lock;
    private boolean needToReload;
    private static final String ERROR_0005_ERROR_RETRIEVING_DOMAIN = "PentahoMetadataDomainRepository.ERROR_0005_ERROR_RETRIEVING_DOMAIN";
    private static final String ERROR_0004_DOMAIN_ID_INVALID = "PentahoMetadataDomainRepository.ERROR_0004_DOMAIN_ID_INVALID";

    public PentahoMetadataDomainRepository(IUnifiedRepository repository) {
        this(repository, null, null, null);
    }

    protected PentahoMetadataDomainRepository(IUnifiedRepository repository, RepositoryUtils repositoryUtils, XmiParser xmiParser, LocalizationUtil localizationUtil) {
        if (null == repository) {
            throw new IllegalArgumentException();
        }
        this.metadataMapping = PentahoMetadataDomainRepository.getMetadataMapping(repository);
        this.dataSourceTypeMapping = new PentahoDataSourceTypeMap();
        this.setRepository(repository);
        this.setRepositoryUtils(repositoryUtils);
        this.setLocalizationUtil(localizationUtil);
        this.setXmiParser(xmiParser);
        this.lock = new ReentrantReadWriteLock();
        this.needToReload = true;
    }

    public void storeDomain(Domain domain, boolean overwrite) throws DomainIdNullException, DomainAlreadyExistsException, DomainStorageException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("storeDomain(domain(id=" + (domain != null ? domain.getId() : "") + ", " + overwrite + ")"));
        }
        if (null == domain || StringUtils.isEmpty((CharSequence)domain.getId())) {
            throw new DomainIdNullException(messages.getErrorString("PentahoMetadataDomainRepository.ERROR_0001_DOMAIN_ID_NULL"));
        }
        String xmi = "";
        try {
            xmi = this.xmiParser.generateXmi(domain);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xmi.getBytes("UTF8"));
            this.storeDomain(inputStream, domain.getId(), overwrite);
        }
        catch (DomainStorageException dse) {
            throw dse;
        }
        catch (DomainAlreadyExistsException dae) {
            throw dae;
        }
        catch (Exception e) {
            String errorMessage = messages.getErrorString("PentahoMetadataDomainRepository.ERROR_0003_ERROR_STORING_DOMAIN", new Object[]{domain.getId(), e.getLocalizedMessage()});
            logger.error((Object)errorMessage, (Throwable)e);
            throw new DomainStorageException(xmi + errorMessage, e);
        }
    }

    protected String endsWithXmi(String value) {
        if (value.endsWith(XMI_EXTENSION)) {
            return value;
        }
        return value + XMI_EXTENSION;
    }

    protected String noXmi(String value) {
        if (value.endsWith(XMI_EXTENSION)) {
            return value.substring(0, value.length() - 4);
        }
        return value;
    }

    protected String replaceDomainId(StringBuilder sb, String domainId) {
        int datasourceModelTagPosition = sb.indexOf("datasourceModel");
        if (datasourceModelTagPosition != -1) {
            String xmiDomainId = this.endsWithXmi(domainId);
            String noXmiDomainId = StringEscapeUtils.escapeXml((String)this.noXmi(domainId));
            String tag = "<CWM:Description body=";
            int startTagPosition = sb.indexOf(tag, datasourceModelTagPosition);
            int startPosition = startTagPosition + tag.length() + 1;
            int endPosition = sb.indexOf("\"", startPosition);
            String oldDomainId = sb.substring(startPosition, endPosition);
            sb.delete(startPosition, endPosition);
            if (oldDomainId.endsWith(XMI_EXTENSION)) {
                sb.insert(startPosition, xmiDomainId);
            } else {
                sb.insert(startPosition, noXmiDomainId);
            }
            return xmiDomainId;
        }
        return domainId;
    }

    protected String getDomainIdFromXmi(StringBuilder sb) {
        int startPosition;
        int endPosition;
        String tag;
        int startTagPosition;
        int datasourceModelTagPosition = sb.indexOf("datasourceModel");
        if (datasourceModelTagPosition != -1 && (startTagPosition = sb.indexOf(tag = "<CWM:Description body=", datasourceModelTagPosition)) != -1 && (endPosition = sb.indexOf("\"", startPosition = startTagPosition + tag.length() + 1)) != -1) {
            return StringEscapeUtils.unescapeXml((String)sb.substring(startPosition, endPosition));
        }
        return null;
    }

    protected boolean isDomainIdXmiEqualsOrNotPresent(String domainId, String domainIdXmi) {
        return domainIdXmi == null || this.noXmi(domainIdXmi).equals(this.noXmi(domainId));
    }

    @Override
    public void storeDomain(InputStream inputStream, String domainId, boolean overwrite) throws DomainIdNullException, DomainAlreadyExistsException, DomainStorageException {
        this.storeDomain(inputStream, domainId, overwrite, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDomain(InputStream inputStream, String domainId, boolean overwrite, RepositoryFileAcl acl) throws DomainIdNullException, DomainAlreadyExistsException, DomainStorageException {
        ByteArrayInputStream inputStream2;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("storeDomain(inputStream, %s, %s, %s)", domainId, overwrite, acl));
        }
        if (null == inputStream) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isEmpty((CharSequence)domainId)) {
            throw new DomainIdNullException(messages.getErrorString("PentahoMetadataDomainRepository.ERROR_0001_DOMAIN_ID_NULL"));
        }
        RepositoryFile domainFile = this.getMetadataRepositoryFile(domainId);
        if (domainFile == null && domainId.endsWith(XMI_EXTENSION)) {
            domainFile = this.getMetadataRepositoryFile(domainId.substring(0, domainId.length() - XMI_EXTENSION.length()));
        }
        if (!overwrite && domainFile != null) {
            String errorString = messages.getErrorString("PentahoMetadataDomainRepository.ERROR_0002_DOMAIN_ALREADY_EXISTS", new Object[]{domainId});
            logger.error((Object)errorString);
            throw new DomainAlreadyExistsException(errorString);
        }
        try {
            String xmi;
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, DEFAULT_ENCODING));
            try {
                while ((xmi = reader.readLine()) != null) {
                    stringBuilder.append(xmi);
                }
            }
            finally {
                inputStream.close();
            }
            if (!this.isDomainIdXmiEqualsOrNotPresent(domainId, this.getDomainIdFromXmi(stringBuilder))) {
                domainId = this.replaceDomainId(stringBuilder, domainId);
            }
            xmi = stringBuilder.toString();
            byte[] xmiBytes = xmi.getBytes(DEFAULT_ENCODING);
            inputStream2 = new ByteArrayInputStream(xmiBytes);
            this.xmiParser.parseXmi((InputStream)inputStream2);
            ((InputStream)inputStream2).reset();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ex.printStackTrace(new PrintStream(byteArrayOutputStream));
            throw new DomainStorageException(byteArrayOutputStream.toString(), ex);
        }
        SimpleRepositoryFileData data = new SimpleRepositoryFileData((InputStream)inputStream2, DEFAULT_ENCODING, DOMAIN_MIME_TYPE);
        RepositoryFile newDomainFile = domainFile == null ? this.createUniqueFile(domainId, null, data) : this.updateFile(domainFile, data);
        this.flushDomains();
        this.getAclHelper().setAclFor(newDomainFile, acl);
    }

    protected synchronized IAclNodeHelper getAclHelper() {
        if (this.aclHelper == null) {
            this.aclHelper = new JcrAclNodeHelper(this.repository);
        }
        return this.aclHelper;
    }

    @Override
    public void setAclFor(String domainId, RepositoryFileAcl acl) {
        this.getAclHelper().setAclFor(this.getMetadataRepositoryFile(domainId), acl);
    }

    @Override
    public RepositoryFileAcl getAclFor(String domainId) {
        return this.getAclHelper().getAclFor(this.getMetadataRepositoryFile(domainId));
    }

    @Override
    public boolean hasAccessFor(String domainId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking access for: " + domainId));
        }
        return this.getAclHelper().canAccess(this.getMetadataRepositoryFile(domainId), READ);
    }

    private boolean hasAccessFor(RepositoryFile repositoryFile) {
        return this.getAclHelper().canAccess(repositoryFile, READ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, InputStream> getDomainFilesData(String domainId) {
        this.lock.readLock().lock();
        try {
            if (!this.metadataMapping.getDomainIds().contains(domainId)) {
                Map<String, InputStream> map = Collections.emptyMap();
                return map;
            }
            Map<String, InputStream> localeFiles = Optional.ofNullable(this.metadataMapping.getLocaleFiles(domainId)).orElse(Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(entry -> "messages_" + (String)entry.getKey() + ".properties", item -> this.getRepositoryFileInputStream((RepositoryFile)item.getValue())));
            HashMap<String, InputStream> map = new HashMap<String, InputStream>(localeFiles);
            map.put(this.getXmiFilename(domainId), (InputStream)this.getRepositoryFileInputStream(this.metadataMapping.getDomainFile(domainId)));
            HashMap<String, InputStream> hashMap = map;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private String getXmiFilename(String domainId) {
        return domainId + (domainId.endsWith(XMI_EXTENSION) ? "" : XMI_EXTENSION);
    }

    private RepositoryFileInputStream getRepositoryFileInputStream(RepositoryFile file) {
        try {
            return new RepositoryFileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain getDomain(String domainId) {
        Domain domain;
        block9: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getDomain(" + domainId + ")"));
            }
            if (StringUtils.isEmpty((CharSequence)domainId)) {
                throw new IllegalArgumentException(messages.getErrorString(ERROR_0004_DOMAIN_ID_INVALID, new Object[]{domainId}));
            }
            domain = null;
            try {
                RepositoryFile file = this.getMetadataRepositoryFile(domainId);
                if (file == null) break block9;
                if (this.hasAccessFor(file)) {
                    SimpleRepositoryFileData data = (SimpleRepositoryFileData)this.repository.getDataForRead(file.getId(), SimpleRepositoryFileData.class);
                    if (data != null) {
                        InputStream is = data.getStream();
                        try {
                            domain = this.xmiParser.parseXmi(is);
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)is);
                        }
                        domain.setId(domainId);
                        logger.debug((Object)"loaded domain");
                        this.loadLocaleStrings(domainId, domain);
                        logger.debug((Object)"loaded I18N bundles");
                        break block9;
                    }
                    throw new UnifiedRepositoryException(messages.getErrorString(ERROR_0005_ERROR_RETRIEVING_DOMAIN, new Object[]{domainId, "data not found"}));
                }
                throw new PentahoAccessControlException(messages.getErrorString(ERROR_0005_ERROR_RETRIEVING_DOMAIN, new Object[]{domainId, "access denied"}));
            }
            catch (Exception e) {
                if (e instanceof UnifiedRepositoryException || e instanceof PentahoAccessControlException) break block9;
                throw new UnifiedRepositoryException(messages.getErrorString(ERROR_0005_ERROR_RETRIEVING_DOMAIN, new Object[]{domainId, e.getLocalizedMessage()}), (Throwable)e);
            }
        }
        return domain;
    }

    Domain getDomain(Map<String, Serializable> fileMetadata, SimpleRepositoryFileData data) {
        String domainId = fileMetadata == null || StringUtils.isEmpty((CharSequence)((String)((Object)fileMetadata.get(PROPERTY_NAME_DOMAIN_ID)))) ? null : (String)((Object)fileMetadata.get(PROPERTY_NAME_DOMAIN_ID));
        return this.getDomain(data, domainId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Domain getDomain(SimpleRepositoryFileData data, String errorMessageId, boolean closeFile) {
        Domain domain;
        block8: {
            domain = null;
            InputStream inputStream = null;
            try {
                if (data != null) {
                    inputStream = data.getInputStream();
                    this.resetInputStream(inputStream);
                    domain = this.xmiParser.parseXmi(inputStream);
                    this.resetInputStream(inputStream);
                    break block8;
                }
                throw new UnifiedRepositoryException(messages.getErrorString(ERROR_0005_ERROR_RETRIEVING_DOMAIN, new Object[]{errorMessageId, "data not found"}));
            }
            catch (Exception e) {
                if (!(e instanceof UnifiedRepositoryException) && !(e instanceof PentahoAccessControlException)) {
                    throw new UnifiedRepositoryException(messages.getErrorString(ERROR_0005_ERROR_RETRIEVING_DOMAIN, new Object[]{errorMessageId != null ? errorMessageId : "__UNKNOWN_ID__", e.getLocalizedMessage()}), (Throwable)e);
                }
            }
            finally {
                if (closeFile) {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
        return domain;
    }

    void resetInputStream(InputStream inputStream) {
        try {
            if (inputStream != null && inputStream.markSupported()) {
                inputStream.reset();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Set<String> getDomainIds() {
        logger.debug((Object)"getDomainIds()");
        return this.getDomainIdsHelper(this.metadataMapping::getDomainIds);
    }

    @Override
    public Set<String> getMetadataDomainIds() {
        logger.debug((Object)"getMetadataDomainIds()");
        return this.getDomainIdsHelper(() -> this.dataSourceTypeMapping.getDatasourceType(PentahoDataSourceType.METADATA.toString()));
    }

    @Override
    public Set<String> getDataSourceWizardDomainIds() {
        logger.debug((Object)"getDataSourceWizardDomainIds()");
        return this.getDomainIdsHelper(() -> this.dataSourceTypeMapping.getDatasourceType(PentahoDataSourceType.DATA_SOURCE_WIZARD.toString()));
    }

    Set<String> getDomainIdsHelper(Supplier<Collection<String>> getDomainIdsFunction) {
        Collection<String> domainIds;
        logger.debug((Object)"getDomainIdsHelper()");
        this.reloadDomainsIfNeeded();
        this.lock.readLock().lock();
        try {
            domainIds = getDomainIdsFunction.get();
        }
        finally {
            this.lock.readLock().unlock();
        }
        HashSet<String> accessibleDomainIds = new HashSet<String>(domainIds.size());
        for (String domain : domainIds) {
            if (!this.hasAccessFor(domain)) continue;
            accessibleDomainIds.add(domain);
        }
        return accessibleDomainIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDomain(String domainId) {
        RepositoryFile domainFile;
        Set<RepositoryFile> domainFiles;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removeDomain(" + domainId + ")"));
        }
        if (StringUtils.isEmpty((CharSequence)domainId)) {
            throw new IllegalArgumentException(messages.getErrorString(ERROR_0004_DOMAIN_ID_INVALID, new Object[]{domainId}));
        }
        this.lock.writeLock().lock();
        try {
            domainFiles = this.metadataMapping.getFiles(domainId);
            domainFile = this.metadataMapping.getDomainFile(domainId);
            this.metadataMapping.deleteDomain(domainId);
            this.dataSourceTypeMapping.deleteDomainId(domainId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (domainFile != null) {
            this.getAclHelper().removeAclFor(domainFile);
        }
        for (RepositoryFile file : domainFiles) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Deleting repository file " + this.toString(file)));
            }
            this.repository.deleteFile(file.getId(), true, null);
        }
        if (!domainFiles.isEmpty()) {
            this.flushDomains();
        }
    }

    public void removeModel(String domainId, String modelId) throws DomainIdNullException, DomainStorageException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removeModel(" + domainId + ", " + modelId + ")"));
        }
        if (StringUtils.isEmpty((CharSequence)domainId)) {
            throw new IllegalArgumentException(messages.getErrorString(ERROR_0004_DOMAIN_ID_INVALID, new Object[]{domainId}));
        }
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            throw new IllegalArgumentException(messages.getErrorString("PentahoMetadataDomainRepository.ERROR_0006_MODEL_ID_INVALID"));
        }
        Domain domain = this.getDomain(domainId);
        if (null != domain) {
            boolean found = false;
            Iterator iter = domain.getLogicalModels().iterator();
            while (iter.hasNext()) {
                LogicalModel model = (LogicalModel)iter.next();
                if (!modelId.equals(model.getId())) continue;
                iter.remove();
                found = true;
                break;
            }
            if (found) {
                try {
                    this.storeDomain(domain, true);
                    this.flushDomains();
                }
                catch (DomainAlreadyExistsException domainAlreadyExistsException) {
                    // empty catch block
                }
            }
        }
    }

    public void reloadDomains() {
        logger.debug((Object)"reloadDomains()");
        this.internalReloadDomains();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalReloadDomains() {
        this.lock.writeLock().lock();
        try {
            this.metadataMapping.reset();
            this.dataSourceTypeMapping.reset();
            List children = this.repository.getChildren(this.getMetadataDir().getId(), "*");
            logger.trace((Object)("\tFound " + children.size() + " files in the repository"));
            for (RepositoryFile child : children) {
                if (!this.getAclHelper().canAccess(child, READ)) continue;
                Map<String, Serializable> fileMetadata = this.getFileMetadataHelper(child.getId());
                if (fileMetadata == null || StringUtils.isEmpty((CharSequence)((String)((Object)fileMetadata.get(PROPERTY_NAME_DOMAIN_ID))))) {
                    logger.warn((Object)messages.getString("PentahoMetadataDomainRepository.WARN_0001_FILE_WITHOUT_METADATA", new Object[]{child.getName()}));
                    continue;
                }
                String domainId = (String)((Object)fileMetadata.get(PROPERTY_NAME_DOMAIN_ID));
                String type = (String)((Object)fileMetadata.get(PROPERTY_NAME_TYPE));
                String locale = (String)((Object)fileMetadata.get("locale"));
                String datasourceType = (String)((Object)fileMetadata.get(PROPERTY_NAME_DATASOURCE_TYPE));
                logger.trace((Object)("\tprocessing file [type=" + type + " : domainId=" + domainId + " : locale=" + locale + "]"));
                if (StringUtils.equals((CharSequence)type, (CharSequence)TYPE_DOMAIN)) {
                    this.metadataMapping.addDomain(domainId, child);
                } else if (StringUtils.equals((CharSequence)type, (CharSequence)"locale")) {
                    this.metadataMapping.addLocale(domainId, locale, child);
                }
                if (!StringUtils.isNotEmpty((CharSequence)datasourceType)) continue;
                logger.trace((Object)String.format("\tTracking domainId: %s with datasource type: %s with id: %s", domainId, datasourceType, child.getId()));
                this.dataSourceTypeMapping.addDatasourceType(datasourceType, domainId);
            }
            this.needToReload = false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Map<String, Serializable> getFileMetadataHelper(Serializable serializableId) {
        Map<String, Serializable> fileMetadata = this.repository.getFileMetadata(serializableId);
        if (this.isDomain(fileMetadata) && !this.hasDatasourceType(fileMetadata)) {
            fileMetadata = this.migrateDomain(serializableId, fileMetadata);
        }
        return fileMetadata;
    }

    boolean isDomain(Map<String, Serializable> fileMetadata) {
        return StringUtils.isNotEmpty((CharSequence)((String)((Object)fileMetadata.get(PROPERTY_NAME_DOMAIN_ID)))) && StringUtils.equals((CharSequence)TYPE_DOMAIN, (CharSequence)((String)((Object)fileMetadata.get(PROPERTY_NAME_TYPE))));
    }

    boolean hasDatasourceType(Map<String, Serializable> fileMetadata) {
        return fileMetadata.containsKey(PROPERTY_NAME_DATASOURCE_TYPE);
    }

    Map<String, Serializable> migrateDomain(Serializable serializableId, Map<String, Serializable> fileMetadata) {
        SimpleRepositoryFileData data = (SimpleRepositoryFileData)this.repository.getDataForRead(serializableId, SimpleRepositoryFileData.class);
        this.addDataSourceType(fileMetadata, data);
        IOUtils.closeQuietly((InputStream)data.getInputStream());
        this.repository.setFileMetadata(serializableId, fileMetadata);
        logger.info((Object)String.format("migrateDomain(serializableId: %s,..) domain-id: %s, assigning datasource-type: %s", serializableId.toString(), (String)((Object)fileMetadata.get(PROPERTY_NAME_DOMAIN_ID)), (String)((Object)fileMetadata.get(PROPERTY_NAME_DATASOURCE_TYPE))));
        return fileMetadata;
    }

    public void flushDomains() {
        logger.debug((Object)"flushDomains()");
        this.internalReloadDomains();
    }

    public String generateRowLevelSecurityConstraint(LogicalModel model) {
        return null;
    }

    public boolean hasAccess(int accessType, IConcept aclHolder) {
        return true;
    }

    public void addLocalizationFile(String domainId, String locale, Properties properties) throws DomainStorageException {
        if (null != properties) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                properties.store(out, null);
                this.addLocalizationFile(domainId, locale, new ByteArrayInputStream(((Object)out).toString().getBytes()), true);
            }
            catch (IOException e) {
                throw new DomainStorageException(messages.getErrorString("PentahoMetadataDomainRepository.ERROR_0008_ERROR_IN_REPOSITORY", new Object[]{e.getLocalizedMessage()}), (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLocalizationFile(String domainId, String locale, InputStream inputStream, boolean overwrite) throws DomainStorageException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("addLocalizationFile(" + domainId + ", " + locale + ", inputStream)"));
        }
        if (null != inputStream) {
            if (StringUtils.isEmpty((CharSequence)domainId) || StringUtils.isEmpty((CharSequence)locale)) {
                throw new IllegalArgumentException(messages.getErrorString(ERROR_0004_DOMAIN_ID_INVALID, new Object[]{domainId}));
            }
            this.lock.writeLock().lock();
            try {
                RepositoryFile localeFile = this.metadataMapping.getLocaleFile(domainId, locale);
                if (!overwrite && localeFile != null) {
                    throw new DomainStorageException(messages.getErrorString("PentahoMetadataDomainRepository.ERROR_0009_LOCALE_ALREADY_EXISTS", new Object[]{domainId, locale}), null);
                }
                SimpleRepositoryFileData data = new SimpleRepositoryFileData(inputStream, DEFAULT_ENCODING, LOCALE_MIME_TYPE);
                if (localeFile == null) {
                    RepositoryFile newLocaleFile = this.createUniqueFile(domainId, locale, data);
                    this.metadataMapping.addLocale(domainId, locale, newLocaleFile);
                } else {
                    this.updateFile(localeFile, data);
                }
                this.flushDomains();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    protected RepositoryFile getMetadataDir() {
        String metadataDirName = PentahoMetadataDomainRepositoryInfo.getMetadataFolderPath();
        return this.repository.getFile(metadataDirName);
    }

    protected void loadLocaleStrings(String domainId, Domain domain) {
        Map<String, RepositoryFile> localeFiles = this.metadataMapping.getLocaleFiles(domainId);
        if (localeFiles != null) {
            for (String locale : localeFiles.keySet()) {
                RepositoryFile localeFile = localeFiles.get(locale);
                Properties properties = this.loadProperties(localeFile);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("\tLoading properties [" + domain + " : " + locale + "]"));
                }
                this.localizationUtil.importLocalizedProperties(domain, properties, locale);
            }
        }
    }

    protected Properties loadProperties(RepositoryFile bundle) {
        try {
            Properties properties = null;
            SimpleRepositoryFileData bundleData = (SimpleRepositoryFileData)this.repository.getDataForRead(bundle.getId(), SimpleRepositoryFileData.class);
            if (bundleData != null) {
                properties = new Properties();
                properties.load(bundleData.getStream());
            } else if (logger.isWarnEnabled()) {
                logger.warn((Object)("Could not load properties from repository file: " + bundle.getName()));
            }
            return properties;
        }
        catch (IOException e) {
            throw new UnifiedRepositoryException(messages.getErrorString("PentahoMetadataDomainRepository.ERROR_0008_ERROR_IN_REPOSITORY", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    boolean isMetadataDataSource(Domain domain) {
        return domain.getLogicalModels() == null || !this.isDSWDatasource(domain);
    }

    boolean isDSWDatasource(Domain domain) {
        return domain.getLogicalModels() != null && domain.getLogicalModels().stream().anyMatch(lm -> lm.getProperty("AGILE_BI_GENERATED_SCHEMA") != null || lm.getProperty("WIZARD_GENERATED_SCHEMA") != null);
    }

    protected void addDataSourceType(Map<String, Serializable> fileMetadata, SimpleRepositoryFileData data) {
        Domain domain = this.getDomain(fileMetadata, data);
        if (domain != null) {
            fileMetadata.put(PROPERTY_NAME_DATASOURCE_TYPE, (Serializable)((Object)(this.isMetadataDataSource(domain) ? PentahoDataSourceType.METADATA.toString() : PentahoDataSourceType.DATA_SOURCE_WIZARD.toString())));
        }
    }

    protected RepositoryFile createUniqueFile(String domainId, String locale, SimpleRepositoryFileData data) {
        return this.createUniqueFile(UUID.randomUUID().toString(), domainId, locale, data);
    }

    protected RepositoryFile createUniqueFile(String filename, String domainId, String locale, SimpleRepositoryFileData data) {
        HashMap<String, Serializable> metadataMap = new HashMap<String, Serializable>();
        metadataMap.put(PROPERTY_NAME_DOMAIN_ID, (Serializable)((Object)domainId));
        if (StringUtils.isEmpty((CharSequence)locale)) {
            metadataMap.put(PROPERTY_NAME_TYPE, (Serializable)((Object)TYPE_DOMAIN));
        } else {
            metadataMap.put(PROPERTY_NAME_TYPE, (Serializable)((Object)"locale"));
            metadataMap.put("locale", (Serializable)((Object)locale));
        }
        this.addDataSourceType(metadataMap, data);
        RepositoryFile file = this.repository.createFile(this.getMetadataDir().getId(), new RepositoryFile.Builder(filename).build(), (IRepositoryFileData)data, null);
        this.repository.setFileMetadata(file.getId(), metadataMap);
        return file;
    }

    public RepositoryFile updateFile(RepositoryFile domainFile, SimpleRepositoryFileData data) {
        Map fileMetadata = this.repository.getFileMetadata(domainFile.getId());
        this.addDataSourceType(fileMetadata, data);
        this.repository.setFileMetadata(domainFile.getId(), fileMetadata);
        return this.repository.updateFile(domainFile, (IRepositoryFileData)data, null);
    }

    protected IUnifiedRepository getRepository() {
        return this.repository;
    }

    protected XmiParser getXmiParser() {
        return this.xmiParser;
    }

    protected RepositoryUtils getRepositoryUtils() {
        return this.repositoryUtils;
    }

    protected LocalizationUtil getLocalizationUtil() {
        return this.localizationUtil;
    }

    protected void setRepository(IUnifiedRepository repository) {
        this.repository = repository;
    }

    protected void setXmiParser(XmiParser xmiParser) {
        this.xmiParser = xmiParser != null ? xmiParser : new XmiParser();
    }

    protected void setRepositoryUtils(RepositoryUtils repositoryUtils) {
        this.repositoryUtils = repositoryUtils != null ? repositoryUtils : new RepositoryUtils(this.repository);
    }

    protected void setLocalizationUtil(LocalizationUtil localizationUtil) {
        this.localizationUtil = localizationUtil != null ? localizationUtil : new LocalizationUtil();
    }

    protected String toString(RepositoryFile file) {
        try {
            Map fileMetadata = this.repository.getFileMetadata(file.getId());
            return "[type=" + fileMetadata.get(PROPERTY_NAME_TYPE) + " : domain=" + fileMetadata.get(PROPERTY_NAME_DOMAIN_ID) + " : locale=" + fileMetadata.get("locale") + " : filename=" + file.getName() + "]";
        }
        catch (Throwable throwable) {
            return "null";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RepositoryFile getMetadataRepositoryFile(String domainId) {
        RepositoryFile domainFile;
        this.lock.readLock().lock();
        try {
            domainFile = this.metadataMapping.getDomainFile(domainId);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (domainFile == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Requested Domain (" + domainId + ") wasn't found in Metadata Mapping. Domain cache will be reloaded"));
            }
            this.lock.writeLock().lock();
            try {
                domainFile = this.metadataMapping.getDomainFile(domainId);
                if (domainFile == null) {
                    this.reloadDomainsIfNeeded();
                    domainFile = this.metadataMapping.getDomainFile(domainId);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        if (domainFile == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Even after reloading all domains, the specified Domain wasn't found in the system: " + domainId));
        }
        return domainFile;
    }

    private void reloadDomainsIfNeeded() {
        this.lock.writeLock().lock();
        try {
            if (this.needToReload) {
                this.internalReloadDomains();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static synchronized PentahoMetadataInformationMap getMetadataMapping(IUnifiedRepository repository) {
        PentahoMetadataInformationMap metaMap = metaMapStore.get(repository);
        if (null == metaMap) {
            metaMap = new PentahoMetadataInformationMap();
            metaMapStore.put(repository, metaMap);
        }
        return metaMap;
    }

    @Override
    public String loadAnnotationsXml(String domainId) {
        if (StringUtils.isBlank((CharSequence)domainId)) {
            return null;
        }
        try {
            RepositoryFile domainFile = this.getMetadataRepositoryFile(domainId);
            RepositoryFile annotationFile = this.getRepository().getFile(this.resolveAnnotationsFilePath(domainFile));
            SimpleRepositoryFileData data = (SimpleRepositoryFileData)this.getRepository().getDataForRead(annotationFile.getId(), SimpleRepositoryFileData.class);
            return IOUtils.toString((InputStream)data.getInputStream());
        }
        catch (Exception e) {
            this.getLogger().warn((Object)("Unable to load annotations xml file for domain: " + domainId));
            return null;
        }
    }

    @Override
    public void storeAnnotationsXml(String domainId, String annotationsXml) {
        if (StringUtils.isBlank((CharSequence)domainId) || StringUtils.isBlank((CharSequence)annotationsXml)) {
            return;
        }
        RepositoryFile domainFile = this.getMetadataRepositoryFile(domainId);
        RepositoryFile annotationsFile = this.getAnnotationsXmlFile(domainFile);
        this.createOrUpdateAnnotationsXml(domainFile, annotationsFile, annotationsXml);
    }

    public RepositoryFile getAnnotationsXmlFile(RepositoryFile domainFile) {
        if (domainFile == null) {
            return null;
        }
        RepositoryFile annotationsFile = null;
        try {
            annotationsFile = this.getRepository().getFile(this.resolveAnnotationsFilePath(domainFile));
        }
        catch (Exception e) {
            this.getLogger().warn((Object)("Unable to find annotations xml file for: " + domainFile.getId()));
        }
        return annotationsFile;
    }

    public void createOrUpdateAnnotationsXml(RepositoryFile domainFile, RepositoryFile annotationsFile, String annotationsXml) {
        if (domainFile == null) {
            return;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(annotationsXml.getBytes(DEFAULT_ENCODING));
            SimpleRepositoryFileData data = new SimpleRepositoryFileData((InputStream)in, DEFAULT_ENCODING, DOMAIN_MIME_TYPE);
            if (annotationsFile == null) {
                String filename = domainFile.getId() + "-annotations";
                this.getRepository().createFile(this.getMetadataDir().getId(), new RepositoryFile.Builder(filename).build(), (IRepositoryFileData)data, null);
            } else {
                this.getRepository().updateFile(annotationsFile, (IRepositoryFileData)data, null);
            }
        }
        catch (Exception e) {
            this.getLogger().warn((Object)"Unable to save annotations xml", (Throwable)e);
        }
    }

    protected String resolveAnnotationsFilePath(RepositoryFile domainFile) {
        if (this.getMetadataDir() != null && domainFile != null) {
            return this.getMetadataDir().getPath() + "/" + domainFile.getId() + "-annotations";
        }
        return null;
    }

    protected Log getLogger() {
        return logger;
    }
}

