/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.springframework.util.Assert;

public class PentahoMetadataFileInfo {
    private static Log log = LogFactory.getLog(PentahoMetadataFileInfo.class);
    private static final Pattern[] xmiPatterns = new Pattern[]{Pattern.compile(".*/([^/]+/resources/metadata/[^/]+\\.xmi)$"), Pattern.compile(".*/([^/]+)/metadata.xmi$")};
    private static final String LANG = "[a-z]{2}";
    private static final String LANG_CC = "[a-z]{2}_[A-Z]{2}";
    private static final String LANG_CC_EXT = "[a-z]{2}_[A-Z]{2}_[^/]+";
    private static final String PROPERTY_BUNDLE_DOMAIN_POSTFIX = ".xmi";
    private static final Pattern[] propertyBundlePatternsWithPostfix = new Pattern[]{Pattern.compile(".*/([^/]+/resources/metadata/[^/]+)_([a-z]{2})\\.properties$"), Pattern.compile(".*/([^/]+/resources/metadata/[^/]+)_([a-z]{2}_[A-Z]{2})\\.properties$"), Pattern.compile(".*/([^/]+/resources/metadata/[^/]+)_([a-z]{2}_[A-Z]{2}_[^/]+)\\.properties$")};
    private static final Pattern[] propertyBundlePatternsNoPostfix = new Pattern[]{Pattern.compile(".*/([^/]+)/metadata_([a-z]{2}).properties$"), Pattern.compile(".*/([^/]+)/metadata_([a-z]{2}_[A-Z]{2}).properties$"), Pattern.compile(".*/([^/]+)/metadata_([a-z]{2}_[A-Z]{2}_[^/]+).properties$"), Pattern.compile(".*/([^/]+)_([a-z]{2})\\.properties$"), Pattern.compile(".*/([^/]+)_([a-z]{2}_[A-Z]{2})\\.properties$"), Pattern.compile(".*/([^/]+)_([a-z]{2}_[A-Z]{2}_[^/]+)\\.properties$")};
    private FileType fileType;
    private String locale;
    private String domainId;
    private String path;

    public FileType getFileType() {
        return this.fileType;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getPath() {
        return this.path;
    }

    public PentahoMetadataFileInfo(String path) {
        block3: {
            Matcher propertyBundleMatcher;
            String fileExtension;
            String internalPath;
            block4: {
                this.path = path;
                this.fileType = FileType.UNKNOWN;
                internalPath = RepositoryFilenameUtils.normalize((String)path, (boolean)true);
                if (StringUtils.isEmpty((String)internalPath)) break block3;
                fileExtension = RepositoryFilenameUtils.getExtension((String)path);
                if (!StringUtils.equals((String)fileExtension, (String)"xmi")) break block4;
                for (Pattern xmiPattern : xmiPatterns) {
                    Matcher xmiMatcher = xmiPattern.matcher(internalPath);
                    if (!xmiMatcher.matches()) continue;
                    log.trace((Object)("MATCH: [" + internalPath + "] by [" + xmiPattern.pattern() + "] - group(s)=[" + xmiMatcher.group(1) + "]"));
                    this.initialize(FileType.XMI, xmiMatcher.group(1), null);
                    break block3;
                }
                break block3;
            }
            if (!StringUtils.equals((String)fileExtension, (String)"properties")) break block3;
            for (Pattern propertyBundlePattern : propertyBundlePatternsNoPostfix) {
                propertyBundleMatcher = propertyBundlePattern.matcher(internalPath);
                if (!propertyBundleMatcher.matches()) continue;
                log.trace((Object)("MATCH: [" + internalPath + "] by [" + propertyBundleMatcher.pattern() + "] - group(s)=[" + propertyBundleMatcher.group(1) + " : " + propertyBundleMatcher.group(2) + "]"));
                this.initialize(FileType.PROPERTIES, propertyBundleMatcher.group(1), propertyBundleMatcher.group(2));
                break;
            }
            for (Pattern propertyBundlePattern : propertyBundlePatternsWithPostfix) {
                propertyBundleMatcher = propertyBundlePattern.matcher(internalPath);
                if (!propertyBundleMatcher.matches()) continue;
                log.trace((Object)("MATCH: [" + internalPath + "] by [" + propertyBundleMatcher.pattern() + "] - group(s)=[" + propertyBundleMatcher.group(1) + " : " + propertyBundleMatcher.group(2) + "]"));
                this.initialize(FileType.PROPERTIES, propertyBundleMatcher.group(1) + PROPERTY_BUNDLE_DOMAIN_POSTFIX, propertyBundleMatcher.group(2));
                break;
            }
        }
    }

    protected void initialize(FileType fileType, String domainId, String locale) {
        Assert.hasText((String)domainId);
        Assert.isTrue((locale == null || !StringUtils.isEmpty((String)locale) ? 1 : 0) != 0);
        this.fileType = fileType;
        this.domainId = domainId;
        this.locale = locale;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("PentahoMetadataFileInfo[fileType=");
        switch (this.fileType) {
            case UNKNOWN: {
                s.append("unknown");
                break;
            }
            case XMI: {
                s.append("XMI : domainID=").append(this.domainId);
                break;
            }
            case PROPERTIES: {
                s.append("PROPERTIES : domainID=").append(this.domainId).append(" : locale=").append(this.locale);
            }
        }
        s.append(" : path=").append(this.path).append("]");
        return s.toString();
    }

    public static enum FileType {
        XMI,
        PROPERTIES,
        UNKNOWN;

    }
}

