/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.pentaho.platform.api.util.LogUtil;
import org.pentaho.platform.plugin.services.importexport.RepositoryImportHTMLLayout;
import org.slf4j.MDC;

public class Log4JRepositoryImportLog {
    private Logger logger;
    static final String FILE_KEY = "currentFile";
    private OutputStream outputStream;
    private String currentFilePath;
    private String logName;
    private String importRootPath;
    private Level logLevel;
    private Appender appender;

    Log4JRepositoryImportLog(OutputStream outputStream, String importRootPath, Level logLevel) {
        this.outputStream = outputStream;
        this.importRootPath = importRootPath;
        this.logLevel = logLevel;
        this.init();
    }

    private void init() {
        this.logName = "RepositoryImportLog." + this.getThreadName();
        this.logger = LogManager.getLogger((String)this.logName);
        LogUtil.setLevel((Logger)this.logger, (Level)this.logLevel);
        RepositoryImportHTMLLayout htmlLayout = new RepositoryImportHTMLLayout(this.logLevel);
        htmlLayout.setTitle("Repository Import Log");
        this.appender = LogUtil.makeAppender((String)this.logName, (Writer)new OutputStreamWriter(this.outputStream, Charset.forName("utf-8")), (Layout)htmlLayout);
        LogUtil.addAppender((Appender)this.appender, (Logger)this.logger, (Level)this.logLevel);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getCurrentFilePath() {
        return this.currentFilePath;
    }

    public void setCurrentFilePath(String currentFilePath) {
        this.currentFilePath = currentFilePath;
        MDC.put((String)FILE_KEY, (String)currentFilePath);
    }

    public String getImportRootPath() {
        return this.importRootPath;
    }

    protected void endJob() {
        try {
            this.outputStream.write(this.appender.getLayout().getFooter());
        }
        catch (Exception e) {
            System.out.println(e);
        }
        LogUtil.removeAppender((Appender)this.appender, (Logger)this.logger);
    }

    private String getThreadName() {
        return Thread.currentThread().getName();
    }
}

