/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFileExtraMetaData;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportFileHandler;
import org.pentaho.platform.plugin.services.importexport.IRepositoryImportLogger;
import org.pentaho.platform.plugin.services.importexport.exportManifest.ExportManifest;
import org.pentaho.platform.plugin.services.importexport.exportManifest.ExportManifestEntity;

public class ImportSession {
    private static final ThreadLocal<ImportSession> sessions = new ThreadLocal();
    private HashSet<String> skippedFiles = new HashSet();
    private final HashSet<String> foldersCreatedImplicitly = new HashSet();
    private Log log;
    private Boolean isNotRunningImport = true;
    private ExportManifest manifest;
    private boolean applyAclSettings;
    private boolean retainOwnership;
    private boolean overwriteAclSettings;
    private String currentManifestKey;
    private final HashSet<RepositoryFile> importedRepositoryFiles = new HashSet();
    private final List<String> importedScheduleJobIds = new ArrayList<String>();
    public static IPlatformImporter iPlatformImporter;

    public static ImportSession getSession() {
        ImportSession session = sessions.get();
        if (session == null) {
            session = new ImportSession();
            sessions.set(session);
        }
        return session;
    }

    public void initialize() {
        this.importedRepositoryFiles.clear();
        this.importedScheduleJobIds.clear();
        this.skippedFiles.clear();
        this.foldersCreatedImplicitly.clear();
    }

    public Log getLogger() {
        if (this.log == null) {
            IRepositoryImportLogger logger;
            if (iPlatformImporter == null) {
                iPlatformImporter = (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
            }
            if ((logger = iPlatformImporter.getRepositoryImportLogger()) != null && logger.hasLogger()) {
                this.log = logger;
                this.isNotRunningImport = false;
            } else {
                this.log = LogFactory.getLog(RepositoryFileImportFileHandler.class);
                this.isNotRunningImport = true;
            }
        }
        return this.log;
    }

    @Deprecated
    public Boolean isFileHidden(String filePath) {
        return this.getManifestFile(filePath, true).isFileHidden();
    }

    public ManifestFile getManifestFile(String filePath, boolean isFileExist) {
        return new ManifestFile(filePath, isFileExist);
    }

    public RepositoryFileAcl processAclForFile(String filePath) {
        RepositoryFileAcl acl = null;
        if (this.applyAclSettings || !this.retainOwnership) {
            try {
                ExportManifestEntity entity;
                if (this.manifest != null && (entity = this.manifest.getExportManifestEntity(filePath)) != null) {
                    acl = entity.getRepositoryFileAcl();
                }
            }
            catch (Exception e) {
                this.getLogger().trace((Object)e);
            }
        }
        return acl;
    }

    public RepositoryFileExtraMetaData processExtraMetaDataForFile(String filePath) {
        RepositoryFileExtraMetaData extraMetaData = null;
        try {
            ExportManifestEntity entity;
            if (this.manifest != null && (entity = this.manifest.getExportManifestEntity(filePath)) != null) {
                extraMetaData = entity.getRepositoryFileExtraMetaData();
            }
        }
        catch (Exception e) {
            this.getLogger().trace((Object)e);
        }
        return extraMetaData;
    }

    public HashSet<String> getSkippedFiles() {
        return this.skippedFiles;
    }

    public void setSkippedFiles(HashSet<String> skippedFiles) {
        this.skippedFiles = skippedFiles;
    }

    public Boolean getIsNotRunningImport() {
        return this.isNotRunningImport;
    }

    public ExportManifest getManifest() {
        return this.manifest;
    }

    public void setManifest(ExportManifest manifest) {
        this.manifest = manifest;
    }

    public boolean isApplyAclSettings() {
        return this.applyAclSettings;
    }

    public void setApplyAclSettings(boolean applyAclSettings) {
        this.applyAclSettings = applyAclSettings;
    }

    public boolean isRetainOwnership() {
        return this.retainOwnership;
    }

    public void setRetainOwnership(boolean retainOwnership) {
        this.retainOwnership = retainOwnership;
    }

    public boolean isOverwriteAclSettings() {
        return this.overwriteAclSettings;
    }

    public void setOverwriteAclSettings(boolean overwriteAclSettings) {
        this.overwriteAclSettings = overwriteAclSettings;
    }

    public String getCurrentManifestKey() {
        return this.currentManifestKey;
    }

    public void setCurrentManifestKey(String currentManifestKey) {
        this.currentManifestKey = currentManifestKey;
    }

    public HashSet<String> getFoldersCreatedImplicitly() {
        return this.foldersCreatedImplicitly;
    }

    public void setAclProperties(boolean applyAclSettingsFlag, boolean retainOwnershipFlag, boolean overwriteAclSettingsFlag) {
        this.setApplyAclSettings(applyAclSettingsFlag);
        this.setRetainOwnership(retainOwnershipFlag);
        this.setOverwriteAclSettings(overwriteAclSettingsFlag);
    }

    public void addImportedRepositoryFile(RepositoryFile repositoryFile) {
        this.importedRepositoryFiles.add(repositoryFile);
    }

    public HashSet<RepositoryFile> getImportedRepositoryFiles() {
        return this.importedRepositoryFiles;
    }

    public void addImportedScheduleJobId(String jobId) {
        this.importedScheduleJobIds.add(jobId);
    }

    public List<String> getImportedScheduleJobIds() {
        return this.importedScheduleJobIds;
    }

    public static void clearSession() {
        ImportSession session = sessions.get();
        if (session != null) {
            sessions.remove();
        }
    }

    public class ManifestFile {
        private RepositoryFile rf;

        private ManifestFile(String filePath, boolean isFileExist) {
            ExportManifestEntity entity;
            if (!(isFileExist && !ImportSession.this.applyAclSettings && ImportSession.this.retainOwnership || ImportSession.this.manifest == null || (entity = ImportSession.this.manifest.getExportManifestEntity(filePath)) == null)) {
                this.rf = entity.getRepositoryFile();
            }
        }

        public Boolean isFileHidden() {
            return this.rf == null ? null : this.rf.isHidden();
        }

        public Boolean isFileSchedulable() {
            return this.rf == null ? null : this.rf.isSchedulable();
        }
    }
}

